/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

class FileLoggingHandler
extends Handler {
    private Formatter mFormatter;
    private PrintWriter mWriter;

    public FileLoggingHandler(String fName, Formatter formatter) throws IOException {
        this.mFormatter = formatter;
        File f = new File(fName);
        this.mWriter = new PrintWriter(new FileOutputStream(f));
    }

    @Override
    public void close() throws SecurityException {
        this.mWriter.close();
    }

    @Override
    public void flush() {
        this.mWriter.flush();
    }

    @Override
    public void publish(LogRecord record) {
        this.mWriter.println(this.mFormatter.format(record));
        this.flush();
    }
}

