/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.Set;

public class ProgramItem
implements Comparable<ProgramItem> {
    private Program mProgram;
    private Properties mProperties;
    private transient String mProgId;
    private transient Date mDate;

    public ProgramItem(Program prog) {
        this.mProgram = prog;
        this.mProperties = null;
    }

    public ProgramItem() {
        this(null);
    }

    public void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readInt();
        this.mDate = Date.readData(in);
        this.mProgId = (String)in.readObject();
        int keyCnt = in.readInt();
        if (keyCnt > 0) {
            this.mProperties = new Properties();
        }
        for (int i = 0; i < keyCnt; ++i) {
            String key = (String)in.readObject();
            String value = (String)in.readObject();
            this.mProperties.put(key, value);
        }
    }

    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        if (this.mDate != null) {
            this.mDate.writeData((DataOutput)out);
        } else {
            this.mProgram.getDate().writeData((DataOutput)out);
        }
        if (this.mProgId != null) {
            out.writeObject(this.mProgId);
        } else {
            out.writeObject(this.mProgram.getID());
        }
        if (this.mProperties == null) {
            out.writeInt(0);
        } else {
            Set<Object> keys = this.mProperties.keySet();
            out.writeInt(keys.size());
            for (String string : keys) {
                String value = (String)this.mProperties.get(string);
                out.writeObject(string);
                out.writeObject(value);
            }
        }
    }

    public void setProgram(Program prog) {
        this.mProgram = prog;
    }

    public Program getProgram() {
        if (this.mProgram == null) {
            this.mProgram = Plugin.getPluginManager().getProgram(this.mDate, this.mProgId);
        }
        return this.mProgram;
    }

    public void setProperty(String key, String value) {
        if (this.mProperties == null) {
            this.mProperties = new Properties();
        }
        this.mProperties.put(key, value);
    }

    public String getProperty(String key) {
        if (this.mProperties == null) {
            return null;
        }
        return (String)this.mProperties.get(key);
    }

    public String toString() {
        return this.mProgram.getTitle();
    }

    public Date getDate() {
        if (this.mDate != null) {
            return this.mDate;
        }
        return this.getProgram().getDate();
    }

    public int getStartTime() {
        String minutes;
        int hoursNum;
        if (this.mProgram != null) {
            return this.getProgram().getStartTime();
        }
        int underscore = this.mProgId.lastIndexOf(95);
        String hours = this.mProgId.substring(underscore + 1, underscore + 3);
        if (hours.charAt(1) == ':') {
            hoursNum = hours.charAt(0) - 48;
            minutes = this.mProgId.substring(underscore + 3, underscore + 5);
        } else {
            hoursNum = Integer.parseInt(hours);
            minutes = this.mProgId.substring(underscore + 4, underscore + 6);
        }
        int minutesNum = minutes.charAt(1) == ':' ? minutes.charAt(0) - 48 : Integer.parseInt(minutes);
        return hoursNum * 60 + minutesNum;
    }

    @Override
    public int compareTo(ProgramItem other) {
        int t2;
        int result = this.getDate().compareTo(other.getDate());
        if (result != 0) {
            return result;
        }
        int t1 = this.getStartTime();
        if (t1 < (t2 = other.getStartTime())) {
            return -1;
        }
        if (t1 > t2) {
            return 1;
        }
        return 0;
    }
}

