/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Domain;
import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.PasswordAnalyser;
import com.ehsunbehravesh.mypasswords.RealtimePasswordValidator;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.VersionChecker;
import com.ehsunbehravesh.mypasswords.entity.PasswordEntry;
import com.ehsunbehravesh.mypasswords.entity.PasswordTag;
import com.ehsunbehravesh.mypasswords.gui.AboutDialog;
import com.ehsunbehravesh.mypasswords.gui.BrowseDialog2;
import com.ehsunbehravesh.mypasswords.gui.ChangePasswordDialog2;
import com.ehsunbehravesh.mypasswords.gui.EncryptionDialog;
import com.ehsunbehravesh.mypasswords.gui.ImportDialog;
import com.ehsunbehravesh.mypasswords.gui.LoginDialog;
import com.ehsunbehravesh.mypasswords.gui.PasswordGeneratorDialog;
import com.ehsunbehravesh.mypasswords.gui.RequestFocusListener;
import com.ehsunbehravesh.mypasswords.gui.SearchDialog;
import com.ehsunbehravesh.mypasswords.gui.SettingsDialog;
import com.ehsunbehravesh.mypasswords.gui.XMLFileFilter;
import com.ehsunbehravesh.mypasswords.multilingual.LanguageException;
import com.ehsunbehravesh.mypasswords.multilingual.LanguageManager;
import com.ehsunbehravesh.mypasswords.resource.ExportDialog;
import com.ehsunbehravesh.mypasswords.resource.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.xml.parsers.ParserConfigurationException;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.RoundedBalloonStyle;
import net.java.balloontip.utils.TimingUtils;
import org.xml.sax.SAXException;

public class MainFrame
extends JFrame
implements ClipboardOwner {
    private static final Color StatusNewColor = new Color(102, 153, 255);
    private static final Color StatusUpdateColor = new Color(0, 204, 51);
    private PasswordEntry passwordEntry;
    private boolean showPassword;
    private boolean showTitleBaloon;
    private Timer lockTimer;
    private boolean locked;
    private AboutDialog aboutDialog;
    private PasswordGeneratorDialog passwordGeneratorDialog;
    private JComboBox cmbLanguages;
    private Timer timerToolbarDecoration;
    private String selectedLanguage;
    private String[] availableLanguages;
    private String newPasswordCaption = "New Password";
    private String updatePasswordCaption = "Update Password";
    private Properties englishLanguage;
    private Properties currentLanguage;
    private String invalidDecryptionKey = "Invalid Decryption Key!";
    private String areAllFieldsEncrypted = "Are all fields encrypted?";
    private String pleaseEnterTheKey = "Please enter the key which you have encrypted the file with:";
    private String deletedSuccessfully = "Password deleted successfully.";
    private String errorOccured = "Error occured! Please see the log file for more details.";
    private String doYouWantToDelete = "<html>Do you want to delete the <b>%s</b> password?</html>";
    private String deleteCaption = "Delete";
    private String errorCaption = "Error";
    private String informationCaption = "Information";
    private String passwordSaved = "Password saved successfully.";
    private String warningCaption = "Warning";
    private String youMustChooseATitle = "You must choose a title!";
    private String selectAFileNot = "Select a file, not a directory!";
    private String invalidFileExtension = "Invalid file extension!";
    private String decryptionKey = "Decryption Key";
    private String security = "Security";
    private String yesCaption = "Yes";
    private String noCaption = "No";
    private String okCaption = "OK";
    private String cancelCaption = "Cancel";
    private String confirmDoesNotMatch = "Confirmation password does not match!";
    private RealtimePasswordValidator passVal;
    private boolean surveyDisplayed = false;
    private JButton btnAbout;
    private JButton btnBrows;
    private JButton btnChangePassword;
    private JButton btnDelete;
    private JButton btnEncryptor;
    private JButton btnExport;
    private JButton btnImport;
    private JButton btnNew;
    private JButton btnPasswordGenerator;
    private JButton btnSave;
    private JButton btnSearch;
    private JButton btnSettings;
    private JToggleButton btnShowPassword;
    private JLabel confValLabel;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel14;
    private JLabel jLabel8;
    private JLabel lblConfirmation;
    private JLabel lblConfirmation2;
    private JLabel lblDescription;
    private JLabel lblPassword;
    private JLabel lblPassword2;
    private JLabel lblStatus;
    private JLabel lblStrength;
    private JLabel lblStrength2;
    private JLabel lblTags;
    private JLabel lblTitle;
    private JLabel lblURL;
    private JLabel lblUsername;
    private JPanel pnlMain;
    private JToolBar tlbMain;
    private JPasswordField txtConfirmation;
    private JTextField txtDescription;
    private JPasswordField txtPassword;
    private JTextField txtTags;
    private JTextField txtTitle;
    private JTextField txtURL;
    private JTextField txtUsername;
    private JPopupMenu mnuPassword;
    private JMenuItem mniCopy;
    private JMenuItem mniPaste;

    public MainFrame(AboutDialog aboutDialog, PasswordGeneratorDialog passwordGeneratorDialog) {
        try {
            this.aboutDialog = aboutDialog;
            this.passwordGeneratorDialog = passwordGeneratorDialog;
            this.initComponents();
            this.myInitComponents();
            this.loadOptions();
        }
        catch (Exception ex) {
            Logger.log(ex.getMessage());
        }
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(this, "Connection to the database failed!", "Error", 0);
            System.exit(0);
        }
        String checkNewVersion = domain.getSetting("check_updates", null);
        if (checkNewVersion == null || checkNewVersion.equalsIgnoreCase("true")) {
            try {
                this.checkForNewerVersion();
            }
            catch (Exception ex) {
                Logger.log(ex.getMessage());
            }
        }
        this.locked = false;
        this.lockTimer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.lockTimerActionPerformed();
            }
        });
        this.lockTimer.start();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.tlbMain = new JToolBar();
        this.jLabel8 = new JLabel();
        this.btnShowPassword = new JToggleButton();
        this.btnDelete = new JButton();
        this.btnSearch = new JButton();
        this.btnBrows = new JButton();
        this.jLabel14 = new JLabel();
        this.btnImport = new JButton();
        this.btnExport = new JButton();
        this.jLabel10 = new JLabel();
        this.btnChangePassword = new JButton();
        this.btnPasswordGenerator = new JButton();
        this.btnEncryptor = new JButton();
        this.jLabel11 = new JLabel();
        this.btnSettings = new JButton();
        this.btnAbout = new JButton();
        this.lblStatus = new JLabel();
        this.lblTitle = new JLabel();
        this.txtTitle = new JTextField();
        this.lblDescription = new JLabel();
        this.txtDescription = new JTextField();
        this.lblUsername = new JLabel();
        this.txtUsername = new JTextField();
        this.lblPassword2 = new JLabel();
        this.txtPassword = new JPasswordField();
        this.lblPassword = new JLabel();
        this.lblConfirmation2 = new JLabel();
        this.txtConfirmation = new JPasswordField();
        this.lblConfirmation = new JLabel();
        this.lblStrength2 = new JLabel();
        this.lblStrength = new JLabel();
        this.lblURL = new JLabel();
        this.txtURL = new JTextField();
        this.lblTags = new JLabel();
        this.txtTags = new JTextField();
        this.btnSave = new JButton();
        this.btnNew = new JButton();
        this.confValLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("MyPasswords");
        this.setBackground(new Color(255, 255, 255));
        this.setFont(new Font("Tahoma", 0, 12));
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.formMouseClicked(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainFrame.this.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                MainFrame.this.formWindowOpened(evt);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MainFrame.this.formFocusGained(evt);
            }
        });
        this.pnlMain.setBackground(new Color(255, 255, 255));
        this.tlbMain.setBackground(new Color(255, 255, 255));
        this.tlbMain.setFloatable(false);
        this.tlbMain.setRollover(true);
        this.jLabel8.setText("  ");
        this.tlbMain.add(this.jLabel8);
        this.btnShowPassword.setBackground(new Color(255, 255, 255));
        this.btnShowPassword.setMnemonic(114);
        this.btnShowPassword.setText("show");
        this.btnShowPassword.setToolTipText("Show Password (ALT + F3)");
        this.btnShowPassword.setFocusable(false);
        this.btnShowPassword.setHorizontalTextPosition(0);
        this.btnShowPassword.setVerticalTextPosition(3);
        this.btnShowPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnShowPasswordActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnShowPassword);
        this.btnDelete.setBackground(new Color(255, 255, 255));
        this.btnDelete.setMnemonic(127);
        this.btnDelete.setText("delete");
        this.btnDelete.setToolTipText("Delete Password (ALT + DELETE)");
        this.btnDelete.setEnabled(false);
        this.btnDelete.setFocusable(false);
        this.btnDelete.setHorizontalTextPosition(0);
        this.btnDelete.setVerticalTextPosition(3);
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnDeleteActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnDelete);
        this.btnSearch.setBackground(new Color(255, 255, 255));
        this.btnSearch.setMnemonic(70);
        this.btnSearch.setText("search");
        this.btnSearch.setToolTipText("Search (ALT + F)");
        this.btnSearch.setFocusable(false);
        this.btnSearch.setHorizontalTextPosition(0);
        this.btnSearch.setVerticalTextPosition(3);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnSearchActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnSearch);
        this.btnBrows.setBackground(new Color(255, 255, 255));
        this.btnBrows.setMnemonic(84);
        this.btnBrows.setText("browse");
        this.btnBrows.setToolTipText("Browse (ALT + T)");
        this.btnBrows.setFocusable(false);
        this.btnBrows.setHorizontalTextPosition(0);
        this.btnBrows.setVerticalTextPosition(3);
        this.btnBrows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnBrowsActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnBrows);
        this.jLabel14.setBackground(new Color(255, 255, 255));
        this.jLabel14.setForeground(new Color(204, 204, 204));
        this.jLabel14.setText(" | ");
        this.tlbMain.add(this.jLabel14);
        this.btnImport.setBackground(Color.white);
        this.btnImport.setText("import");
        this.btnImport.setToolTipText("Import from XML file");
        this.btnImport.setFocusable(false);
        this.btnImport.setHorizontalTextPosition(0);
        this.btnImport.setVerticalTextPosition(3);
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnImportActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnImport);
        this.btnExport.setBackground(Color.white);
        this.btnExport.setText("export");
        this.btnExport.setToolTipText("Export to XML file");
        this.btnExport.setFocusable(false);
        this.btnExport.setHorizontalTextPosition(0);
        this.btnExport.setVerticalTextPosition(3);
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnExportActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnExport);
        this.jLabel10.setBackground(new Color(255, 255, 255));
        this.jLabel10.setForeground(new Color(204, 204, 204));
        this.jLabel10.setText(" | ");
        this.tlbMain.add(this.jLabel10);
        this.btnChangePassword.setBackground(new Color(255, 255, 255));
        this.btnChangePassword.setText("change");
        this.btnChangePassword.setToolTipText("Change Password");
        this.btnChangePassword.setFocusable(false);
        this.btnChangePassword.setHorizontalTextPosition(0);
        this.btnChangePassword.setVerticalTextPosition(3);
        this.btnChangePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnChangePasswordActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnChangePassword);
        this.btnPasswordGenerator.setBackground(new Color(255, 255, 255));
        this.btnPasswordGenerator.setText("generator");
        this.btnPasswordGenerator.setToolTipText("Password Generator");
        this.btnPasswordGenerator.setFocusable(false);
        this.btnPasswordGenerator.setHorizontalTextPosition(0);
        this.btnPasswordGenerator.setVerticalTextPosition(3);
        this.btnPasswordGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnPasswordGeneratorActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnPasswordGenerator);
        this.btnEncryptor.setBackground(new Color(255, 255, 255));
        this.btnEncryptor.setText("encryptor");
        this.btnEncryptor.setToolTipText("Encryptor");
        this.btnEncryptor.setFocusable(false);
        this.btnEncryptor.setHorizontalTextPosition(0);
        this.btnEncryptor.setVerticalTextPosition(3);
        this.btnEncryptor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnEncryptorActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnEncryptor);
        this.jLabel11.setBackground(new Color(255, 255, 255));
        this.jLabel11.setForeground(new Color(204, 204, 204));
        this.jLabel11.setText(" | ");
        this.tlbMain.add(this.jLabel11);
        this.btnSettings.setBackground(new Color(255, 255, 255));
        this.btnSettings.setText("settings");
        this.btnSettings.setToolTipText("Settings");
        this.btnSettings.setFocusable(false);
        this.btnSettings.setHorizontalTextPosition(0);
        this.btnSettings.setVerticalTextPosition(3);
        this.btnSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnSettingsActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnSettings);
        this.btnAbout.setBackground(new Color(255, 255, 255));
        this.btnAbout.setText("about");
        this.btnAbout.setToolTipText("About MyPassword");
        this.btnAbout.setFocusable(false);
        this.btnAbout.setHorizontalTextPosition(0);
        this.btnAbout.setVerticalTextPosition(3);
        this.btnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnAboutActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnAbout);
        this.lblStatus.setFont(new Font("Tahoma", 0, 18));
        this.lblStatus.setForeground(new Color(102, 153, 255));
        this.lblStatus.setText("New Password");
        this.lblTitle.setText("Title:");
        this.txtTitle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainFrame.this.txtTitleFocusLost(evt);
            }
        });
        this.txtTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MainFrame.this.txtTitleKeyPressed(evt);
            }
        });
        this.lblDescription.setText("Description:");
        this.lblUsername.setText("Username:");
        this.lblPassword2.setText("Password:");
        this.txtPassword.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.txtPasswordMouseClicked(evt);
            }
        });
        this.txtPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MainFrame.this.txtPasswordKeyReleased(evt);
            }
        });
        this.lblPassword.setText(" ");
        this.lblPassword.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.lblPasswordMouseClicked(evt);
            }
        });
        this.lblConfirmation2.setText("Confirmation:");
        this.txtConfirmation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MainFrame.this.txtConfirmationKeyReleased(evt);
            }
        });
        this.lblConfirmation.setText(" ");
        this.lblStrength2.setText("Strength:");
        this.lblStrength.setText("strength");
        this.lblURL.setText("URL:");
        this.txtURL.setForeground(new Color(9, 20, 248));
        this.txtURL.setText("http://");
        this.txtURL.setCursor(new Cursor(2));
        this.txtURL.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MainFrame.this.txtURLMousePressed(evt);
            }
        });
        this.txtURL.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                MainFrame.this.txtURLMouseMoved(evt);
            }
        });
        this.txtURL.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MainFrame.this.txtURLFocusGained(evt);
            }
        });
        this.lblTags.setText("Tags:");
        this.txtTags.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MainFrame.this.txtTagsKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                MainFrame.this.txtTagsKeyReleased(evt);
            }
        });
        this.btnSave.setMnemonic(83);
        this.btnSave.setText("Save");
        this.btnSave.setToolTipText("ALT + S");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnSaveActionPerformed(evt);
            }
        });
        this.btnNew.setMnemonic(78);
        this.btnNew.setText("New");
        this.btnNew.setToolTipText("ALT + N");
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnNewActionPerformed(evt);
            }
        });
        GroupLayout pnlMainLayout = new GroupLayout(this.pnlMain);
        this.pnlMain.setLayout(pnlMainLayout);
        pnlMainLayout.setHorizontalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGap(29, 29, 29).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addComponent(this.lblStatus).addContainerGap()).addGroup(pnlMainLayout.createSequentialGroup().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle).addComponent(this.lblDescription).addComponent(this.lblUsername).addComponent(this.lblPassword2).addComponent(this.lblConfirmation2).addComponent(this.lblStrength2).addComponent(this.lblURL).addGroup(pnlMainLayout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.lblTags))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.confValLabel, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtDescription, -1, 607, Short.MAX_VALUE).addComponent(this.txtTitle, -1, 607, Short.MAX_VALUE).addComponent(this.txtUsername, -1, 607, Short.MAX_VALUE).addGroup(pnlMainLayout.createSequentialGroup().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtPassword, -2, 180, -2).addComponent(this.txtConfirmation, -2, 180, -2)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblConfirmation, -1, 409, Short.MAX_VALUE).addComponent(this.lblPassword, -1, 409, Short.MAX_VALUE))).addComponent(this.lblStrength, -2, 210, -2).addComponent(this.txtURL, -1, 607, Short.MAX_VALUE).addComponent(this.txtTags, -1, 607, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pnlMainLayout.createSequentialGroup().addComponent(this.btnSave, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 267, Short.MAX_VALUE).addComponent(this.btnNew, -2, 170, -2))).addGap(26, 26, 26)))).addComponent(this.tlbMain, -1, 759, Short.MAX_VALUE));
        pnlMainLayout.setVerticalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addComponent(this.tlbMain, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblStatus).addGap(25, 25, 25).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtTitle, -2, -1, -2).addComponent(this.lblTitle)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtDescription, -2, -1, -2).addComponent(this.lblDescription)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtUsername, -2, -1, -2).addComponent(this.lblUsername)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPassword, -2, -1, -2).addComponent(this.lblPassword).addComponent(this.lblPassword2)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtConfirmation, -2, -1, -2).addComponent(this.lblConfirmation).addComponent(this.lblConfirmation2)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblStrength).addComponent(this.lblStrength2)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtURL, -2, -1, -2).addComponent(this.lblURL)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtTags, -2, -1, -2).addComponent(this.lblTags)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 38, Short.MAX_VALUE).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSave).addComponent(this.btnNew)).addGap(22, 22, 22)).addGroup(pnlMainLayout.createSequentialGroup().addComponent(this.confValLabel, -2, 18, -2).addContainerGap()))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.saveOptions();
        Logger.log("Exit.");
    }

    private void txtTagsKeyReleased(KeyEvent evt) {
        this.txtTagsKeyRelease(evt);
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        this.newPasswordEntry();
        this.displaySurvey();
    }

    private void txtTitleFocusLost(FocusEvent evt) {
        String title = this.txtTitle.getText().trim();
        if (this.passwordEntry == null) {
            this.passwordEntry = new PasswordEntry(title);
        } else {
            this.passwordEntry.setTitle(title);
        }
        if (this.passwordEntry.loadByTitle(false) && this.passwordEntry.getId() > 0) {
            this.displayPasswordEntry();
            if (title.length() <= 0) {
                this.showBaloon(this.txtTitle, "<html>Empty title means <span style='color: red; font-weight: bold'>Delete</span>.</html>", new Color(240, 240, 240, 250), new Color(200, 200, 200, 255), 5000);
            }
        }
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        if (this.txtTitle.getText().trim().length() > 0) {
            if (this.checkPasswords()) {
                if (this.passwordEntry == null) {
                    this.passwordEntry = new PasswordEntry();
                }
                this.passwordEntry.setTitle(this.txtTitle.getText().trim());
                this.passwordEntry.setDescription(this.txtDescription.getText().trim());
                this.passwordEntry.setUsername(this.txtUsername.getText().trim());
                this.passwordEntry.setUrl(this.txtURL.getText().trim());
                this.passwordEntry.setPassword(this.txtPassword.getPassword());
                if (this.passwordEntry.save()) {
                    this.passwordEntry.clearTags();
                    StringTokenizer tokenTags = new StringTokenizer(this.txtTags.getText(), ",");
                    while (tokenTags.hasMoreTokens()) {
                        String tag = tokenTags.nextToken().trim();
                        this.passwordEntry.addTag(tag);
                    }
                    JOptionPane.showMessageDialog(this, this.passwordSaved, this.informationCaption, 1);
                    PasswordTag.cleanTags();
                    this.lblStatus.setText(this.updatePasswordCaption);
                    this.lblStatus.setForeground(StatusUpdateColor);
                    this.btnDelete.setEnabled(true);
                } else {
                    JOptionPane.showMessageDialog(this, this.errorOccured, this.errorCaption, 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, this.confirmDoesNotMatch, this.warningCaption, 2);
            }
        } else if (this.lblStatus.getText().toLowerCase().trim().equals(this.newPasswordCaption)) {
            JOptionPane.showMessageDialog(this, this.youMustChooseATitle, this.warningCaption, 2);
            this.txtTitle.requestFocus();
        } else if (this.passwordEntry != null && this.passwordEntry.getId() > 0) {
            this.deletePasswordEntry();
        }
    }

    private void txtURLFocusGained(FocusEvent evt) {
        if (this.txtURL.getText().toLowerCase().equals("http://")) {
            this.txtURL.setSelectionStart(0);
            this.txtURL.setSelectionEnd(this.txtURL.getText().length());
        }
    }

    private void btnShowPasswordActionPerformed(ActionEvent evt) {
        this.toggleShowPassword();
    }

    private void txtPasswordKeyReleased(KeyEvent evt) {
        String confPassword = new String(this.txtConfirmation.getPassword());
        String password = new String(this.txtPassword.getPassword());
        this.lblPassword.setText(password);
        if (password.length() > 0) {
            this.showStars(password);
        } else {
            this.hideStars();
        }
        if (!confPassword.equals("")) {
            ImageIcon res = this.passVal.validatePasswords(password, confPassword);
            if (this.confValLabel.getIcon() == null) {
                this.confValLabel.setIcon(res);
            } else if (!this.confValLabel.getIcon().equals(res)) {
                this.confValLabel.setIcon(res);
            }
        }
    }

    private void txtConfirmationKeyReleased(KeyEvent evt) {
        String confPassword = new String(this.txtConfirmation.getPassword());
        String password = new String(this.txtPassword.getPassword());
        this.lblConfirmation.setText(confPassword);
        if (confPassword.equals("")) {
            this.confValLabel.setIcon(null);
        } else {
            ImageIcon res = this.passVal.validatePasswords(password, confPassword);
            if (this.confValLabel.getIcon() == null) {
                this.confValLabel.setIcon(res);
            } else if (!this.confValLabel.getIcon().equals(res)) {
                this.confValLabel.setIcon(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnSearchActionPerformed(ActionEvent evt) {
        SearchDialog searchDialog = new SearchDialog((Frame)this, true);
        try {
            searchDialog.setVisible(true);
        }
        finally {
            searchDialog.dispose();
            searchDialog = null;
        }
    }

    private void txtTagsKeyPressed(KeyEvent evt) {
        this.txtTagsKeyPress(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnChangePasswordActionPerformed(ActionEvent evt) {
        ChangePasswordDialog2 changePasswordDialog = new ChangePasswordDialog2(this, true);
        try {
            changePasswordDialog.setVisible(true);
        }
        finally {
            changePasswordDialog.dispose();
            changePasswordDialog = null;
        }
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        this.deletePasswordEntry();
    }

    private void btnAboutActionPerformed(ActionEvent evt) {
        this.about();
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        this.importFromXML();
    }

    private void btnExportActionPerformed(ActionEvent evt) {
        this.exportFromXML();
    }

    private void lblPasswordMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            Point point = evt.getPoint();
            this.mnuPassword.show(this.lblPassword, point.x, point.y);
        }
    }

    private void txtPasswordMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            Point point = evt.getPoint();
            this.mnuPassword.show(this.txtPassword, point.x, point.y);
        }
    }

    private void btnPasswordGeneratorActionPerformed(ActionEvent evt) {
        this.btnPasswordGeneratorActionPerform(evt);
    }

    private void txtTitleKeyPressed(KeyEvent evt) {
        this.txtTitleKeyPress(evt);
    }

    private void formFocusGained(FocusEvent evt) {
        if (this.locked) {
            this.unlock();
        }
    }

    private void formMouseClicked(MouseEvent evt) {
        if (this.locked) {
            this.unlock();
        }
    }

    private void txtURLMousePressed(MouseEvent evt) {
        if (evt.getModifiers() == 18) {
            Utils.openURL(this.txtURL.getText());
        }
    }

    private void txtURLMouseMoved(MouseEvent evt) {
        if (evt.getModifiers() == 2) {
            this.txtURL.setCursor(new Cursor(12));
        } else {
            this.txtURL.setCursor(new Cursor(2));
        }
    }

    private void btnBrowsActionPerformed(ActionEvent evt) {
        this.showBrows();
    }

    private void btnEncryptorActionPerformed(ActionEvent evt) {
        this.showEncryptor();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.authenticate();
        this.askForDonation();
    }

    private void btnSettingsActionPerformed(ActionEvent evt) {
        this.btnSettingsActionPerform(evt);
    }

    private void myInitComponents() {
        this.pnlMain.setVisible(false);
        Domain domain = Domain.getInstance();
        try {
            URL url = ResourceLoader.class.getResource("safe32.png");
            ImageIcon safeIcon = new ImageIcon(url);
            this.setIconImage(safeIcon.getImage());
            url = ResourceLoader.class.getResource("safe.png");
            this.btnAbout.setIcon(new ImageIcon(url));
            this.btnAbout.setText("");
            url = ResourceLoader.class.getResource("eye.png");
            this.btnShowPassword.setIcon(new ImageIcon(url));
            this.btnShowPassword.setText("");
            url = ResourceLoader.class.getResource("search.png");
            this.btnSearch.setIcon(new ImageIcon(url));
            this.btnSearch.setText("");
            url = ResourceLoader.class.getResource("tree.png");
            this.btnBrows.setIcon(new ImageIcon(url));
            this.btnBrows.setText("");
            url = ResourceLoader.class.getResource("password2.png");
            this.btnChangePassword.setIcon(new ImageIcon(url));
            this.btnChangePassword.setText("");
            url = ResourceLoader.class.getResource("delete.png");
            this.btnDelete.setIcon(new ImageIcon(url));
            url = ResourceLoader.class.getResource("disableddelete.png");
            this.btnDelete.setDisabledIcon(new ImageIcon(url));
            this.btnDelete.setText("");
            url = ResourceLoader.class.getResource("export.png");
            this.btnExport.setIcon(new ImageIcon(url));
            this.btnExport.setText("");
            url = ResourceLoader.class.getResource("import.png");
            this.btnImport.setIcon(new ImageIcon(url));
            this.btnImport.setText("");
            url = ResourceLoader.class.getResource("0stars.png");
            this.lblStrength.setIcon(new ImageIcon(url));
            this.lblStrength.setText("");
            url = ResourceLoader.class.getResource("password_generator.png");
            this.btnPasswordGenerator.setIcon(new ImageIcon(url));
            this.btnPasswordGenerator.setText("");
            url = ResourceLoader.class.getResource("settings.png");
            this.btnSettings.setIcon(new ImageIcon(url));
            this.btnSettings.setText("");
            url = ResourceLoader.class.getResource("lock.png");
            this.btnEncryptor.setIcon(new ImageIcon(url));
            this.btnEncryptor.setText("");
            this.mnuPassword = new JPopupMenu("Password");
            url = ResourceLoader.class.getResource("copy.png");
            this.mniCopy = new JMenuItem("Copy Password", new ImageIcon(url));
            url = ResourceLoader.class.getResource("paste.png");
            this.mniPaste = new JMenuItem("Paste Password", new ImageIcon(url));
            this.mnuPassword.add(this.mniCopy);
            this.mnuPassword.add(this.mniPaste);
            ActionListener menuActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == MainFrame.this.mniCopy) {
                        MainFrame.this.mniCopyActionPerformed(e);
                    } else {
                        MainFrame.this.mniPasteActionPerformed(e);
                        if (MainFrame.this.txtPassword.getPassword().length > 0) {
                            MainFrame.this.showStars(new String(MainFrame.this.txtPassword.getPassword()));
                        } else {
                            MainFrame.this.hideStars();
                        }
                    }
                }
            };
            this.mniCopy.addActionListener(menuActionListener);
            this.mniPaste.addActionListener(menuActionListener);
            this.setTitle(this.getTitle() + " " + domain.getMyPasswordsVersion());
            this.passVal = new RealtimePasswordValidator();
        }
        catch (Exception ex) {
            Logger.log(ex.getMessage());
        }
    }

    private void mniCopyActionPerformed(ActionEvent e) {
        Utils.setClipboardContents(new String(this.txtPassword.getPassword()), this);
    }

    private void mniPasteActionPerformed(ActionEvent e) {
        String password = Utils.getClipboardContents();
        this.txtPassword.setText(password);
        this.txtConfirmation.setText(password);
        this.lblPassword.setText(password);
        this.lblConfirmation.setText(password);
    }

    private void setPosition() {
        int y;
        int x;
        Domain domain = Domain.getInstance();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            x = Integer.parseInt(domain.getSetting("main_frame_x", null));
        }
        catch (Exception ex) {
            x = 0;
        }
        try {
            y = Integer.parseInt(domain.getSetting("main_frame_y", null));
        }
        catch (Exception ex) {
            y = 0;
        }
        if (x > screenSize.width) {
            return;
        }
        if (y > screenSize.height) {
            return;
        }
        this.setLocation(x, y);
    }

    private String searchInTags(String keyword) {
        PasswordTag[] tags = PasswordTag.getAllTags();
        for (int i = 0; i < tags.length; ++i) {
            PasswordTag passwordTag = tags[i];
            String tagTitle = passwordTag.getTitle();
            if (tagTitle.indexOf(keyword.toLowerCase()) != 0) continue;
            return tagTitle;
        }
        return "";
    }

    private String searchInTitles(String keyword) {
        PasswordEntry[] passwordEntries = PasswordEntry.getAllPasswordEntries();
        for (int i = 0; i < passwordEntries.length; ++i) {
            PasswordEntry currentPasswordEntry = passwordEntries[i];
            String title = currentPasswordEntry.getTitle();
            if (title.toLowerCase().indexOf(keyword.toLowerCase()) != 0) continue;
            return title;
        }
        return "";
    }

    private boolean checkPasswords() {
        char[] password = this.txtPassword.getPassword();
        char[] confirmation = this.txtConfirmation.getPassword();
        return Arrays.equals(password, confirmation);
    }

    private void toggleShowPassword() {
        this.showPassword = this.btnShowPassword.isSelected();
        this.lblPassword.setVisible(this.showPassword);
        this.lblConfirmation.setVisible(this.showPassword);
    }

    private void loadOptions() {
        Domain domain = Domain.getInstance();
        String strShowPassword = domain.getSetting("show_password", null);
        try {
            this.showPassword = strShowPassword != null ? Boolean.parseBoolean(strShowPassword) : false;
        }
        catch (Exception ex) {
            this.showPassword = false;
        }
        String strShowTitleBaloon = domain.getSetting("show_title_baloon", null);
        try {
            this.showTitleBaloon = strShowTitleBaloon != null ? Boolean.parseBoolean(strShowTitleBaloon) : true;
        }
        catch (Exception ex) {
            this.showTitleBaloon = false;
        }
        this.setPosition();
        this.setComponentsStates();
    }

    private void saveOptions() {
        Domain domain = Domain.getInstance();
        domain.setSetting("main_frame_x", this.getX() + "", null);
        domain.setSetting("main_frame_y", this.getY() + "", null);
        domain.setSetting("show_password", this.showPassword + "", null);
    }

    private void setComponentsStates() {
        this.btnShowPassword.setSelected(this.showPassword);
        this.lblPassword.setVisible(this.showPassword);
        this.lblConfirmation.setVisible(this.showPassword);
    }

    private void suggestPasswordEntry() {
        String currentTitle;
        String candidPasswordEntry;
        if (this.txtTitle.getText().length() > 0 && (candidPasswordEntry = this.searchInTitles(currentTitle = this.txtTitle.getText())).length() > 0) {
            String restOfCandidTag = Utils.getRestOfStrings(currentTitle, candidPasswordEntry);
            this.txtTitle.setText(this.txtTitle.getText() + restOfCandidTag);
            this.txtTitle.setSelectionStart(this.txtTitle.getText().lastIndexOf(restOfCandidTag));
            this.txtTitle.setSelectionEnd(this.txtTitle.getText().length());
        }
    }

    public void displayPasswordEntry() {
        if (this.passwordEntry == null || this.passwordEntry.getId() <= 0) {
            return;
        }
        this.txtTitle.setText(this.passwordEntry.getTitle());
        this.txtDescription.setText(this.passwordEntry.getDescription());
        this.txtUsername.setText(this.passwordEntry.getUsername());
        this.txtPassword.setText(this.passwordEntry.getPassword());
        this.txtConfirmation.setText(this.passwordEntry.getPassword());
        this.txtURL.setText(this.passwordEntry.getUrl());
        this.lblPassword.setText(this.passwordEntry.getPassword());
        this.lblConfirmation.setText(this.passwordEntry.getPassword());
        this.txtTags.setText("");
        PasswordTag[] tags = this.passwordEntry.readTags();
        for (int i = 0; i < tags.length; ++i) {
            PasswordTag passwordTag = tags[i];
            this.txtTags.setText(this.txtTags.getText() + passwordTag.getTitle());
            if (i >= tags.length - 1) continue;
            this.txtTags.setText(this.txtTags.getText() + ", ");
        }
        this.lblStatus.setText(this.updatePasswordCaption);
        this.lblStatus.setForeground(StatusUpdateColor);
        this.btnDelete.setEnabled(true);
        if (this.passwordEntry.getPassword().length() > 0) {
            this.showStars(this.passwordEntry.getPassword());
        } else {
            this.hideStars();
        }
    }

    private void deletePasswordEntry() {
        int answer = JOptionPane.showOptionDialog(this, String.format(this.doYouWantToDelete, this.passwordEntry.getTitle()), this.deleteCaption, 0, 2, null, new String[]{this.yesCaption, this.noCaption}, this.noCaption);
        if (answer == 0) {
            if (this.passwordEntry.clearTags()) {
                if (this.passwordEntry.delete()) {
                    PasswordTag.cleanTags();
                    JOptionPane.showMessageDialog(this, this.deletedSuccessfully, this.informationCaption, 1);
                    this.newPasswordEntry();
                } else {
                    JOptionPane.showMessageDialog(this, this.errorOccured, this.errorCaption, 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, this.errorOccured, this.errorCaption, 0);
            }
        }
    }

    private void newPasswordEntry() {
        this.passwordEntry = null;
        this.txtTitle.setText("");
        this.txtDescription.setText("");
        this.txtUsername.setText("");
        this.txtPassword.setText("");
        this.txtConfirmation.setText("");
        this.txtURL.setText("http://");
        this.txtTags.setText("");
        this.lblPassword.setText("");
        this.lblConfirmation.setText("");
        this.lblStatus.setText(this.newPasswordCaption);
        this.lblStatus.setForeground(StatusNewColor);
        this.btnDelete.setEnabled(false);
        this.txtTitle.requestFocus();
        this.initializePasswordValIcons();
        this.hideStars();
    }

    private void initializePasswordValIcons() {
        this.confValLabel.setIcon(null);
    }

    private void about() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog((Frame)this, true);
        }
        Utils.setCenterOfParent(this, (JDialog)this.aboutDialog);
        this.aboutDialog.setVisible(true);
    }

    private void importFromXML() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new XMLFileFilter());
        int answer = fileChooser.showOpenDialog(this);
        if (answer == 0) {
            File file = fileChooser.getSelectedFile();
            if (file.isDirectory()) {
                JOptionPane.showMessageDialog(this, this.selectAFileNot, this.errorCaption, 0);
                return;
            }
            if (!Utils.getFileExtension(file).equals("xml")) {
                JOptionPane.showMessageDialog(this, this.invalidFileExtension, this.errorCaption, 0);
                return;
            }
            try {
                String key = null;
                JTextField txtKey = new JTextField();
                txtKey.addAncestorListener(new RequestFocusListener());
                int answerKey = JOptionPane.showOptionDialog(this, new Object[]{this.pleaseEnterTheKey, txtKey}, this.decryptionKey, 2, 3, null, new Object[]{this.okCaption, this.cancelCaption}, this.okCaption);
                if (answerKey == 0 && txtKey.getText() != null) {
                    key = txtKey.getText();
                }
                if (key != null) {
                    int answer1 = JOptionPane.showOptionDialog(this, this.areAllFieldsEncrypted, this.security, 0, 3, null, new String[]{this.yesCaption, this.noCaption}, this.yesCaption);
                    boolean encryptAllFields = answer1 == 0;
                    byte[] byteKey = key.getBytes("UTF8");
                    if (byteKey.length == 16) {
                        ImportDialog importDialog = new ImportDialog(this, true, file, key, encryptAllFields);
                        importDialog.setVisible(true);
                    } else {
                        JOptionPane.showMessageDialog(this, this.invalidDecryptionKey, this.errorCaption, 0);
                    }
                }
            }
            catch (UnsupportedEncodingException ex) {
                JOptionPane.showMessageDialog(this, this.invalidDecryptionKey, this.errorCaption, 0);
                Logger.log(ex.getMessage());
            }
        }
    }

    private void exportFromXML() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new XMLFileFilter());
        int answer = fileChooser.showSaveDialog(this);
        if (answer == 0) {
            File file = fileChooser.getSelectedFile();
            if (file.getName().indexOf(".") < 0) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            int overwrite = 0;
            if (file.exists()) {
                overwrite = JOptionPane.showConfirmDialog(this, "Overwrite the existing file?", "Warning", 0, 2);
            }
            if (file.isDirectory()) {
                JOptionPane.showMessageDialog(this, "Select a file, not a directory!", "Error", 0);
                return;
            }
            if (!Utils.getFileExtension(file).equals("xml")) {
                JOptionPane.showMessageDialog(this, "Invalid file extension!", "Error", 0);
                return;
            }
            if (overwrite == 0) {
                try {
                    String key = (String)JOptionPane.showInputDialog(this, "Please enter a 16-letter English word as encryption key:\n(You can enter a 8-letter internationl word instead)", "Encryption Key", 1, null, null, Utils.randomString(16, 16));
                    if (key != null) {
                        byte[] byteKey = key.getBytes("UTF8");
                        if (byteKey.length == 16) {
                            boolean encryptAllFields = JOptionPane.showConfirmDialog(this, "Encrypt all fields?", "Security", 0, 3) == 0;
                            ExportDialog exportDialog = new ExportDialog(this, true, file, key, encryptAllFields);
                            exportDialog.setVisible(true);
                        } else {
                            JOptionPane.showMessageDialog(this, "Invalid Encryption Key!", "Error", 0);
                        }
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    JOptionPane.showMessageDialog(this, "Invalid Encryption Key!", "Error", 0);
                    Logger.log(ex.getMessage());
                }
            }
        }
    }

    private void showBaloon(JComponent component, String message, Color backgroundColor, Color borderColor, int timeout) {
        RoundedBalloonStyle balloonTipLook = new RoundedBalloonStyle(10, 10, backgroundColor, borderColor);
        BalloonTip balloonTip = null;
        if (timeout > 0) {
            balloonTip = new BalloonTip(component, message, balloonTipLook, BalloonTip.Orientation.RIGHT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 10, 10, false);
            TimingUtils.showTimedBalloon(balloonTip, timeout);
        } else {
            balloonTip = new BalloonTip(component, message, balloonTipLook, BalloonTip.Orientation.RIGHT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 10, 10, true);
        }
        balloonTip.setVisible(true);
    }

    private void showStars(String password) {
        PasswordAnalyser passwordAnalyser = new PasswordAnalyser(password);
        int strength = passwordAnalyser.getPoints();
        String iconName = "";
        if (strength < 2) {
            iconName = "1stars.png";
        } else if (strength < 4) {
            iconName = "2stars.png";
        } else if (strength < 6) {
            iconName = "3stars.png";
        } else if (strength < 7) {
            iconName = "4stars.png";
        } else if (strength < 9) {
            iconName = "5stars.png";
        } else if (strength >= 9) {
            iconName = "6stars.png";
        }
        URL url = ResourceLoader.class.getResource(iconName);
        this.lblStrength.setIcon(new ImageIcon(url));
    }

    private void hideStars() {
        URL url = ResourceLoader.class.getResource("0stars.png");
        this.lblStrength.setIcon(new ImageIcon(url));
    }

    private void lockTimerActionPerformed() {
        Domain domain = Domain.getInstance();
        if (domain.minutesOfLastDBConnection() >= 5 && !this.locked) {
            this.lock();
        }
    }

    private void lock() {
        this.locked = true;
        this.pnlMain.setVisible(false);
    }

    private void unlock() {
        LoginDialog loginDialog = new LoginDialog(this, true, true);
        loginDialog.setVisible(true);
        if (loginDialog.getLoginResult() == 3) {
            Logger.log("Unlock cenceled.");
            loginDialog.dispose();
            loginDialog = null;
            System.exit(0);
        } else {
            this.locked = false;
            Logger.log("Successfull unlock.");
            loginDialog.dispose();
            loginDialog = null;
            this.pnlMain.setVisible(true);
        }
    }

    private void checkForNewerVersion() throws ParserConfigurationException, SAXException, IOException {
        VersionChecker versionChecker = new VersionChecker(this);
        Thread thread = new Thread(versionChecker);
        thread.start();
    }

    private void showBrows() {
        BrowseDialog2 browsDialog = new BrowseDialog2(this, true);
        browsDialog.setVisible(true);
        browsDialog.dispose();
    }

    private void authenticate() {
        Domain domain = Domain.getInstance();
        String currentPassword = domain.getSetting("password", null);
        if (currentPassword != null && currentPassword.length() > 0) {
            LoginDialog loginDialog = new LoginDialog(this, true, true);
            loginDialog.setVisible(true);
            if (loginDialog.getLoginResult() == 3) {
                Logger.log("Login cenceled.");
                loginDialog.dispose();
                loginDialog = null;
                System.exit(0);
            } else {
                Logger.log("Successfull login.");
                loginDialog.dispose();
                loginDialog = null;
                if (this.timerToolbarDecoration != null) {
                    this.timerToolbarDecoration.start();
                }
            }
        }
        this.pnlMain.setVisible(true);
    }

    public PasswordEntry getPasswordEntry() {
        return this.passwordEntry;
    }

    public void setPasswordEntry(PasswordEntry passwordEntry) {
        this.passwordEntry = passwordEntry;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void btnPasswordGeneratorActionPerform(ActionEvent evt) {
        if (this.passwordGeneratorDialog == null) {
            this.passwordGeneratorDialog = new PasswordGeneratorDialog((Frame)this, false);
        }
        Utils.setCenterOfParent(this, (JDialog)this.passwordGeneratorDialog);
        this.passwordGeneratorDialog.setVisible(true);
    }

    private void txtTitleKeyPress(KeyEvent evt) {
        if (this.txtTitle.getText().length() == 1) {
            if (this.showTitleBaloon) {
                this.showBaloon(this.txtTitle, "<html>Use <b>CTRL + SPACE</b> for auto-completion.<br />(Saved passwords)</html>", new Color(240, 240, 240, 250), new Color(200, 200, 200, 255), 5000);
                this.showTitleBaloon = false;
            } else {
                this.showBaloon(this.txtTitle, "<html>Use <b>CTRL + SPACE</b> for auto-completion.<br />(Saved passwords)</html>", new Color(240, 240, 240, 250), new Color(200, 200, 200, 255), 2000);
            }
        } else {
            Domain domain = Domain.getInstance();
            int key = evt.getKeyCode();
            int mod = evt.getModifiersEx();
            if (key == 32 && mod == 128) {
                this.suggestPasswordEntry();
                this.showTitleBaloon = false;
                domain.setSetting("show_title_baloon", "false", null);
            }
            if (key == 10) {
                this.txtTitle.setSelectionStart(this.txtTitle.getText().length());
                this.txtTitle.setSelectionEnd(this.txtTitle.getText().length());
            }
        }
    }

    private void txtTagsKeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 44) {
            this.txtTags.setSelectionStart(this.txtTags.getText().length());
            this.txtTags.setSelectionEnd(this.txtTags.getText().length());
        }
    }

    private void txtTagsKeyRelease(KeyEvent evt) {
        String candidTag;
        int key = evt.getKeyCode();
        if (key >= 33 && key <= 40) {
            return;
        }
        if (key == 8) {
            return;
        }
        if (key == 32) {
            return;
        }
        if (key == 10) {
            this.txtTags.setSelectionStart(this.txtTags.getText().length());
            this.txtTags.setSelectionEnd(this.txtTags.getText().length());
        }
        String lastTag = "";
        StringTokenizer tokenTags = new StringTokenizer(this.txtTags.getText(), ",");
        while (tokenTags.hasMoreTokens()) {
            lastTag = tokenTags.nextToken().trim();
        }
        if (lastTag.length() > 1 && (candidTag = this.searchInTags(lastTag)).length() > 0) {
            String restOfCandidTag = Utils.getRestOfStrings(lastTag, candidTag);
            this.txtTags.setText(this.txtTags.getText() + restOfCandidTag);
            this.txtTags.setSelectionStart(this.txtTags.getText().lastIndexOf(restOfCandidTag));
            this.txtTags.setSelectionEnd(this.txtTags.getText().length());
        }
    }

    private void checkLanguages() throws LanguageException {
        this.availableLanguages = LanguageManager.getAvailableLanguages();
        if (this.availableLanguages.length > 0) {
            this.cmbLanguages = new JComboBox();
            this.cmbLanguages.setBackground(this.tlbMain.getBackground());
            this.cmbLanguages.addItem("EN");
            for (int i = 0; i < this.availableLanguages.length; ++i) {
                String language = this.availableLanguages[i];
                language = language.substring(0, language.indexOf(".")).toUpperCase();
                this.cmbLanguages.addItem(language);
            }
        }
        if (this.cmbLanguages != null) {
            this.cmbLanguages.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.selectedLanguage = (String)MainFrame.this.cmbLanguages.getSelectedItem();
                    MainFrame.this.changeLanguage();
                }
            });
            this.tlbMain.add(this.cmbLanguages);
            this.timerToolbarDecoration = new Timer(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Point cmbLanguagesPosition = MainFrame.this.cmbLanguages.getLocation();
                    Dimension toolbarSize = MainFrame.this.tlbMain.getSize();
                    Point btnAboutPosition = MainFrame.this.btnAbout.getLocation();
                    Dimension btnAboutSize = MainFrame.this.btnAbout.getSize();
                    int speceWidth = toolbarSize.width - (btnAboutSize.width + btnAboutPosition.x + Math.min(50, cmbLanguagesPosition.x));
                    Dimension pnlSpaceSize = new Dimension(speceWidth - 5, 0);
                    JPanel pnlSpace = new JPanel();
                    pnlSpace.setPreferredSize(pnlSpaceSize);
                    pnlSpace.setBackground(MainFrame.this.tlbMain.getBackground());
                    MainFrame.this.tlbMain.remove(MainFrame.this.cmbLanguages);
                    MainFrame.this.tlbMain.add(pnlSpace);
                    MainFrame.this.tlbMain.add(MainFrame.this.cmbLanguages);
                    MainFrame.this.cmbLanguages.setVisible(false);
                    MainFrame.this.cmbLanguages.setVisible(true);
                    MainFrame.this.timerToolbarDecoration.stop();
                }
            });
        }
    }

    private void changeLanguage() {
        if (this.englishLanguage == null) {
            this.englishLanguage = new Properties();
            this.englishLanguage.setProperty("direction", "ltr");
            this.englishLanguage.setProperty("NewPassword", this.newPasswordCaption);
            this.englishLanguage.setProperty("UpdatePassword", this.updatePasswordCaption);
            this.englishLanguage.setProperty("Title", "Title");
            this.englishLanguage.setProperty("Description", "Description");
            this.englishLanguage.setProperty("Username", "Username");
            this.englishLanguage.setProperty("Password", "Password");
            this.englishLanguage.setProperty("Confirmation", "Confirmation");
            this.englishLanguage.setProperty("Strength", "Strength");
            this.englishLanguage.setProperty("URL", "URL");
            this.englishLanguage.setProperty("Tags", "Tags");
            this.englishLanguage.setProperty("Save", "Save");
            this.englishLanguage.setProperty("New", "New");
            this.englishLanguage.setProperty("ShowPassword", "Show Password");
            this.englishLanguage.setProperty("DeletePassword", "Delete Password");
            this.englishLanguage.setProperty("Search", "Search");
            this.englishLanguage.setProperty("Browse", "Browse");
            this.englishLanguage.setProperty("ImportFromXMLFile", "Import from XML file");
            this.englishLanguage.setProperty("ExportToXMLFile", "Export to XML file");
            this.englishLanguage.setProperty("ChangePassword", "Change Password");
            this.englishLanguage.setProperty("PasswordGenerator", "Password Generator");
            this.englishLanguage.setProperty("Encryptor", "Encryptor");
            this.englishLanguage.setProperty("AboutMyPasswords", "About MyPasswords");
            this.englishLanguage.setProperty("Search", "Search");
            this.englishLanguage.setProperty("Tag", "Tag");
            this.englishLanguage.setProperty("Count", "Count");
            this.englishLanguage.setProperty("Error", this.errorCaption);
            this.englishLanguage.setProperty("Information", this.informationCaption);
            this.englishLanguage.setProperty("Delete", this.deleteCaption);
            this.englishLanguage.setProperty("InvalidDecryptionKey", this.invalidDecryptionKey);
            this.englishLanguage.setProperty("AreAllEncrypted", this.areAllFieldsEncrypted);
            this.englishLanguage.setProperty("PleaseEnterTheKeyWhichYouHaveEncryptedTheFileWith", this.pleaseEnterTheKey);
            this.englishLanguage.setProperty("PasswordDeletedSuccessfully", this.deletedSuccessfully);
            this.englishLanguage.setProperty("ErrorOccured", this.errorOccured);
            this.englishLanguage.setProperty("DoYouWantToDeleteThePassword", this.doYouWantToDelete);
            this.englishLanguage.setProperty("PasswordSaved", this.passwordSaved);
            this.englishLanguage.setProperty("Warning", this.warningCaption);
            this.englishLanguage.setProperty("YouMustChooseATitle", this.youMustChooseATitle);
            this.englishLanguage.setProperty("SelectAFileNot", this.selectAFileNot);
            this.englishLanguage.setProperty("InvalidFileExtension", this.invalidFileExtension);
            this.englishLanguage.setProperty("DecryptionKey", this.decryptionKey);
            this.englishLanguage.setProperty("Security", this.security);
            this.englishLanguage.setProperty("Yes", this.yesCaption);
            this.englishLanguage.setProperty("No", this.noCaption);
            this.englishLanguage.setProperty("Cancel", this.cancelCaption);
            this.englishLanguage.setProperty("OK", this.okCaption);
            this.englishLanguage.setProperty("ConfirmDoesNotMatch", this.confirmDoesNotMatch);
        }
        if (this.selectedLanguage.equalsIgnoreCase("en")) {
            this.currentLanguage = this.englishLanguage;
        } else {
            String languageName = this.selectedLanguage.toLowerCase() + ".lang";
            try {
                Properties language = LanguageManager.getLanguage(languageName);
                if (language != null) {
                    this.currentLanguage = language;
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Loading language file '" + languageName + "' failed!", "Error", 2);
            }
        }
        String direction = this.currentLanguage.getProperty("direction");
        if (direction != null) {
            this.setDirection(direction);
        }
        this.newPasswordCaption = this.currentLanguage.getProperty("NewPassword");
        this.updatePasswordCaption = this.currentLanguage.getProperty("UpdatePassword");
        this.lblTitle.setText(this.currentLanguage.getProperty("Title") + ":");
        this.lblDescription.setText(this.currentLanguage.getProperty("Description") + ":");
        this.lblUsername.setText(this.currentLanguage.getProperty("Username") + ":");
        this.lblPassword2.setText(this.currentLanguage.getProperty("Password") + ":");
        this.lblConfirmation2.setText(this.currentLanguage.getProperty("Confirmation") + ":");
        this.lblStrength2.setText(this.currentLanguage.getProperty("Strength") + ":");
        this.lblURL.setText(this.currentLanguage.getProperty("URL") + ":");
        this.lblTags.setText(this.currentLanguage.getProperty("Tags") + ":");
        this.btnSave.setText(this.currentLanguage.getProperty("Save"));
        this.btnNew.setText(this.currentLanguage.getProperty("New"));
        this.btnShowPassword.setToolTipText(this.currentLanguage.getProperty("ShowPassword"));
        this.btnDelete.setToolTipText(this.currentLanguage.getProperty("DeletePassword"));
        this.btnSearch.setToolTipText(this.currentLanguage.getProperty("Search"));
        this.btnBrows.setToolTipText(this.currentLanguage.getProperty("Browse"));
        this.btnImport.setToolTipText(this.currentLanguage.getProperty("ImportFromXMLFile"));
        this.btnExport.setToolTipText(this.currentLanguage.getProperty("ExportToXMLFile"));
        this.btnChangePassword.setToolTipText(this.currentLanguage.getProperty("ChangePassword"));
        this.btnPasswordGenerator.setToolTipText(this.currentLanguage.getProperty("PasswordGenerator"));
        this.btnEncryptor.setToolTipText(this.currentLanguage.getProperty("Encryptor"));
        this.btnAbout.setToolTipText(this.currentLanguage.getProperty("AboutMyPasswords"));
        this.errorCaption = this.currentLanguage.getProperty("Error");
        this.informationCaption = this.currentLanguage.getProperty("Information");
        this.deleteCaption = this.currentLanguage.getProperty("Delete");
        this.invalidDecryptionKey = this.currentLanguage.getProperty("InvalidDecryptionKey");
        this.areAllFieldsEncrypted = this.currentLanguage.getProperty("AreAllEncrypted");
        this.pleaseEnterTheKey = this.currentLanguage.getProperty("PleaseEnterTheKeyWhichYouHaveEncryptedTheFileWith");
        this.deletedSuccessfully = this.currentLanguage.getProperty("PasswordDeletedSuccessfully");
        this.errorOccured = this.currentLanguage.getProperty("ErrorOccured");
        this.doYouWantToDelete = ("<html>" + this.currentLanguage.getProperty("DoYouWantToDeleteThePassword") + "</html>").replace("[password name]", "<b>%s</b>");
        this.passwordSaved = this.currentLanguage.getProperty("PasswordSaved");
        this.warningCaption = this.currentLanguage.getProperty("Warning");
        this.youMustChooseATitle = this.currentLanguage.getProperty("YouMustChooseATitle");
        this.selectAFileNot = this.currentLanguage.getProperty("SelectAFileNot");
        this.invalidFileExtension = this.currentLanguage.getProperty("InvalidFileExtension");
        this.decryptionKey = this.currentLanguage.getProperty("DecryptionKey");
        this.security = this.currentLanguage.getProperty("Security");
        this.noCaption = this.currentLanguage.getProperty("No");
        this.yesCaption = this.currentLanguage.getProperty("Yes");
        this.confirmDoesNotMatch = this.currentLanguage.getProperty("ConfirmDoesNotMatch");
        this.okCaption = this.currentLanguage.getProperty("OK");
        this.cancelCaption = this.currentLanguage.getProperty("Cancel");
        this.setStatusLabel();
        this.refresh();
    }

    private void setDirection(String direction) {
        block3: {
            block2: {
                if (!direction.equals("rtl")) break block2;
                this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                this.pnlMain.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                this.tlbMain.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                this.cmbLanguages.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                for (int i = 0; i < this.pnlMain.getComponents().length; ++i) {
                    Component component = this.pnlMain.getComponents()[i];
                    component.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
                break block3;
            }
            if (!direction.equals("ltr")) break block3;
            this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.pnlMain.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.tlbMain.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.cmbLanguages.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            for (int i = 0; i < this.pnlMain.getComponents().length; ++i) {
                Component component = this.pnlMain.getComponents()[i];
                component.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
        }
    }

    private void refresh() {
        this.pnlMain.setVisible(false);
        this.pnlMain.setVisible(true);
        this.tlbMain.setVisible(false);
        this.tlbMain.setVisible(true);
    }

    private void setStatusLabel() {
        if (this.lblStatus.getForeground().equals(StatusNewColor)) {
            this.lblStatus.setText(this.newPasswordCaption);
        } else if (this.lblStatus.getForeground().equals(StatusUpdateColor)) {
            this.lblStatus.setText(this.updatePasswordCaption);
        }
    }

    public Properties getCurrentLanguage() {
        return this.currentLanguage;
    }

    private void showEncryptor() {
        EncryptionDialog encryptionDialog = new EncryptionDialog(this, false);
        encryptionDialog.setVisible(true);
    }

    private void btnSettingsActionPerform(ActionEvent evt) {
        SettingsDialog settingsDialog = new SettingsDialog(this, false);
        settingsDialog.setVisible(true);
    }

    private void askForDonation() {
        Domain domain = Domain.getInstance();
        String donation = domain.getSetting("donation", null);
        if (donation == null) {
            String message = "<html>Thanks for using MyPasswords<br/><b>Do you want to donate to MyPasswords project?</b></html>";
            int answer = JOptionPane.showConfirmDialog(this, message, "Donation", 0, 3);
            if (answer == 0) {
                Utils.openURL("http://www.mypasswords7.com/donate");
            }
            domain.setSetting("donation", "1", null);
        }
    }

    private void displaySurvey() {
        if (!this.surveyDisplayed) {
            String message;
            int answer;
            int minute;
            int remainder;
            GregorianCalendar calendar = new GregorianCalendar();
            int day = calendar.get(7);
            if ((day == 7 || day == 1) && (remainder = (minute = calendar.get(12)) % 5) == 0 && (answer = JOptionPane.showConfirmDialog(this, message = "<html>Thanks for using MyPasswords<br/><b>Do you want to participate in our survey?</b></html>", "Survey", 0, 3)) == 0) {
                Utils.openURL("http://www.mypasswords7.com/survey");
            }
            this.surveyDisplayed = true;
        }
    }
}

