/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.entity.PasswordEntry;
import com.ehsunbehravesh.mypasswords.entity.PasswordTag;
import com.ehsunbehravesh.mypasswords.gui.MainFrame;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class BrowseDialog
extends JDialog {
    private JFrame parent;
    private PasswordTag[] tags;
    private String tagsCaption = "Tags";
    private JScrollPane scpMain;
    private JTree treTags;

    public BrowseDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.initComponents();
        this.myInitComponents();
    }

    private void initComponents() {
        this.scpMain = new JScrollPane();
        this.treTags = new JTree();
        this.setDefaultCloseOperation(2);
        this.setTitle("Browse");
        this.treTags.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                BrowseDialog.this.treTagsKeyPressed(evt);
            }
        });
        this.scpMain.setViewportView(this.treTags);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scpMain, -1, 407, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scpMain, -1, 374, Short.MAX_VALUE));
        this.pack();
    }

    private void treTagsKeyPressed(KeyEvent evt) {
        this.treTagsKeyPress(evt);
    }

    private void myInitComponents() {
        Utils.setCenterOfParent(this.parent, (JDialog)this);
        this.setFont(this.parent.getFont());
        this.setComponentOrientation(this.parent.getComponentOrientation());
        this.treTags.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                BrowseDialog.this.doMouseClicked(me);
            }
        });
        MainFrame mainFrame = (MainFrame)this.getParent();
        if (mainFrame.getCurrentLanguage() != null) {
            this.changeLanguage(mainFrame.getCurrentLanguage());
        }
        this.loadTags();
        this.displayTags();
    }

    private void doMouseClicked(MouseEvent me) {
        PasswordEntry passwordEntry;
        PasswordEntry decryptedPasswordEntry;
        DefaultMutableTreeNode lastNode;
        TreePath tp = this.treTags.getPathForLocation(me.getX(), me.getY());
        if (tp != null && (lastNode = (DefaultMutableTreeNode)tp.getLastPathComponent()).isLeaf() && !lastNode.getAllowsChildren() && (decryptedPasswordEntry = new PasswordEntry((passwordEntry = (PasswordEntry)lastNode.getUserObject()).getId())).load() && me.getClickCount() == 2) {
            MainFrame owner = (MainFrame)this.getOwner();
            owner.setPasswordEntry(decryptedPasswordEntry);
            owner.displayPasswordEntry();
            this.setVisible(false);
        }
    }

    private void loadTags() {
        this.tags = PasswordTag.getAllTags();
    }

    private void displayTags() {
        DefaultTreeModel model = (DefaultTreeModel)this.treTags.getModel();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(String.format(this.tagsCaption + " (%d)", this.tags.length), true);
        int i = 0;
        for (i = 0; i < this.tags.length; ++i) {
            PasswordTag passwordTag = this.tags[i];
            PasswordEntry[] passwordEntries = passwordTag.readEntries();
            DefaultMutableTreeNode tagNode = new DefaultMutableTreeNode(passwordTag, true);
            root.insert(tagNode, i);
            for (int j = 0; j < passwordEntries.length; ++j) {
                PasswordEntry passwordEntry = passwordEntries[j];
                DefaultMutableTreeNode passwordNode = new DefaultMutableTreeNode(passwordEntry, false);
                tagNode.insert(passwordNode, j);
            }
        }
        PasswordEntry[] passwordsWithoutTag = PasswordEntry.getPasswordEntriesWithoutTag();
        if (passwordsWithoutTag.length > 0) {
            DefaultMutableTreeNode tagNode = new DefaultMutableTreeNode(String.format("[no tag] (%d)", passwordsWithoutTag.length), true);
            for (int k = 0; k < passwordsWithoutTag.length; ++k) {
                PasswordEntry passwordEntry = passwordsWithoutTag[k];
                DefaultMutableTreeNode passwordNode = new DefaultMutableTreeNode(passwordEntry, false);
                tagNode.insert(passwordNode, k);
            }
            root.insert(tagNode, i);
        }
        model.setRoot(root);
    }

    private void treTagsKeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 27) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void changeLanguage(Properties currentLanguage) {
        try {
            this.setDirection(currentLanguage.getProperty("direction"));
            this.setTitle(currentLanguage.getProperty("Browse"));
            this.tagsCaption = currentLanguage.getProperty("Tags");
            this.refresh();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error occured in changing language!", "Error", 0);
        }
    }

    private void setDirection(String direction) {
        block3: {
            block2: {
                if (!direction.equals("rtl")) break block2;
                this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                this.scpMain.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                for (int i = 0; i < this.scpMain.getComponents().length; ++i) {
                    Component component = this.scpMain.getComponents()[i];
                    component.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
                break block3;
            }
            if (!direction.equals("ltr")) break block3;
            this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.scpMain.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            for (int i = 0; i < this.scpMain.getComponents().length; ++i) {
                Component component = this.scpMain.getComponents()[i];
                component.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
        }
    }

    private void refresh() {
        this.scpMain.setVisible(false);
        this.scpMain.setVisible(true);
    }
}

