/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Domain;
import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.resource.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class AboutDialog
extends JDialog {
    private JButton btnDonate;
    private JLabel lblHome;
    private JLabel lblMainIcon;
    private JLabel lblMyHome;
    private JLabel lblSystemInfo;
    private JLabel lblTitle;
    private JPanel pnlMain;

    public AboutDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.myInitComponent();
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.lblHome = new JLabel();
        this.lblTitle = new JLabel();
        this.lblMyHome = new JLabel();
        this.lblMainIcon = new JLabel();
        this.lblSystemInfo = new JLabel();
        this.btnDonate = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("About MyPasswords");
        this.setResizable(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                AboutDialog.this.formKeyPressed(evt);
            }
        });
        this.pnlMain.setBackground(new Color(254, 254, 254));
        this.lblHome.setFont(new Font("Tahoma", 0, 12));
        this.lblHome.setForeground(new Color(4, 17, 250));
        this.lblHome.setText("http://www.mypasswords7.com");
        this.lblHome.setCursor(new Cursor(12));
        this.lblHome.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AboutDialog.this.lblHomeMouseClicked(evt);
            }
        });
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setText("MyPasswords");
        this.lblMyHome.setFont(new Font("Tahoma", 0, 12));
        this.lblMyHome.setForeground(new Color(4, 17, 250));
        this.lblMyHome.setText("Survey!");
        this.lblMyHome.setCursor(new Cursor(12));
        this.lblMyHome.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AboutDialog.this.lblMyHomeMouseClicked(evt);
            }
        });
        this.lblMainIcon.setText("icon");
        this.lblSystemInfo.setFont(new Font("Arial Narrow", 0, 11));
        this.lblSystemInfo.setForeground(new Color(102, 102, 102));
        this.lblSystemInfo.setText("System Information");
        this.btnDonate.setText("Donate");
        this.btnDonate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.btnDonateActionPerformed(evt);
            }
        });
        this.btnDonate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                AboutDialog.this.btnDonateKeyPressed(evt);
            }
        });
        GroupLayout pnlMainLayout = new GroupLayout(this.pnlMain);
        this.pnlMain.setLayout(pnlMainLayout);
        pnlMainLayout.setHorizontalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGap(36, 36, 36).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMainIcon, -2, 128, -2).addComponent(this.btnDonate)).addGap(26, 26, 26).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle).addGroup(pnlMainLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMyHome).addComponent(this.lblHome).addComponent(this.lblSystemInfo, -1, 265, Short.MAX_VALUE)))).addContainerGap()));
        pnlMainLayout.setVerticalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.lblMainIcon, -2, 128, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDonate)).addGroup(pnlMainLayout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHome).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMyHome).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSystemInfo, -2, 100, -2))).addGap(11, 11, 11)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void lblHomeMouseClicked(MouseEvent evt) {
        Utils.openURL("http://www.mypasswords7.com");
    }

    private void lblMyHomeMouseClicked(MouseEvent evt) {
        Utils.openURL("http://www.mypasswords7.com/survey");
    }

    private void formKeyPressed(KeyEvent evt) {
        this.formKeyPress(evt);
    }

    private void btnDonateActionPerformed(ActionEvent evt) {
        this.btnDonateActionPerform(evt);
    }

    private void btnDonateKeyPressed(KeyEvent evt) {
        this.setVisible(false);
        this.dispose();
        System.gc();
    }

    private void myInitComponent() {
        URL url = ResourceLoader.class.getResource("safe.png");
        ImageIcon safeIcon = new ImageIcon(url);
        this.setIconImage(safeIcon.getImage());
        Domain domain = Domain.getInstance();
        this.lblTitle.setText(this.lblTitle.getText() + " " + domain.getMyPasswordsVersion());
        url = ResourceLoader.class.getResource("safe128.png");
        this.lblMainIcon.setIcon(new ImageIcon(url));
        this.displaySystemInfo();
    }

    private void displaySystemInfo() {
        try {
            Properties systemProperties = System.getProperties();
            if (systemProperties != null) {
                this.lblSystemInfo.setText(String.format("<html><b>System Information</b><br/>OS: %s version %s %s<br/>Java Vendor: %s<br/>Java Version: %s</html>", systemProperties.get("os.name"), systemProperties.get("os.version"), systemProperties.get("os.arch"), systemProperties.get("java.vm.vendor"), systemProperties.get("java.specification.version")));
            }
        }
        catch (Exception ex) {
            Logger.log(ex.getMessage());
        }
    }

    private void formKeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 27) {
            this.closeDialog();
        }
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    private void changeLanguage(Properties currentLanguage) {
        try {
            this.setDirection(currentLanguage.getProperty("direction"));
            this.setTitle(currentLanguage.getProperty("AboutMyPassword"));
            this.refresh();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error occured in changing language!", "Error", 0);
        }
    }

    private void setDirection(String direction) {
        block3: {
            block2: {
                if (!direction.equals("rtl")) break block2;
                this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                this.pnlMain.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                for (int i = 0; i < this.pnlMain.getComponents().length; ++i) {
                    Component component = this.pnlMain.getComponents()[i];
                    component.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
                break block3;
            }
            if (!direction.equals("ltr")) break block3;
            this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.pnlMain.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            for (int i = 0; i < this.pnlMain.getComponents().length; ++i) {
                Component component = this.pnlMain.getComponents()[i];
                component.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
        }
    }

    private void refresh() {
        this.pnlMain.setVisible(false);
        this.pnlMain.setVisible(true);
    }

    private void btnDonateActionPerform(ActionEvent evt) {
        Utils.openURL("http://www.mypasswords7.com/donate");
    }
}

