/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords;

import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Domain {
    public static final String connectionUrl = "jdbc:derby:database;user=app;password=13621215;";
    public static final String driverClassName = "org.apache.derby.jdbc.EmbeddedDriver";
    private static Domain instance = null;
    private long lastConnection = System.currentTimeMillis();
    private String password;

    protected Domain() {
    }

    public static Domain getInstance() {
        if (instance == null) {
            instance = new Domain();
        }
        return instance;
    }

    public Connection getDBConnection() {
        String path = Utils.getPathOfJar(true);
        System.setProperty("derby.system.home", path);
        Connection dbConnection = null;
        try {
            Class.forName(driverClassName);
            try {
                dbConnection = DriverManager.getConnection(connectionUrl);
                this.lastConnection = System.currentTimeMillis();
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.log(ex.getMessage());
        }
        return dbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSetting(String key, String encryptionKey) {
        Connection con = this.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = String.format("SELECT * FROM SETTING WHERE \"KEY\" = '%s'", key);
                ResultSet rs = st.executeQuery(sql);
                if (rs.next()) {
                    String value = rs.getString("value");
                    if (encryptionKey != null) {
                        try {
                            value = Utils.decrypt(encryptionKey, value);
                        }
                        catch (Exception ex) {
                            Logger.log(ex.getMessage());
                        }
                    }
                    String ex = value;
                    return ex;
                }
                String string = null;
                return string;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                String string = null;
                return string;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return null;
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSetting(String key, String value, String encriptionKey) {
        Connection con = this.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = "";
                if (encriptionKey != null) {
                    try {
                        value = Utils.encrypt(encriptionKey, value);
                    }
                    catch (Exception ex) {
                        Logger.log(ex.getMessage());
                    }
                }
                sql = this.getSetting(key, null) != null ? String.format("UPDATE SETTING SET VALUE = '%s' WHERE \"KEY\" = '%s'", value, key) : String.format("INSERT INTO SETTING (\"KEY\", VALUE) VALUES ('%s', '%s')", key, value);
                boolean ex = st.executeUpdate(sql) == 1;
                return ex;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setHashedSetting(String key, String value) throws NoSuchAlgorithmException {
        Connection con = this.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = "";
                value = Utils.SHA256(value);
                sql = this.getSetting(key, null) != null ? String.format("UPDATE SETTING SET VALUE = '%s' WHERE \"KEY\" = '%s'", value, key) : String.format("INSERT INTO SETTING (\"KEY\", VALUE) VALUES ('%s', '%s')", key, value);
                boolean bl = st.executeUpdate(sql) == 1;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    public int minutesOfLastDBConnection() {
        long now = System.currentTimeMillis();
        long difference = now - this.lastConnection;
        int minutes = Math.round(difference / 60000L);
        return minutes;
    }

    public float getMyPasswordsVersion() {
        return 2.95f;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

