/*
 * Decompiled with CFR 0.152.
 */
package shared.table;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class JTableHelper {
    public static void selectRow(JTable table, int row, boolean bScroll) {
        assert (row >= 0 && row < table.getRowCount());
        if (row >= 0 && row < table.getRowCount()) {
            table.setRowSelectionInterval(row, row);
            if (bScroll) {
                Rectangle rect = table.getCellRect(row, 0, true);
                table.scrollRectToVisible(rect);
            }
        }
    }

    public static void setTableHeaderCellRenderer(TableColumn tableCol) {
        tableCol.setHeaderRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (table != null) {
                    JComponent c = (JComponent)((Object)table.getTableHeader().getDefaultRenderer());
                    this.setForeground(c.getForeground());
                    this.setBackground(c.getBackground());
                    this.setFont(c.getFont());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                }
                this.setText(value != null ? value.toString() : "");
                this.setHorizontalAlignment(0);
                return this;
            }
        });
    }

    public static void setTableHeaderCellRenderer(JTable table) {
        TableColumnModel colModel = table.getColumnModel();
        int anzahl = colModel.getColumnCount();
        for (int i = 0; i < anzahl; ++i) {
            JTableHelper.setTableHeaderCellRenderer(colModel.getColumn(i));
        }
    }

    public static void autoAdjustColWidths(JTable table) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
            TableColumn col = colModel.getColumn(i);
            int width = 4;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, i);
            width = comp.getPreferredSize().width + 4;
            for (int j = 0; j < table.getRowCount(); ++j) {
                int h;
                renderer = table.getCellRenderer(j, i);
                if (renderer == null) {
                    table.getDefaultRenderer(String.class);
                }
                if ((h = renderer.getTableCellRendererComponent((JTable)table, (Object)table.getValueAt((int)j, (int)i), (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width + 4) <= width) continue;
                width = h;
            }
            col.setPreferredWidth(width);
            col.setWidth(width);
        }
    }
}

