/*
 * Decompiled with CFR 0.152.
 */
package shared.files;

import java.io.File;
import shared.files.JPathHelper;

public class JRelPathHelper {
    public static String getAbsolutPath(File refFile, String relPath) {
        return JRelPathHelper.getAbsolutPath(refFile.getPath(), relPath);
    }

    public static String getAbsolutPath(String refPath, String relPath) {
        String str;
        File file = new File(relPath);
        if (file.isAbsolute()) {
            str = relPath;
        } else {
            str = JPathHelper.getFolder(refPath);
            while (relPath.length() > 3 && relPath.substring(0, 2).equals("..")) {
                str = JPathHelper.getFolder(str);
                relPath = relPath.substring(3, relPath.length());
            }
            str = JPathHelper.addSeparator(str);
            str = str + relPath;
        }
        return str;
    }

    public static String getRelativePath(File refFile, String fullPath) {
        return JRelPathHelper.getRelativePath(refFile.getPath(), fullPath);
    }

    public static String getRelativePath(String refPath, String fullPath) {
        int index;
        StringBuilder stringBuilder = new StringBuilder();
        String[] refArray = refPath.split("\\" + File.separator);
        String[] fullArray = fullPath.split("\\" + File.separator);
        for (index = 0; index < Math.min(refArray.length, fullArray.length) && refArray[index].equals(fullArray[index]); ++index) {
        }
        if (index != 0) {
            int h = index;
            while (index++ < refArray.length - 1) {
                stringBuilder.append(".." + File.separator);
            }
            while (h < fullArray.length) {
                JPathHelper.addSeparator(stringBuilder);
                stringBuilder.append(fullArray[h]);
                ++h;
            }
        } else {
            stringBuilder.append(fullPath);
        }
        return stringBuilder.toString();
    }
}

