/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jgpstrackedit.data.Track;
import jgpstrackedit.international.International;
import net.miginfocom.swing.MigLayout;

public class DlgMerge
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField textField;
    private JComboBox comboBox;
    private JCheckBox chckbxMergeDirectwithout;
    private int mergeOption = 0;
    private Track mergeTrack;
    private ArrayList<Track> tracks;
    private String trackName;

    public Track getMergeTrack() {
        return this.mergeTrack;
    }

    public DlgMerge(String trackNameM, ArrayList<Track> tracksList) {
        this.tracks = tracksList;
        this.trackName = trackNameM;
        this.setTitle(International.getText("dlgMerge.Merge_Options"));
        this.setBounds(100, 100, 500, 206);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(this.contentPanel);
        this.contentPanel.setLayout(new MigLayout("", "[80.00][276.00,grow]", "[][][]"));
        JLabel lblMergeWith = new JLabel(String.valueOf(International.getText("dlgMerge.merge_with")) + ":");
        this.contentPanel.add((Component)lblMergeWith, "cell 0 0,alignx left");
        this.comboBox = new JComboBox();
        this.contentPanel.add((Component)this.comboBox, "cell 1 0,growx");
        for (Track track : this.tracks) {
            this.comboBox.addItem(track.getName());
        }
        JLabel lblTrackName = new JLabel(String.valueOf(International.getText("dlgMerge.track_name")) + ":");
        this.contentPanel.add((Component)lblTrackName, "cell 0 1,alignx left");
        this.textField = new JTextField();
        this.textField.setText(this.trackName);
        this.contentPanel.add((Component)this.textField, "cell 1 1,growx");
        this.textField.setColumns(10);
        this.chckbxMergeDirectwithout = new JCheckBox("Merge direct (without considering track directions)");
        this.contentPanel.add((Component)this.chckbxMergeDirectwithout, "cell 1 2");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add(buttonPane);
        JButton okButton = new JButton(International.getText("OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Track track : DlgMerge.this.tracks) {
                    if (!((String)DlgMerge.this.comboBox.getSelectedItem()).equals(track.getName())) continue;
                    DlgMerge.this.mergeTrack = track;
                }
                if (DlgMerge.this.mergeTrack.getName().equals(DlgMerge.this.trackName)) {
                    JOptionPane.showMessageDialog(null, International.getText("dlgMerge.Merge_to_same_track"), International.getText("dlgMerge.Merge_Error"), 0);
                } else {
                    DlgMerge.this.setVisible(false);
                    if (DlgMerge.this.chckbxMergeDirectwithout.isSelected()) {
                        DlgMerge.this.mergeOption = 2;
                    } else {
                        DlgMerge.this.mergeOption = 1;
                    }
                }
            }
        });
        okButton.setActionCommand(International.getText("OK"));
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setVisible(false);
        JButton cancelButton = new JButton(International.getText("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgMerge.this.setVisible(false);
                DlgMerge.this.mergeOption = 0;
            }
        });
        cancelButton.setActionCommand(International.getText("Cancel"));
        buttonPane.add(cancelButton);
    }

    public int getMergeOption() {
        return this.mergeOption;
    }

    public String getTrackName() {
        return this.textField.getText();
    }
}

