/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.util;

import jgpstrackedit.config.SystemConfig;

public class TileNumber
implements Comparable {
    private int zoom;
    private int x;
    private int y;

    public TileNumber(int zoom, int x, int y) {
        this.setZoom(zoom);
        this.setX(x);
        this.setY(y);
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String toString() {
        return "/" + this.zoom + "/" + this.x + "/" + this.y;
    }

    public String toFileName() {
        return String.valueOf(SystemConfig.dirSeparator()) + this.zoom + SystemConfig.dirSeparator() + this.x + SystemConfig.dirSeparator() + this.y;
    }

    public boolean equals(Object obj) {
        TileNumber t = (TileNumber)obj;
        return this.getY() == t.getY() && this.getX() == t.getX() && this.getZoom() == t.getZoom();
    }

    public int hashCode() {
        return (this.getZoom() * 1000 + this.getY() + this.getX()) % 30011;
    }

    public static TileNumber getTileNumber(int zoom, double lon, double lat) {
        int xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
        int ytile = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
        return new TileNumber(zoom, xtile, ytile);
    }

    public int compareTo(Object arg0) {
        return this.toString().compareTo(arg0.toString());
    }
}

