/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.util;

import jgpstrackedit.map.util.TileNumber;

public class TileBoundary {
    private double north;
    private double south;
    private double east;
    private double west;

    public double getNorth() {
        return this.north;
    }

    public void setNorth(double north) {
        this.north = north;
    }

    public double getSouth() {
        return this.south;
    }

    public void setSouth(double south) {
        this.south = south;
    }

    public double getEast() {
        return this.east;
    }

    public void setEast(double east) {
        this.east = east;
    }

    public double getWest() {
        return this.west;
    }

    public void setWest(double west) {
        this.west = west;
    }

    public double getCenterLongitude() {
        return (this.west + this.east) / 2.0;
    }

    public double getCenterLatitude() {
        return (this.north + this.south) / 2.0;
    }

    public static TileBoundary getTileBoundary(TileNumber tileNumber) {
        TileBoundary bb = new TileBoundary();
        bb.north = TileBoundary.tile2lat(tileNumber.getY(), tileNumber.getZoom());
        bb.south = TileBoundary.tile2lat(tileNumber.getY() + 1, tileNumber.getZoom());
        bb.west = TileBoundary.tile2lon(tileNumber.getX(), tileNumber.getZoom());
        bb.east = TileBoundary.tile2lon(tileNumber.getX() + 1, tileNumber.getZoom());
        return bb;
    }

    static double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    static double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    public String toString() {
        return "WNES [" + this.west + ";" + this.north + "][" + this.east + ";" + this.south + "]";
    }

    public static double scaleX(int zoomLevel) {
        return 360.0 / (double)(1 << zoomLevel) / 256.0;
    }

    public static double scaleY(TileNumber tileNumber) {
        TileBoundary tb = TileBoundary.getTileBoundary(tileNumber);
        int pixel_per_tile = 256;
        return (tb.getNorth() - tb.getSouth()) / (double)pixel_per_tile;
    }

    public static double scaleY(int zoomLevel, double longitude, double latitude) {
        return TileBoundary.scaleY(TileNumber.getTileNumber(zoomLevel, longitude, latitude));
    }
}

