/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.tiledownload;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DlgStartTiledownloadMode
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JRadioButton rdbtnUseLoadedTracks;
    private JLabel lblDefineTileDownload;
    private JRadioButton rdbtnLoadExistingTile;
    private JTextField textField;
    private JButton btnSearchFile;
    private JRadioButton rdbtnStartWithEmpty;
    private JLabel lblZoomLevel;
    private JRadioButton rdbtnUseCurrentZoom;
    private JRadioButton rdbtnChooseZoomLevel;
    private JComboBox comboBox;
    private ButtonGroup definition;
    private ButtonGroup zoom;
    public static final int RESULT_CANCEL = 0;
    public static final int TRACKS = 1;
    public static final int FILE = 2;
    public static final int EMPTY = 3;
    private int result = 1;

    public DlgStartTiledownloadMode(JFrame frame, int currentZoom, int maxZoom) {
        super((Frame)frame, true);
        this.initComponents(currentZoom, maxZoom);
    }

    public int getResult() {
        return this.result;
    }

    public int getDownloadZoom() {
        return Integer.parseInt(this.comboBox.getSelectedItem().toString());
    }

    public String getFilePath() {
        return this.textField.getText();
    }

    private void initComponents(int currentZoom, int maxZoom) {
        this.setTitle("Start Tile Download Mode");
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.rdbtnUseLoadedTracks = new JRadioButton("Use loaded tracks");
        this.rdbtnUseLoadedTracks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartTiledownloadMode.this.rdbtnUseLoadedTracksActionPerformed(e);
            }
        });
        this.rdbtnUseLoadedTracks.setSelected(true);
        this.rdbtnUseLoadedTracks.setBounds(20, 34, 327, 23);
        this.contentPanel.add(this.rdbtnUseLoadedTracks);
        this.lblDefineTileDownload = new JLabel("Define tile download definition");
        this.lblDefineTileDownload.setBounds(10, 11, 373, 14);
        this.contentPanel.add(this.lblDefineTileDownload);
        this.rdbtnLoadExistingTile = new JRadioButton("Load existing tile download definition");
        this.rdbtnLoadExistingTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DlgStartTiledownloadMode.this.rdbtnLoadExistingTileActionPerformed(arg0);
            }
        });
        this.rdbtnLoadExistingTile.setBounds(20, 60, 304, 23);
        this.contentPanel.add(this.rdbtnLoadExistingTile);
        this.textField = new JTextField();
        this.textField.setBounds(42, 90, 268, 20);
        this.contentPanel.add(this.textField);
        this.textField.setColumns(10);
        this.btnSearchFile = new JButton("Search File");
        this.btnSearchFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DlgStartTiledownloadMode.this.btnSearchFileActionPerformed(arg0);
            }
        });
        this.btnSearchFile.setBounds(320, 90, 112, 23);
        this.contentPanel.add(this.btnSearchFile);
        this.rdbtnStartWithEmpty = new JRadioButton("Start with empty tile download definition");
        this.rdbtnStartWithEmpty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartTiledownloadMode.this.rdbtnStartWithEmptyActionPerformed(e);
            }
        });
        this.rdbtnStartWithEmpty.setBounds(20, 117, 290, 23);
        this.contentPanel.add(this.rdbtnStartWithEmpty);
        this.lblZoomLevel = new JLabel("Zoom level");
        this.lblZoomLevel.setBounds(10, 147, 235, 14);
        this.contentPanel.add(this.lblZoomLevel);
        this.rdbtnUseCurrentZoom = new JRadioButton("Use current zoom level");
        this.rdbtnUseCurrentZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartTiledownloadMode.this.rdbtnUseCurrentZoomActionPerformed(e);
            }
        });
        this.rdbtnUseCurrentZoom.setSelected(true);
        this.rdbtnUseCurrentZoom.setBounds(20, 168, 290, 23);
        this.contentPanel.add(this.rdbtnUseCurrentZoom);
        this.rdbtnChooseZoomLevel = new JRadioButton("Choose zoom level");
        this.rdbtnChooseZoomLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartTiledownloadMode.this.rdbtnChooseZoomLevelActionPerformed(e);
            }
        });
        this.rdbtnChooseZoomLevel.setBounds(20, 194, 173, 23);
        this.contentPanel.add(this.rdbtnChooseZoomLevel);
        this.comboBox = new JComboBox();
        this.comboBox.setBounds(199, 195, 111, 20);
        int i = 1;
        while (i <= maxZoom) {
            this.comboBox.addItem(i);
            ++i;
        }
        this.comboBox.setSelectedItem(currentZoom);
        this.contentPanel.add(this.comboBox);
        this.definition = new ButtonGroup();
        this.definition.add(this.rdbtnUseLoadedTracks);
        this.definition.add(this.rdbtnLoadExistingTile);
        this.definition.add(this.rdbtnStartWithEmpty);
        this.zoom = new ButtonGroup();
        this.zoom.add(this.rdbtnUseCurrentZoom);
        this.zoom.add(this.rdbtnChooseZoomLevel);
        this.ableFile(false);
        this.ableZoom(false);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartTiledownloadMode.this.okButtonActionPerformed(e);
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgStartTiledownloadMode.this.cancelButtonActionPerformed(e);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }

    private void ableFile(boolean value) {
        this.textField.setEditable(value);
        this.btnSearchFile.setEnabled(value);
    }

    protected void rdbtnLoadExistingTileActionPerformed(ActionEvent arg0) {
        this.ableFile(true);
        this.result = 2;
    }

    protected void rdbtnUseLoadedTracksActionPerformed(ActionEvent e) {
        this.ableFile(false);
        this.result = 1;
    }

    protected void rdbtnStartWithEmptyActionPerformed(ActionEvent e) {
        this.ableFile(false);
        this.result = 3;
    }

    private void ableZoom(boolean value) {
        this.comboBox.setEditable(value);
        this.comboBox.setEnabled(value);
    }

    protected void rdbtnUseCurrentZoomActionPerformed(ActionEvent e) {
        this.ableZoom(false);
    }

    protected void rdbtnChooseZoomLevelActionPerformed(ActionEvent e) {
        this.ableZoom(true);
    }

    protected void okButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    protected void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.result = 0;
    }

    protected void btnSearchFileActionPerformed(ActionEvent arg0) {
        JFileChooser fileOpenChooser = new JFileChooser();
        int returnVal = fileOpenChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fileOpenChooser.getSelectedFile();
            this.textField.setText(file.getPath());
        }
    }
}

