/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.gpsies;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jgpstrackedit.data.Track;
import jgpstrackedit.gpsies.GPSiesUpLoad;
import jgpstrackedit.international.International;
import org.apache.commons.httpclient.HttpException;

public class GPSiesSaveDlg
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JLabel lblTrackName;
    private JTextField textFieldTrackName;
    private JLabel lblTrackType;
    private JComboBox comboBoxTrackTypes;
    private Track saveTrack;
    private JLabel lblErrorlog;
    private JTextArea textAreaErrorLog;
    private GPSiesUpLoad gpsUpLoad;
    private JLabel lblUsername;
    private JTextField textFieldUsername;
    private JLabel lblPassword;
    private JPasswordField passwordField;

    public GPSiesSaveDlg(Track saveTrack) {
        this.saveTrack = saveTrack;
        this.initComponents();
        this.gpsUpLoad = new GPSiesUpLoad();
        if (!this.gpsUpLoad.checkUploadable(saveTrack)) {
            this.textAreaErrorLog.setText(International.getText("dlgGPSies.Error_length"));
        }
    }

    private void initComponents() {
        this.setTitle(International.getText("dlgGPSies.Save_Track"));
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.lblTrackName = new JLabel(String.valueOf(International.getText("dlgGPSies.Track_name")) + ":");
        this.lblTrackName.setBounds(10, 11, 94, 14);
        this.contentPanel.add(this.lblTrackName);
        this.textFieldTrackName = new JTextField();
        this.textFieldTrackName.setText(this.saveTrack.getName());
        this.textFieldTrackName.setBounds(114, 8, 318, 20);
        this.contentPanel.add(this.textFieldTrackName);
        this.textFieldTrackName.setColumns(10);
        this.lblTrackType = new JLabel(String.valueOf(International.getText("dlgGPSies.Track_types")) + ":");
        this.lblTrackType.setBounds(10, 36, 94, 14);
        this.contentPanel.add(this.lblTrackType);
        this.comboBoxTrackTypes = new JComboBox();
        this.comboBoxTrackTypes.setModel(new DefaultComboBoxModel<String>(new String[]{"biking", "boating", "canoeing", "car", "climbing", "crossskating", "flying", "geocaching", "jogging", "miscellaneous", "motorbiking", "mountainbiking", "racingbike", "riding", "skating", "skiingAlpine", "skiingNordic", "train", "trekking", "walking", "wintersports"}));
        this.comboBoxTrackTypes.setBounds(114, 33, 118, 20);
        this.contentPanel.add(this.comboBoxTrackTypes);
        this.lblErrorlog = new JLabel(String.valueOf(International.getText("dlgGPSies.Errorlog")) + ":");
        this.lblErrorlog.setBounds(10, 111, 222, 14);
        this.contentPanel.add(this.lblErrorlog);
        this.textAreaErrorLog = new JTextArea();
        this.textAreaErrorLog.setBounds(10, 129, 422, 93);
        this.contentPanel.add(this.textAreaErrorLog);
        this.lblUsername = new JLabel(String.valueOf(International.getText("dlgGPSies.User_name")) + ":");
        this.lblUsername.setBounds(10, 61, 94, 14);
        this.contentPanel.add(this.lblUsername);
        this.textFieldUsername = new JTextField();
        this.textFieldUsername.setBounds(114, 58, 118, 20);
        this.contentPanel.add(this.textFieldUsername);
        this.textFieldUsername.setColumns(10);
        this.lblPassword = new JLabel(String.valueOf(International.getText("dlgGPSies.Password")) + ":");
        this.lblPassword.setBounds(10, 86, 94, 14);
        this.contentPanel.add(this.lblPassword);
        this.passwordField = new JPasswordField();
        this.passwordField.setBounds(114, 83, 118, 20);
        this.contentPanel.add(this.passwordField);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton(International.getText("dlgGPSies.Save"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GPSiesSaveDlg.this.okButtonActionPerformed(arg0);
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(International.getText("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPSiesSaveDlg.this.cancelButtonActionPerformed(e);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }

    protected void okButtonActionPerformed(ActionEvent arg0) {
        if (this.gpsUpLoad.checkUploadable(this.saveTrack)) {
            this.gpsUpLoad.saveTempKML(this.textFieldTrackName.getText(), this.saveTrack);
            File importFile = new File(this.gpsUpLoad.getFileName(this.textFieldTrackName.getText()));
            try {
                int result = this.gpsUpLoad.uploadFile(this.textFieldTrackName.getText(), (String)this.comboBoxTrackTypes.getSelectedItem(), importFile, this.textFieldUsername.getText(), this.passwordField.getText());
                this.textAreaErrorLog.setText("Response status code: " + result);
                System.out.println("Response status code: " + result);
                if (result == 200) {
                    this.setVisible(false);
                }
            }
            catch (HttpException e) {
                this.textAreaErrorLog.setText(e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.textAreaErrorLog.setText(e.getMessage());
            }
        }
    }

    protected void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }
}

