/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.gpsies;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.xml.parsers.ParserConfigurationException;
import jgpstrackedit.control.UIController;
import jgpstrackedit.gpsies.GPSiesResult;
import jgpstrackedit.gpsies.GPSiesResultHandlerImpl;
import jgpstrackedit.gpsies.GPSiesResultParser;
import jgpstrackedit.international.International;
import jgpstrackedit.util.Parser;
import jgpstrackedit.view.Transform;
import org.xml.sax.SAXException;

public class GPSiesComDialog
extends JDialog
implements Runnable {
    private final JPanel contentPanel = new JPanel();
    private JTextField textFieldUser;
    private JTextField textFieldPerimeter;
    private JTextField textFieldZIP;
    private JTextField textFieldCity;
    private JTextField textFieldLimit;
    private JTable tableGPSiesResult;
    private GPSiesResult gpsiesResult;
    private ButtonGroup buttonGroup;
    private JRadioButton rdbtnUserName;
    private JRadioButton rdbtnCurrentMapView;
    private JRadioButton rdbtnCenterCurrentView;
    private JRadioButton rdbtnZip;
    private JRadioButton rdbtnCity;
    private JCheckBox chckbxCountry;
    private JComboBox comboBoxCountry;
    private JCheckBox chckbxTrackProperty;
    private JComboBox comboBoxTrackProperty;
    private JCheckBox chckbxTrackTypes;
    private JComboBox comboBoxTrackTypes;
    private JButton btnStoppLoading;
    private boolean stoppLoading = false;
    private UIController uiController;
    private JProgressBar progressBarLoading;

    public GPSiesComDialog(UIController uiController) {
        this.uiController = uiController;
        this.setTitle(International.getText("dlgGPSies.GPSies"));
        this.setBounds(100, 100, 800, 338);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPaneTable = new JSplitPane();
        this.buttonGroup = new ButtonGroup();
        JPanel panelParameter = new JPanel();
        panelParameter.setMinimumSize(new Dimension(250, 200));
        panelParameter.setPreferredSize(new Dimension(150, 200));
        this.contentPanel.add((Component)splitPaneTable, "Center");
        panelParameter.setLayout(null);
        this.rdbtnUserName = new JRadioButton(String.valueOf(International.getText("dlgGPSies.User_name")) + ":");
        this.rdbtnUserName.setSelected(true);
        this.rdbtnUserName.setBounds(6, 7, 109, 23);
        panelParameter.add(this.rdbtnUserName);
        this.buttonGroup.add(this.rdbtnUserName);
        this.textFieldUser = new JTextField();
        this.textFieldUser.setBounds(122, 8, 118, 20);
        panelParameter.add(this.textFieldUser);
        this.textFieldUser.setColumns(10);
        this.rdbtnCurrentMapView = new JRadioButton(International.getText("dlgGPSies.Current_map_extract"));
        this.rdbtnCurrentMapView.setBounds(6, 33, 234, 23);
        panelParameter.add(this.rdbtnCurrentMapView);
        this.buttonGroup.add(this.rdbtnCurrentMapView);
        this.rdbtnCenterCurrentView = new JRadioButton(International.getText("dlgGPSies.Center_of"));
        this.rdbtnCenterCurrentView.setBounds(6, 59, 234, 23);
        panelParameter.add(this.rdbtnCenterCurrentView);
        this.buttonGroup.add(this.rdbtnCenterCurrentView);
        this.textFieldPerimeter = new JTextField();
        this.textFieldPerimeter.setBounds(122, 82, 86, 20);
        panelParameter.add(this.textFieldPerimeter);
        this.textFieldPerimeter.setColumns(10);
        this.rdbtnZip = new JRadioButton(String.valueOf(International.getText("dlgGPSies.ZIP")) + ":");
        this.rdbtnZip.setBounds(6, 112, 109, 23);
        panelParameter.add(this.rdbtnZip);
        this.buttonGroup.add(this.rdbtnZip);
        this.textFieldZIP = new JTextField();
        this.textFieldZIP.setBounds(122, 110, 86, 20);
        panelParameter.add(this.textFieldZIP);
        this.textFieldZIP.setColumns(10);
        this.rdbtnCity = new JRadioButton(International.getText("dlgGPSies.City"));
        this.rdbtnCity.setBounds(6, 138, 109, 23);
        panelParameter.add(this.rdbtnCity);
        this.buttonGroup.add(this.rdbtnCity);
        this.textFieldCity = new JTextField();
        this.textFieldCity.setBounds(122, 139, 118, 20);
        panelParameter.add(this.textFieldCity);
        this.textFieldCity.setColumns(10);
        this.chckbxCountry = new JCheckBox(String.valueOf(International.getText("dlgGPSies.Country")) + ":");
        this.chckbxCountry.setBounds(6, 164, 109, 23);
        panelParameter.add(this.chckbxCountry);
        this.comboBoxCountry = new JComboBox();
        this.comboBoxCountry.setModel(new DefaultComboBoxModel<String>(International.getCountries()));
        this.comboBoxCountry.setBounds(122, 165, 118, 20);
        panelParameter.add(this.comboBoxCountry);
        this.chckbxTrackProperty = new JCheckBox(String.valueOf(International.getText("dlgGPSies.Track_property")) + ":");
        this.chckbxTrackProperty.setBounds(6, 190, 116, 23);
        panelParameter.add(this.chckbxTrackProperty);
        this.comboBoxTrackProperty = new JComboBox();
        this.comboBoxTrackProperty.setModel(new DefaultComboBoxModel<String>(new String[]{"onewaytrip", "roundtrip"}));
        this.comboBoxTrackProperty.setBounds(122, 191, 118, 20);
        panelParameter.add(this.comboBoxTrackProperty);
        this.chckbxTrackTypes = new JCheckBox(String.valueOf(International.getText("dlgGPSies.Track_types")) + ":");
        this.chckbxTrackTypes.setBounds(6, 216, 109, 23);
        panelParameter.add(this.chckbxTrackTypes);
        this.comboBoxTrackTypes = new JComboBox();
        this.comboBoxTrackTypes.setModel(new DefaultComboBoxModel<String>(new String[]{"biking", "boating", "canoeing", "car", "climbing", "crossskating", "flying", "geocaching", "jogging", "miscellaneous", "motorbiking", "mountainbiking", "racingbike", "riding", "skating", "skiingAlpine", "skiingNordic", "train", "trekking", "walking", "wintersports"}));
        this.comboBoxTrackTypes.setBounds(122, 217, 118, 20);
        panelParameter.add(this.comboBoxTrackTypes);
        splitPaneTable.setBounds(379, 99, 1, 1);
        JScrollPane scrollPaneTable = new JScrollPane();
        splitPaneTable.setLeftComponent(panelParameter);
        JLabel lblKm = new JLabel("km");
        lblKm.setBounds(214, 85, 46, 14);
        panelParameter.add(lblKm);
        JLabel lblPerimeter = new JLabel(String.valueOf(International.getText("dlgGPSies.Perimeter")) + ":");
        lblPerimeter.setBounds(16, 85, 99, 14);
        panelParameter.add(lblPerimeter);
        splitPaneTable.setRightComponent(scrollPaneTable);
        this.tableGPSiesResult = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                tip = realColumnIndex == 1 ? (String)this.getValueAt(rowIndex, colIndex) : super.getToolTipText(e);
                return tip;
            }
        };
        this.tableGPSiesResult.setSelectionMode(2);
        this.tableGPSiesResult.setDefaultEditor(String.class, new DefaultCellEditor(new JTextField()));
        scrollPaneTable.setViewportView(this.tableGPSiesResult);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JLabel lblSearchResultLimit = new JLabel(String.valueOf(International.getText("dlgGPSies.Search_limit")) + ":");
        lblSearchResultLimit.setHorizontalAlignment(2);
        buttonPane.add(lblSearchResultLimit);
        this.textFieldLimit = new JTextField();
        this.textFieldLimit.setText("20");
        buttonPane.add(this.textFieldLimit);
        this.textFieldLimit.setColumns(4);
        JButton okButton = new JButton(International.getText("dlgGPSies.Search_Tracks"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GPSiesComDialog.this.searchTracks();
            }
        });
        okButton.setActionCommand(International.getText("OK"));
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton btnLoadSelectedTracks = new JButton(International.getText("dlgGPSies.Load_selected_Tracks"));
        btnLoadSelectedTracks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GPSiesComDialog.this.startLoading();
            }
        });
        buttonPane.add(btnLoadSelectedTracks);
        JButton cancelButton = new JButton(International.getText("Close"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GPSiesComDialog.this.setVisible(false);
            }
        });
        this.btnStoppLoading = new JButton(International.getText("dlgGPSies.Stop_loading"));
        this.btnStoppLoading.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GPSiesComDialog.this.setStoppLoading(true);
            }
        });
        this.progressBarLoading = new JProgressBar();
        this.progressBarLoading.setPreferredSize(new Dimension(146, 26));
        this.progressBarLoading.setStringPainted(true);
        this.progressBarLoading.setToolTipText(International.getText("dlgGPSies.Progress_loading_selected_tracks"));
        buttonPane.add(this.progressBarLoading);
        buttonPane.add(this.btnStoppLoading);
        cancelButton.setActionCommand(International.getText("Cancel"));
        buttonPane.add(cancelButton);
    }

    protected void startLoading() {
        this.progressBarLoading.setValue(0);
        new Thread(this).start();
    }

    protected void searchTracks() {
        jgpstrackedit.data.Point getLowerRightBoundary;
        jgpstrackedit.data.Point getUpperLeftBoundary;
        StringBuilder urlString = new StringBuilder("http://ws.gpsies.com/api.do?key=eiqteveemajmlfhn");
        if (this.rdbtnUserName.isSelected()) {
            urlString.append("&username=");
            urlString.append(this.textFieldUser.getText());
            this.appendCountry(urlString);
        }
        if (this.rdbtnCurrentMapView.isSelected()) {
            urlString.append("&BBOX=");
            getUpperLeftBoundary = Transform.getUpperLeftBoundary();
            getLowerRightBoundary = Transform.getLowerRightBoundary();
            urlString.append(getUpperLeftBoundary.getLongitudeAsString());
            urlString.append(",");
            urlString.append(getLowerRightBoundary.getLatitudeAsString());
            urlString.append(",");
            urlString.append(getLowerRightBoundary.getLongitudeAsString());
            urlString.append(",");
            urlString.append(getUpperLeftBoundary.getLatitudeAsString());
        }
        if (this.rdbtnCenterCurrentView.isSelected()) {
            getUpperLeftBoundary = Transform.getUpperLeftBoundary();
            getLowerRightBoundary = Transform.getLowerRightBoundary();
            urlString.append("&lat=");
            urlString.append(Parser.formatLatitude((getUpperLeftBoundary.getLatitude() + getLowerRightBoundary.getLatitude()) / 2.0));
            urlString.append("&lat=");
            urlString.append(Parser.formatLongitude((getUpperLeftBoundary.getLongitude() + getLowerRightBoundary.getLongitude()) / 2.0));
            urlString.append("&perimeter=");
            urlString.append(Parser.parseDouble(this.textFieldPerimeter.getText()));
        }
        if (this.rdbtnZip.isSelected()) {
            urlString.append("&zip=");
            urlString.append(this.textFieldZIP.getText());
            this.appendCountry(urlString);
        }
        if (this.rdbtnCity.isSelected()) {
            urlString.append("&city=");
            urlString.append(this.textFieldCity.getText());
            this.appendCountry(urlString);
        }
        if (this.chckbxTrackProperty.isSelected()) {
            urlString.append("&trackProperty=");
            urlString.append(this.comboBoxTrackProperty.getSelectedItem());
        }
        if (this.chckbxTrackTypes.isSelected()) {
            urlString.append("&trackTypes=");
            urlString.append(this.comboBoxTrackTypes.getSelectedItem());
        }
        urlString.append("&limit=");
        urlString.append(Parser.parseInt(this.textFieldLimit.getText()));
        urlString.append("&filetype=kml");
        System.out.println("GPSIES: " + urlString);
        this.gpsiesResult = this.gpsiesGetResults(urlString.toString());
        this.tableGPSiesResult.setModel(this.gpsiesResult);
    }

    protected GPSiesResult gpsiesGetResults(String urlString) {
        GPSiesResultHandlerImpl handler = new GPSiesResultHandlerImpl();
        GPSiesResultParser parser = new GPSiesResultParser(handler, null);
        try {
            URL url = new URL(urlString);
            parser.parse(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return handler.getResult();
    }

    protected void appendCountry(StringBuilder urlString) {
        if (this.chckbxCountry.isSelected()) {
            urlString.append("&country=");
            urlString.append(this.comboBoxCountry.getSelectedItem());
        }
    }

    protected void setStoppLoading(boolean stoppLoading) {
        this.stoppLoading = stoppLoading;
    }

    @Override
    public void run() {
        int[] selectedRows = this.tableGPSiesResult.getSelectedRows();
        int i = 0;
        while (!this.stoppLoading && i < selectedRows.length) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String downloadURL = this.gpsiesResult.get(selectedRows[i]).getDownloadlink();
            System.out.println("GPSIES-Download: " + downloadURL);
            this.uiController.openTrack(downloadURL);
            this.progressBarLoading.setValue((i + 1) * 100 / selectedRows.length);
            ++i;
        }
    }
}

