/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.config.view;

import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.config.view.ConfigurationPanel;
import jgpstrackedit.data.util.TourPlaner;
import jgpstrackedit.international.International;
import jgpstrackedit.util.Parser;

public class TourPlanerPanel
extends JPanel
implements ConfigurationPanel {
    private JTextField textFieldAverageSpeed;
    private JTextField textFieldInclineTime;
    private JTextField textFieldBreakRatio;
    private JTextField textFieldMaxTourTime;
    private DecimalFormat df = new DecimalFormat("#####0.000");

    public TourPlanerPanel() {
        this.setLayout(null);
        JLabel lblAverageDrivingSpeed = new JLabel(String.valueOf(International.getText("dlgconfig.Average_driving_speed")) + ":");
        lblAverageDrivingSpeed.setToolTipText(International.getText("dlgconfig.Average_speed"));
        lblAverageDrivingSpeed.setBounds(10, 11, 278, 14);
        this.add(lblAverageDrivingSpeed);
        this.textFieldAverageSpeed = new JTextField();
        this.textFieldAverageSpeed.setBounds(298, 8, 86, 20);
        this.add(this.textFieldAverageSpeed);
        this.textFieldAverageSpeed.setColumns(10);
        JLabel lblKmh = new JLabel("km/h");
        lblKmh.setBounds(394, 11, 46, 14);
        this.add(lblKmh);
        JLabel lblInclineTimeFor = new JLabel(String.valueOf(International.getText("dlgconfig.Incline_time")) + ":");
        lblInclineTimeFor.setToolTipText(International.getText("dlgconfig.Additional_time_to_climb"));
        lblInclineTimeFor.setBounds(10, 36, 278, 14);
        this.add(lblInclineTimeFor);
        this.textFieldInclineTime = new JTextField();
        this.textFieldInclineTime.setBounds(298, 33, 86, 20);
        this.add(this.textFieldInclineTime);
        this.textFieldInclineTime.setColumns(10);
        JLabel lblMin = new JLabel("min");
        lblMin.setBounds(394, 36, 46, 14);
        this.add(lblMin);
        JLabel lblBreakRatio = new JLabel(String.valueOf(International.getText("dlgconfig.Break_ratio")) + ":");
        lblBreakRatio.setToolTipText(International.getText("dlgconfig.Defines_the_ratio"));
        lblBreakRatio.setBounds(10, 61, 278, 14);
        this.add(lblBreakRatio);
        this.textFieldBreakRatio = new JTextField();
        this.textFieldBreakRatio.setBounds(298, 58, 86, 20);
        this.add(this.textFieldBreakRatio);
        this.textFieldBreakRatio.setColumns(10);
        JLabel lblNewLabel = new JLabel(String.valueOf(International.getText("dlgconfig.Maximum_duration_of_an")) + ":");
        lblNewLabel.setToolTipText(International.getText("dlgconfig.Value_used_for_multiple"));
        lblNewLabel.setBounds(10, 86, 278, 14);
        this.add(lblNewLabel);
        this.textFieldMaxTourTime = new JTextField();
        this.textFieldMaxTourTime.setBounds(298, 83, 86, 20);
        this.add(this.textFieldMaxTourTime);
        this.textFieldMaxTourTime.setColumns(10);
        JLabel lblH = new JLabel("hh:mm");
        lblH.setBounds(394, 86, 46, 14);
        this.add(lblH);
    }

    @Override
    public String getTabName() {
        return International.getText("dlgconfig.Tourplanner");
    }

    @Override
    public void save() {
        TourPlaner.setAverageSpeed(Parser.parseDouble(this.textFieldAverageSpeed.getText()));
        TourPlaner.setInclineTime100Meters(Parser.parseDouble(this.textFieldInclineTime.getText()));
        TourPlaner.setBreakRatio(Parser.parseDouble(this.textFieldBreakRatio.getText()));
        TourPlaner.setMaxTourTime(Parser.parseTime(this.textFieldMaxTourTime.getText()));
        Configuration.setProperty("AVERAGESPEED", this.textFieldAverageSpeed.getText());
        Configuration.setProperty("INCLINETIME100METERS", this.textFieldInclineTime.getText());
        Configuration.setProperty("BREAKRATIO", this.textFieldBreakRatio.getText());
        Configuration.setProperty("MAXTOURTIME", this.textFieldMaxTourTime.getText());
    }

    @Override
    public void cancel() {
    }

    @Override
    public void initialize() {
        this.textFieldAverageSpeed.setText(this.df.format(TourPlaner.getAverageSpeed()));
        this.textFieldInclineTime.setText(this.df.format(TourPlaner.getInclineTime100Meters()));
        this.textFieldBreakRatio.setText(this.df.format(TourPlaner.getBreakRatio()));
        this.textFieldMaxTourTime.setText(Parser.formatTimeHHMM(TourPlaner.getMaxTourTime()));
    }
}

