/*
 * Decompiled with CFR 0.152.
 */
package launcher.ipc;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;
import launcher.ipc.CallHandler;
import launcher.ipc.IPCHelper;

public class Server {
    private static final Logger LOG = Logger.getLogger("genj.ipc");
    private int maxBuffer = 256;
    private ServerSocket local;
    private CallHandler handler;
    private int timeout = 200;
    private String[] terminators = IPCHelper.TERMINATORS;
    private Thread thread;

    public Server(int n, CallHandler callHandler) throws IOException {
        this.handler = callHandler;
        this.local = new ServerSocket(n);
        this.thread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Server.this.read();
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws IOException {
        Socket socket = this.local.accept();
        try {
            socket.setSoTimeout(this.timeout);
            String string = IPCHelper.read(socket.getInputStream(), this.terminators, this.maxBuffer);
            String string2 = this.handler.handleCall(string);
            IPCHelper.write(socket.getOutputStream(), string2 + this.terminators[0]);
        }
        catch (IOException iOException) {
            LOG.info(iOException.getMessage() + " (" + socket.getRemoteSocketAddress() + ")");
        }
        finally {
            socket.close();
        }
    }
}

