/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.ViewPortAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewPortOverview
extends JPanel {
    private static final int DIM_RESIZE = 6;
    private JViewport viewport;
    private Rectangle last;

    public ViewPortOverview(JViewport jViewport) {
        this.viewport = jViewport;
        EventGlue eventGlue = new EventGlue();
        this.viewport.addChangeListener(eventGlue);
        this.addMouseListener(eventGlue);
        this.addMouseMotionListener(eventGlue);
        this.viewport.addComponentListener(eventGlue);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Point2D point2D = this.getZoom();
        this.renderContent(graphics, point2D.getX(), point2D.getY());
        graphics.setColor(new Color(0, 128, 0));
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        if (point2D == null) {
            point2D = this.getZoom();
        }
        Rectangle rectangle = this.viewport.getViewRect();
        this.last = new Rectangle((int)((double)rectangle.x * point2D.getX()), (int)((double)rectangle.y * point2D.getY()), (int)((double)rectangle.width * point2D.getX()), (int)((double)rectangle.height * point2D.getY()));
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.drawRect(this.last.x, this.last.y, this.last.width, this.last.height);
        graphics2D.setColor(new Color(0, 255, 0, 64));
        graphics.fillRect(this.last.x, this.last.y, this.last.width, this.last.height);
    }

    protected void renderContent(Graphics graphics, double d, double d2) {
    }

    private Point2D getZoom() {
        Dimension dimension = this.getSize();
        Component component = this.viewport.getView();
        if (component instanceof ViewPortAdapter) {
            component = ((ViewPortAdapter)component).getComponent();
        }
        Dimension dimension2 = component.getSize();
        return new Point2D.Double((double)dimension.width / (double)dimension2.width, (double)dimension.height / (double)dimension2.height);
    }

    private class EventGlue
    extends ComponentAdapter
    implements ChangeListener,
    MouseListener,
    MouseMotionListener {
        private Point dragOffset = null;
        private boolean isResize = false;

        private EventGlue() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!ViewPortOverview.this.isVisible()) {
                return;
            }
            ViewPortOverview.this.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Rectangle rectangle = ViewPortOverview.this.viewport.getViewRect();
            Point2D point2D = ViewPortOverview.this.getZoom();
            int n = (int)((double)mouseEvent.getPoint().x / point2D.getX());
            int n2 = (int)((double)mouseEvent.getPoint().y / point2D.getY());
            ViewPortOverview.this.viewport.setViewPosition(new Point(n - rectangle.width / 2, n2 - rectangle.height / 2));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            this.isResize = this.isResize(point);
            this.dragOffset = ViewPortOverview.this.last.contains(point) ? new Point(((ViewPortOverview)ViewPortOverview.this).last.x - point.x, ((ViewPortOverview)ViewPortOverview.this).last.y - point.y) : new Point(-((ViewPortOverview)ViewPortOverview.this).last.width / 2, -((ViewPortOverview)ViewPortOverview.this).last.height / 2);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragOffset = null;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (this.isResize) {
                ViewPortOverview.this.setSize(new Dimension(point.x, point.y));
                return;
            }
            if (this.dragOffset == null) {
                return;
            }
            Point2D point2D = ViewPortOverview.this.getZoom();
            Rectangle rectangle = ViewPortOverview.this.viewport.getViewRect();
            int n = (int)((double)(point.x + this.dragOffset.x) / point2D.getX());
            int n2 = (int)((double)(point.y + this.dragOffset.y) / point2D.getY());
            ViewPortOverview.this.viewport.scrollRectToVisible(new Rectangle(n - rectangle.x, n2 - rectangle.y, rectangle.width, rectangle.height));
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = 0;
            if (ViewPortOverview.this.last != null && ViewPortOverview.this.last.contains(point)) {
                n = 13;
            }
            if (this.isResize(point)) {
                n = 5;
            }
            ViewPortOverview.this.setCursor(Cursor.getPredefinedCursor(n));
        }

        private boolean isResize(Point point) {
            Dimension dimension = ViewPortOverview.this.getSize();
            return point.x > dimension.width - 6 && point.y > dimension.height - 6;
        }

        public void componentResized(ComponentEvent componentEvent) {
            ViewPortOverview.this.repaint();
        }
    }
}

