/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class GraphicsHelper {
    public static void render(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, double d, double d2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(string, graphics2D);
        float f = 0.0f;
        String[] stringArray = string.split("\\\n");
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(stringArray[i], graphics2D);
            fArray[i] = (float)rectangle2D2.getWidth();
            f = Math.max(f, (float)rectangle2D2.getHeight());
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        for (int i = 0; i < stringArray.length; ++i) {
            double d3 = Math.max(rectangle2D.getX(), rectangle2D.getCenterX() - (double)fArray[i] * d);
            double d4 = Math.max(rectangle2D.getY(), rectangle2D.getY() + (rectangle2D.getHeight() - (double)((float)stringArray.length * f)) * d2 + (double)((float)i * f) + (double)f - (double)lineMetrics.getDescent());
            graphics2D.drawString(stringArray[i], (float)d3, (float)d4);
        }
        graphics2D.setClip(shape);
    }

    public static Rectangle render(Graphics2D graphics2D, String string, double d, double d2, double d3, double d4) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(string, graphics2D);
        float f = (float)rectangle2D.getHeight();
        float f2 = (float)rectangle2D.getWidth();
        graphics2D.drawString(string, (float)(d -= (double)f2 * d3), (float)(d2 -= (double)f * d4) + f - lineMetrics.getDescent());
        return new Rectangle((int)d, (int)d2, (int)f2, (int)f);
    }

    public static Icon getIcon(Shape shape, Color color) {
        Dimension dimension = shape.getBounds().getSize();
        return new ShapeAsIcon(Math.max(dimension.width, dimension.height), shape, color);
    }

    public static Icon getIcon(int n, Shape shape, Color color) {
        return new ShapeAsIcon(n, shape, color);
    }

    public static Icon getIcon(int n, Shape shape) {
        return new ShapeAsIcon(n, shape, null);
    }

    public static Icon getIcon(double ... dArray) {
        return GraphicsHelper.getIcon(null, dArray);
    }

    public static Icon getIcon(Color color, double ... dArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(dArray[0], dArray[1]);
        for (int i = 2; i < dArray.length; i += 2) {
            generalPath.lineTo(dArray[i + 0], dArray[i + 1]);
        }
        generalPath.closePath();
        return new ShapeAsIcon(generalPath, color);
    }

    private static class ShapeAsIcon
    implements Icon {
        private Dimension size;
        private Shape shape;
        private Color color;

        private ShapeAsIcon(Shape shape, Color color) {
            this.color = color;
            this.size = shape.getBounds().getSize();
            this.shape = shape;
        }

        private ShapeAsIcon(int n, Shape shape, Color color) {
            this.color = color;
            this.size = new Dimension(n, n);
            this.shape = shape;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.color != null) {
                graphics.setColor(this.color);
            }
            graphics.translate(n, n2);
            ((Graphics2D)graphics).fill(this.shape);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.size.width;
        }

        public int getIconHeight() {
            return this.size.height;
        }
    }
}

