/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.io.InputSource;
import genj.util.EnvironmentChecker;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.FileChooser;
import genj.util.swing.TextFieldWidget;
import genj.util.swing.ThumbnailWidget;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class FileChooserWidget
extends JPanel {
    private TextFieldWidget text = new TextFieldWidget("", 12);
    private Choose choose = new Choose();
    private String extensions;
    public static final String EXECUTABLES = "exe, bin, sh, cmd, bat";
    private String directory = EnvironmentChecker.getProperty("user.home", ".", "file chooser directory");
    private JComponent accessory;
    private List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();
    private ActionListener actionProxy = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            FileChooserWidget.this.fireActionEvent();
        }
    };

    public FileChooserWidget() {
        this((String)null);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.choose.setEnabled(bl);
        this.text.setEnabled(bl);
    }

    public FileChooserWidget(String string) {
        super(new BorderLayout());
        this.add("Center", this.text);
        this.add("East", new ButtonHelper().setInsets(0).create(this.choose));
        this.extensions = string;
    }

    private void fireActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "");
        ActionListener[] actionListenerArray = this.listeners.toArray(new ActionListener[this.listeners.size()]);
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(actionEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.text.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.text.removeChangeListener(changeListener);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listeners.isEmpty()) {
            this.text.addActionListener(this.actionProxy);
        }
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
        if (this.listeners.isEmpty()) {
            this.text.removeActionListener(this.actionProxy);
        }
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public void setTemplate(boolean bl) {
        this.text.setTemplate(bl);
    }

    public void setFile(String string) {
        this.text.setText(string != null ? string : "");
    }

    public void setFile(File file) {
        this.text.setText(file != null ? file.getPath() : "");
        if (file != null && file.getParentFile().isDirectory()) {
            this.setDirectory(file.getParentFile().toString());
        }
    }

    public File getFile() {
        File file = new File(this.text.getText().trim());
        String string = file.getName();
        if (this.extensions != null && string.indexOf(".") < 0 && this.extensions.indexOf(44) < 0) {
            String string2 = this.extensions.trim();
            if (string.length() > 0 && !string.endsWith("." + string2)) {
                file = new File(file.getParentFile(), string + "." + string2);
            }
        }
        return file;
    }

    public void setAccessory(JComponent jComponent) {
        this.accessory = jComponent;
    }

    public boolean requestFocusInWindow() {
        return this.text.requestFocusInWindow();
    }

    public void requestFocus() {
        this.text.requestFocus();
    }

    private class Choose
    extends Action2
    implements PropertyChangeListener {
        private Choose() {
            this.setText("...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileChooser fileChooser = new FileChooser(FileChooserWidget.this, FileChooserWidget.this.getName(), Action2.TXT_OK, FileChooserWidget.this.extensions, FileChooserWidget.this.directory);
            fileChooser.setAccessory(FileChooserWidget.this.accessory);
            fileChooser.addPropertyChangeListener(this);
            File file = FileChooserWidget.this.getFile();
            if (file.isFile()) {
                fileChooser.setSelectedFile(file);
            }
            fileChooser.showDialog();
            file = fileChooser.getSelectedFile();
            if (file != null) {
                if (FileChooserWidget.this.extensions != null && FileChooserWidget.this.extensions.indexOf(44) < 0) {
                    String string = FileChooserWidget.this.extensions.trim();
                    if (!file.getName().endsWith("." + string)) {
                        file = new File(file.getParentFile(), file.getName() + "." + string);
                    }
                }
                FileChooserWidget.this.setFile(file);
                FileChooserWidget.this.directory = file.getParent();
                FileChooserWidget.this.fireActionEvent();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                File file = (File)propertyChangeEvent.getNewValue();
                if (FileChooserWidget.this.accessory instanceof ThumbnailWidget) {
                    ((ThumbnailWidget)FileChooserWidget.this.accessory).setSource(file != null ? InputSource.get(file) : null);
                }
            }
        }
    }
}

