/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

public class MnemonicAndText {
    private char mnemonic = '\u0000';
    private String text;

    public MnemonicAndText(String string) {
        this.text = string != null ? string : "";
        int n = this.text.indexOf(126);
        if (n < 0) {
            this.mnemonic = this.text.length() > 0 ? this.text.charAt(0) : (char)'\u0000';
        } else if (n == this.text.length() - 1) {
            this.mnemonic = this.text.length() > 0 ? this.text.charAt(0) : (char)'\u0000';
            this.text = this.text.substring(0, this.text.length() - 1);
        } else {
            this.mnemonic = this.text.charAt(n + 1);
            this.text = this.text.substring(0, n) + this.text.substring(n + 1);
        }
        this.mnemonic = Character.toUpperCase(this.mnemonic);
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public String getText(String string) {
        if (this.mnemonic == '\u0000') {
            return this.getText();
        }
        return this.text + " [" + string + this.mnemonic + "]";
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.mnemonic == '\u0000' ? this.text : this.text + "[" + this.mnemonic + "]";
    }
}

