/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class LiturgicalYear {
    private static final Resources RES = Resources.get(LiturgicalYear.class);
    public static final ImageIcon IMAGE = new ImageIcon(LiturgicalYear.class, "LiturgicalYear.png");
    public static final String TXT_LITURGICAL_YEAR = RES.getString("liturgicalyear");
    public static final String TXT_SUNDAY = RES.getString("liturgicalyear.sunday");

    public static void main(String[] stringArray) {
        int n = 2009;
        for (Sunday sunday : Sunday.values()) {
            int n2 = sunday.getWeeks() > 0 ? 1 : 0;
            do {
                Calendar calendar = sunday.getDate(n, n2);
                if (n2 > 0) {
                    System.out.format("Julian Day for %d %s: %tD\n", n2, sunday.getName(), calendar);
                    continue;
                }
                System.out.format("Julian Day for %s: %tD\n", sunday.getName(), calendar);
            } while (++n2 <= sunday.getWeeks());
        }
        for (int i = 1982; i <= 2022; ++i) {
            Calendar calendar = Sunday.getEaster(i);
            System.out.format("Easter Sunday in %d: %tD\n", i, calendar);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sunday {
        PostEpiphanias(Integer.MAX_VALUE, 5, new String[]{"post Ephiphanias"}){

            protected Calendar getDateImpl(int n, int n2) {
                int n3 = (n - 1) / 100;
                int n4 = 2 - (3 * n3 + 3) / 4;
                int n5 = 7 - (n - 1 + (n - 1) / 4 + n4) % 7;
                int n6 = 7 + (7 - (313 - n5) % 7) % 7 + (n2 - 1) * 7;
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, n);
                calendar.set(6, n6);
                return calendar;
            }
        }
        ,
        Septuagesimae(-9, "Septuagesimae", "Circumdederunt"),
        Sexagesimae(-8, "Sexagesimae", "Exsurge"),
        Quinquagesimae(-7, "Qinquagesimae", "Estomihi"),
        Quadragesimae(-6, "Quadragesimae", "Invocavit"),
        Reminiscere(-5, "Reminiscere"),
        Oculi(-4, "Oculi"),
        Letare(-3, "Letare", "Laetare"),
        Judica(-2, "Judica"),
        Palmarum(-1, "Palmarum"),
        Paschale(0, "Paschale"),
        Quasimodogeniti(1, "Quasimodogeniti"),
        MisericordiasDomini(2, "Misericordias Domini"),
        Jubilate(3, "Jubilate"),
        Cantate(4, "Cantate"),
        Rogate(5, "Rogate"),
        Exaudi(6, "Exaudi"),
        Pentecost(7, "Pentecost"),
        Trinitatis(8, "Trinitatis"),
        PostTrinitatis(8, 27, "post Trinitatis"),
        Adventis(Integer.MAX_VALUE, 4, new String[]{"Adventis"}){

            protected Calendar getDateImpl(int n, int n2) {
                int n3 = n / 100;
                int n4 = 2 - (3 * n3 + 3) / 4;
                int n5 = 7 - (n + n / 4 + n4) % 7;
                int n6 = 27 + (7 - (272 - n5) % 7) % 7 + (n2 - 1) * 7;
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, n);
                if (n6 > 30) {
                    calendar.set(2, 11);
                    calendar.set(5, n6 - 30);
                } else {
                    calendar.set(2, 10);
                    calendar.set(5, n6);
                }
                return calendar;
            }
        };

        private int easterOffset;
        private int weeks;
        private List<String> names;

        private Sunday(int n2, String ... stringArray) {
            this.easterOffset = n2;
            this.weeks = 0;
            this.names = Collections.unmodifiableList(Arrays.asList(stringArray));
        }

        private Sunday(int n2, int n3, String ... stringArray) {
            this.easterOffset = n2;
            this.weeks = n3;
            this.names = Collections.unmodifiableList(Arrays.asList(stringArray));
        }

        public int getWeeks() {
            return this.weeks;
        }

        public String getName() {
            return this.names.get(0);
        }

        public List<String> getNames() {
            return this.names;
        }

        public Calendar getDate(int n, int n2) {
            if (this.weeks > 0 && n2 <= 0) {
                throw new IllegalArgumentException("bad relative week " + n2);
            }
            if (n2 > this.weeks) {
                throw new IllegalArgumentException("bad relative week " + n2);
            }
            return this.getDateImpl(n, n2);
        }

        protected Calendar getDateImpl(int n, int n2) {
            Calendar calendar = Sunday.getEaster(n);
            calendar.add(6, (this.easterOffset + n2) * 7);
            return calendar;
        }

        public static Calendar getEaster(int n) {
            int n2 = n / 100;
            int n3 = 15 + (3 * n2 + 3) / 4 - (8 * n2 + 13) / 25;
            int n4 = 2 - (3 * n2 + 3) / 4;
            int n5 = n % 19;
            int n6 = (19 * n5 + n3) % 30;
            int n7 = n6 / 29 + (n6 / 28 - n6 / 29) * (n5 / 11);
            int n8 = 21 + n6 - n7;
            int n9 = 7 - (n + n / 4 + n4) % 7;
            int n10 = 7 - (n8 - n9) % 7;
            int n11 = n8 + n10;
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, n);
            if (n11 > 31) {
                calendar.set(2, 3);
                calendar.set(5, n11 - 31);
            } else {
                calendar.set(2, 2);
                calendar.set(5, n11);
            }
            return calendar;
        }
    }
}

