/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.print.PrintRenderer;
import genj.renderer.BlueprintRenderer;
import genj.renderer.DPI;
import genj.tree.ContentRenderer;
import genj.tree.TreeView;
import genj.util.swing.UnitGraphics;
import gj.awt.geom.Dimension2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class TreeViewPrinter
implements PrintRenderer {
    private TreeView view;

    public TreeViewPrinter(TreeView treeView) {
        this.view = treeView;
    }

    public Dimension2D getSize() {
        Rectangle rectangle = this.view.getModel().getBounds();
        return new Dimension2D.Double((double)((float)rectangle.width * 0.1f / 2.54f), (double)((float)rectangle.height * 0.1f / 2.54f));
    }

    public void render(Graphics2D graphics2D) {
        DPI dPI = DPI.get(graphics2D);
        UnitGraphics unitGraphics = new UnitGraphics(graphics2D, (double)dPI.horizontal() / 2.54 * 0.1, (double)dPI.vertical() / 2.54 * 0.1);
        ContentRenderer contentRenderer = new ContentRenderer();
        contentRenderer.font = this.view.getContentFont();
        contentRenderer.cArcs = Color.black;
        contentRenderer.cFamShape = Color.black;
        contentRenderer.cIndiShape = Color.black;
        contentRenderer.indiRenderer = new BlueprintRenderer(this.view.getBlueprint("INDI"));
        contentRenderer.famRenderer = new BlueprintRenderer(this.view.getBlueprint("FAM"));
        contentRenderer.render(unitGraphics, this.view.getModel());
    }
}

