/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GridCache {
    private static final List EMPTY = new ArrayList(0);
    private Object[][] grid;
    private Rectangle2D system;
    private double resolution;

    public GridCache(Rectangle2D rectangle2D, double d) {
        this.system = rectangle2D;
        this.resolution = d;
        int n = (int)Math.ceil(this.system.getWidth() / this.resolution);
        int n2 = (int)Math.ceil(this.system.getHeight() / this.resolution);
        this.grid = new Object[n2][n];
    }

    public void put(Object object, Rectangle2D rectangle2D, Point2D point2D) {
        int n = (int)Math.floor((rectangle2D.getMinX() + point2D.getX() - this.system.getMinX()) / this.resolution);
        int n2 = (int)Math.floor((rectangle2D.getMinY() + point2D.getY() - this.system.getMinY()) / this.resolution);
        int n3 = (int)Math.ceil((rectangle2D.getMaxX() + point2D.getX() - this.system.getMinX()) / this.resolution);
        int n4 = (int)Math.ceil((rectangle2D.getMaxY() + point2D.getY() - this.system.getMinY()) / this.resolution);
        if (n > this.grid[0].length || n2 > this.grid.length || n3 < 0 || n4 < 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 > this.grid.length) {
            n4 = this.grid.length;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 > this.grid[0].length) {
            n3 = this.grid[0].length;
        }
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                this.put(object, i, j);
            }
        }
    }

    public void put(Object object, int n, int n2) {
        Object object2 = this.grid[n][n2];
        if (object2 == null) {
            this.grid[n][n2] = object;
        } else if (object2 instanceof EntryList) {
            ((EntryList)object2).add(object);
        } else {
            EntryList entryList = new EntryList();
            entryList.add(object2);
            entryList.add(object);
            this.grid[n][n2] = entryList;
        }
    }

    public Set get(Rectangle2D rectangle2D) {
        HashSet hashSet = new HashSet();
        int n = (int)Math.floor((rectangle2D.getMinX() - this.system.getMinX()) / this.resolution);
        int n2 = (int)Math.floor((rectangle2D.getMinY() - this.system.getMinY()) / this.resolution);
        int n3 = (int)Math.ceil((rectangle2D.getMaxX() - this.system.getMinX()) / this.resolution);
        int n4 = (int)Math.ceil((rectangle2D.getMaxY() - this.system.getMinY()) / this.resolution);
        if (n > this.grid[0].length || n2 > this.grid.length || n3 < 0 || n4 < 0) {
            return hashSet;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 > this.grid.length) {
            n4 = this.grid.length;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 > this.grid[0].length) {
            n3 = this.grid[0].length;
        }
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                this.get(hashSet, i, j);
            }
        }
        return hashSet;
    }

    public void get(Set set, int n, int n2) {
        Object object = this.grid[n][n2];
        if (object == null) {
            return;
        }
        if (object instanceof EntryList) {
            set.addAll((EntryList)object);
        } else {
            set.add(object);
        }
    }

    private class EntryList
    extends ArrayList {
        private EntryList() {
            super(8);
        }
    }
}

