/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.renderer.BlueprintRenderer;
import genj.renderer.EmptyHintKey;
import genj.renderer.RenderPreviewHintKey;
import genj.tree.Model;
import genj.tree.TreeArc;
import genj.util.swing.UnitGraphics;
import gj.model.Node;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;

public class ContentRenderer {
    Font font = null;
    Color cIndiShape = null;
    Color cFamShape = null;
    Color cArcs = null;
    Color cSelectedShape = null;
    Collection<? extends Entity> selected = new ArrayList<Entity>(0);
    BlueprintRenderer indiRenderer;
    BlueprintRenderer famRenderer;

    public void render(UnitGraphics unitGraphics, Model model) {
        Rectangle rectangle = model.getBounds();
        unitGraphics.translate(-rectangle.getX(), -rectangle.getY());
        this.renderArcs(unitGraphics, model);
        this.renderNodes(unitGraphics, model);
    }

    private void renderNodes(UnitGraphics unitGraphics, Model model) {
        Rectangle rectangle = unitGraphics.getClip().getBounds();
        int n = 0;
        for (Node node : model.getNodesIn(rectangle)) {
            Shape shape = node.getShape();
            Point2D point2D = node.getPosition();
            if (shape == null) continue;
            Rectangle rectangle2 = shape.getBounds();
            if (!rectangle.intersects(point2D.getX() + rectangle2.getMinX(), point2D.getY() + rectangle2.getMinY(), rectangle2.getWidth(), rectangle2.getHeight())) continue;
            ++n;
            this.renderNode(unitGraphics, point2D, shape, node.getContent());
        }
        if (n > 0) {
            unitGraphics.getGraphics().setRenderingHint(EmptyHintKey.KEY, false);
        }
    }

    private void renderNode(UnitGraphics unitGraphics, Point2D point2D, Shape shape, Object object) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        unitGraphics.setColor(this.getColor(object));
        unitGraphics.draw(shape, d, d2);
        if (!Boolean.TRUE.equals(unitGraphics.getGraphics().getRenderingHint(RenderPreviewHintKey.KEY))) {
            this.renderContent(unitGraphics, d, d2, shape, object);
        }
    }

    private Color getColor(Object object) {
        if (this.cSelectedShape != null && this.selected.contains(object)) {
            return this.cSelectedShape;
        }
        if (object instanceof Fam) {
            return this.cFamShape;
        }
        return this.cIndiShape;
    }

    private void renderContent(UnitGraphics unitGraphics, double d, double d2, Shape shape, Object object) {
        BlueprintRenderer blueprintRenderer = null;
        if (object instanceof Indi) {
            blueprintRenderer = this.indiRenderer;
        }
        if (object instanceof Fam) {
            blueprintRenderer = this.famRenderer;
        }
        if (blueprintRenderer == null) {
            return;
        }
        Rectangle rectangle = shape.getBounds();
        unitGraphics.pushClip(d, d2, rectangle);
        unitGraphics.pushTransformation();
        unitGraphics.translate(d, d2);
        Rectangle rectangle2 = unitGraphics.getRectangle(rectangle);
        rectangle2.x += 2;
        rectangle2.y += 2;
        rectangle2.width -= 4;
        rectangle2.height -= 4;
        unitGraphics.setColor(Color.black);
        unitGraphics.setFont(this.font);
        blueprintRenderer.render(unitGraphics.getGraphics(), (Entity)object, rectangle2);
        unitGraphics.popTransformation();
        unitGraphics.popClip();
    }

    private void renderArcs(UnitGraphics unitGraphics, Model model) {
        Rectangle rectangle = unitGraphics.getClip().getBounds();
        unitGraphics.setColor(this.cArcs);
        Collection<TreeArc> collection = model.getArcsIn(rectangle);
        for (TreeArc treeArc : collection) {
            unitGraphics.draw((Shape)treeArc.getPath(), 0.0, 0.0);
        }
        if (!collection.isEmpty()) {
            unitGraphics.getGraphics().setRenderingHint(EmptyHintKey.KEY, false);
        }
    }
}

