/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyName;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.PointInTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Model
implements GedcomListener {
    private Gedcom gedcom;
    double max = Double.NaN;
    double min = Double.NaN;
    private Set<TagPath> paths = new HashSet<TagPath>();
    private Set<String> tags = new HashSet<String>();
    private static final String[] DEFAULT_PATHS = new String[]{"INDI:BIRT", "FAM:MARR", "INDI:EMIG"};
    List<List<Event>> layers;
    double timeBeforeEvent = 0.5;
    double timeAfterEvent = 2.0;
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    Model() {
        this.setPaths(Arrays.asList(TagPath.toArray(DEFAULT_PATHS)));
    }

    Gedcom getGedcom() {
        return this.gedcom;
    }

    void setGedcom(Gedcom gedcom) {
        if (this.gedcom == gedcom) {
            return;
        }
        if (this.gedcom != null) {
            this.gedcom.removeGedcomListener(this);
        }
        this.gedcom = gedcom;
        if (this.gedcom != null) {
            this.gedcom.addGedcomListener(this);
        }
        this.createEvents();
    }

    void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    void setTimePerEvent(double d, double d2) {
        if (this.timeBeforeEvent == d && this.timeAfterEvent == d2) {
            return;
        }
        this.timeBeforeEvent = d;
        this.timeAfterEvent = d2;
        if (this.layers != null) {
            this.layoutEvents();
        }
    }

    static double toDouble(PointInTime pointInTime, boolean bl) throws GedcomException {
        GregorianCalendar gregorianCalendar = PointInTime.GREGORIAN;
        if (pointInTime.getCalendar() != gregorianCalendar) {
            pointInTime = pointInTime.getPointInTime(gregorianCalendar);
        }
        int n = pointInTime.getYear();
        double d = n;
        int n2 = pointInTime.getMonth();
        if (n2 == Integer.MAX_VALUE) {
            return bl ? d + 1.0 : d;
        }
        double d2 = gregorianCalendar.getMonths();
        d += (double)n2 / d2;
        int n3 = pointInTime.getDay();
        if (n3 == Integer.MAX_VALUE) {
            return bl ? d + 1.0 / d2 : d;
        }
        double d3 = ((Calendar)gregorianCalendar).getDays(n2, n);
        return d += (double)n3 / d2 / d3;
    }

    static PointInTime toPointInTime(double d) {
        GregorianCalendar gregorianCalendar = PointInTime.GREGORIAN;
        int n = gregorianCalendar.getMonths();
        int n2 = (int)Math.floor(d);
        if ((d %= 1.0) < 0.0) {
            d = 1.0 + d;
        }
        int n3 = (int)Math.floor(d * (double)n);
        int n4 = ((Calendar)gregorianCalendar).getDays(n3, n2);
        int n5 = (int)Math.floor(d * (double)n % 1.0 * (double)n4);
        return new PointInTime(n5, n3, n2);
    }

    protected Event getEvent(double d, int n) {
        for (Event event : this.layers.get(n)) {
            if (!(event.from - this.timeBeforeEvent < d) || !(d < event.to + this.timeAfterEvent)) continue;
            return event;
        }
        return null;
    }

    protected Set<Event> getEvents(Context context) {
        HashSet<Event> hashSet = new HashSet<Event>();
        HashSet<Event> hashSet2 = new HashSet<Event>();
        List<? extends Property> list = context.getProperties();
        List<? extends Entity> list2 = context.getEntities();
        for (int i = 0; i < this.layers.size(); ++i) {
            for (Event event : this.layers.get(i)) {
                int n;
                for (n = 0; n < list2.size(); ++n) {
                    if (list2.get(n) != event.getEntity()) continue;
                    hashSet2.add(event);
                }
                for (n = 0; n < list.size(); ++n) {
                    if (event.getProperty() != list.get(n) && !event.getProperty().contains(list.get(n))) continue;
                    hashSet.add(event);
                }
            }
        }
        return hashSet.isEmpty() ? hashSet2 : hashSet;
    }

    public Set<TagPath> getPaths() {
        return Collections.unmodifiableSet(this.paths);
    }

    public void setPaths(Collection<TagPath> collection) {
        this.paths.clear();
        this.tags.clear();
        for (TagPath tagPath : collection) {
            this.paths.add(tagPath);
            this.tags.add(tagPath.getLast());
        }
        this.createEvents();
    }

    private void fireStructureChanged() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).structureChanged();
        }
    }

    private void fireDataChanged() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).dataChanged();
        }
    }

    private final void contentEvents(Entity entity) {
        for (int i = 0; i < this.layers.size(); ++i) {
            List<Event> list = this.layers.get(i);
            for (Event event : list) {
                if (event.pe.getEntity() != entity) continue;
                event.content();
            }
        }
    }

    private final void layoutEvents() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        List<List<Event>> list = this.layers;
        this.layers = new ArrayList<List<Event>>(10);
        for (int i = 0; i < list.size(); ++i) {
            List<Event> list2 = list.get(i);
            for (Event event : list2) {
                this.insertEvent(event);
            }
        }
        this.max += this.timeAfterEvent;
        this.min -= this.timeBeforeEvent;
        this.fireStructureChanged();
    }

    private final void createEvents() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.layers = new ArrayList<List<Event>>(10);
        if (this.gedcom != null) {
            this.createEventsFrom(this.gedcom.getEntities("INDI").iterator());
            this.createEventsFrom(this.gedcom.getEntities("FAM").iterator());
        }
        this.max += this.timeAfterEvent;
        this.min -= this.timeBeforeEvent;
        this.fireStructureChanged();
    }

    private final void createEventsFrom(Iterator iterator) {
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            List<PropertyEvent> list = entity.getProperties(PropertyEvent.class);
            for (int i = 0; i < list.size(); ++i) {
                PropertyEvent propertyEvent = list.get(i);
                if (!this.tags.contains(propertyEvent.getTag())) continue;
                this.createEventFrom(propertyEvent);
            }
        }
    }

    private final void createEventFrom(PropertyEvent propertyEvent) {
        PropertyDate propertyDate = propertyEvent.getDate();
        if (propertyDate == null || !propertyDate.isValid() || !propertyDate.isComparable()) {
            return;
        }
        try {
            this.insertEvent(new Event(propertyEvent, propertyDate));
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
    }

    private final void insertEvent(Event event) {
        this.min = Math.min(Math.floor(event.from), this.min);
        this.max = Math.max(Math.ceil(event.to), this.max);
        for (int i = 0; i < this.layers.size(); ++i) {
            List<Event> list = this.layers.get(i);
            if (!this.insertEvent(event, list)) continue;
            return;
        }
        LinkedList<Event> linkedList = new LinkedList<Event>();
        this.layers.add(linkedList);
        linkedList.add(event);
    }

    private final boolean insertEvent(Event event, List list) {
        ListIterator<Event> listIterator = list.listIterator();
        do {
            Event event2 = (Event)listIterator.next();
            if (event.to + this.timeAfterEvent < event2.from - this.timeBeforeEvent) {
                listIterator.previous();
                listIterator.add(event);
                return true;
            }
            if (!(event.from - this.timeBeforeEvent < event2.to + this.timeAfterEvent)) continue;
            return false;
        } while (listIterator.hasNext());
        listIterator.add(event);
        return true;
    }

    @Override
    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        this.createEvents();
    }

    @Override
    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        this.createEvents();
    }

    @Override
    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
        this.gedcomPropertyDeleted(gedcom, property2, -1, property2);
    }

    @Override
    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        this.gedcomPropertyDeleted(gedcom, property, -1, property);
    }

    @Override
    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
        if (property2 instanceof PropertyDate) {
            this.createEvents();
        } else if (property2 instanceof PropertyName) {
            this.contentEvents(property.getEntity());
            this.fireDataChanged();
        }
    }

    static interface Listener {
        public void dataChanged();

        public void structureChanged();
    }

    class Event {
        double from;
        double to;
        PropertyEvent pe;
        PropertyDate pd;
        String content;

        Event(PropertyEvent propertyEvent, PropertyDate propertyDate) throws GedcomException {
            this.pe = propertyEvent;
            this.pd = propertyDate;
            this.from = Model.toDouble(propertyDate.getStart(), propertyDate.getFormat() == PropertyDate.AFTER);
            double d = this.to = propertyDate.isRange() ? Model.toDouble(propertyDate.getEnd(), false) : this.from;
            if (this.from > this.to) {
                throw new GedcomException("");
            }
            this.content();
        }

        private final void content() {
            Entity entity = this.pe.getEntity();
            this.content = entity.toString();
        }

        public String toString() {
            return this.content;
        }

        Entity getEntity() {
            return this.pe.getEntity();
        }

        PropertyEvent getProperty() {
            return this.pe;
        }
    }
}

