/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.report.Report;
import genj.report.ReportView;
import genj.util.EnvironmentChecker;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ReportLoader {
    private List<Report> instances = new ArrayList<Report>(10);
    private Map<File, String> file2reportclass = new HashMap<File, String>(10);
    private List<URL> classpath = new ArrayList<URL>(10);
    private boolean isReportsInClasspath = false;
    private static volatile ReportLoader singleton;

    static void clear() {
        singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportLoader getInstance() {
        if (singleton != null) return singleton;
        Class<ReportLoader> clazz = ReportLoader.class;
        synchronized (ReportLoader.class) {
            if (singleton != null) return singleton;
            singleton = new ReportLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public Report getReportByName(String string) {
        for (Report report : this.instances) {
            if (!report.getClass().getName().equals(string)) continue;
            return report;
        }
        return null;
    }

    public static File getReportDirectory() {
        return new File(EnvironmentChecker.getProperty(new String[]{"genj.report.dir", "user.dir/report"}, "report", "find report class-files"));
    }

    private ReportLoader() {
        File file = ReportLoader.getReportDirectory();
        ReportView.LOG.info("Reading reports from " + file);
        try {
            this.classpath.add(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.parseDir(file, null);
        URLClassLoader uRLClassLoader = new URLClassLoader(this.classpath.toArray(new URL[this.classpath.size()]), this.getClass().getClassLoader());
        for (File file2 : this.file2reportclass.keySet()) {
            String string = this.file2reportclass.get(file2);
            try {
                Report report = (Report)uRLClassLoader.loadClass(string).newInstance();
                report.putFile(file2);
                if (!this.isReportsInClasspath && report.getClass().getClassLoader() != uRLClassLoader) {
                    ReportView.LOG.warning("Reports are in classpath and can't be reloaded");
                    this.isReportsInClasspath = true;
                }
                this.instances.add(report);
            }
            catch (Throwable throwable) {
                ReportView.LOG.log(Level.WARNING, "Failed to instantiate " + string, throwable);
            }
        }
        Collections.sort(this.instances, new Comparator<Report>(){

            @Override
            public int compare(Report report, Report report2) {
                try {
                    return report.getName().compareTo(report2.getName());
                }
                catch (Throwable throwable) {
                    return 0;
                }
            }
        });
    }

    private void parseDir(File file, String string) {
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.parseDir(file2, (string == null ? "" : string + ".") + file2.getName());
                continue;
            }
            String string2 = this.isReport(file2, string);
            if (string2 != null) {
                this.file2reportclass.put(file2, string2);
                continue;
            }
            if (!this.isLibrary(file2)) continue;
            try {
                ReportView.LOG.info("report library " + file2.toURI().toURL());
                this.classpath.add(file2.toURI().toURL());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private boolean isLibrary(File file) {
        return !file.isDirectory() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"));
    }

    private String isReport(File file, String string) {
        if (string != null && string.startsWith("genj") || file.isDirectory() || !file.getName().endsWith(".class") || !file.getName().startsWith("Report") || file.getName().indexOf("$") > 0) {
            return null;
        }
        String string2 = file.getName();
        return (string == null ? "" : string + ".") + string2.substring(0, string2.length() - ".class".length());
    }

    public Report[] getReports() {
        return this.instances.toArray(new Report[this.instances.size()]);
    }

    void saveOptions() {
        Report[] reportArray = this.getReports();
        for (int i = 0; i < reportArray.length; ++i) {
            reportArray[i].saveOptions();
        }
    }

    boolean isReportsInClasspath() {
        return this.isReportsInClasspath;
    }
}

