/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.io.InputSource;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class MediaRenderer {
    private static final Logger LOG = Logger.getLogger("genj.renderer");
    private static final Map<Property, CacheEntry> CACHE = new WeakHashMap<Property, CacheEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getSize(Property property, Graphics graphics) {
        CacheEntry cacheEntry;
        block16: {
            InputSource inputSource = MediaRenderer.getSource(property);
            if (inputSource == null) {
                return new Dimension();
            }
            cacheEntry = CACHE.get(property);
            if (cacheEntry != null && cacheEntry.source.equals(inputSource)) {
                return cacheEntry.size;
            }
            cacheEntry = new CacheEntry();
            cacheEntry.source = inputSource;
            cacheEntry.size = new Dimension();
            CACHE.put(property, cacheEntry);
            InputStream inputStream = null;
            try {
                inputStream = inputSource.open();
                if (inputStream == null) break block16;
                LOG.finer("Reading size from " + inputSource);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                if (!iterator.hasNext()) break block16;
                ImageReader imageReader = iterator.next();
                try {
                    imageReader.setInput(imageInputStream, false, false);
                    cacheEntry.size.setSize(imageReader.getWidth(0), imageReader.getHeight(0));
                }
                finally {
                    imageReader.dispose();
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.FINER, "Can't get image dimension for " + property + "/" + inputSource, iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return cacheEntry.size;
    }

    public static InputSource getSource(Property property) {
        if (property instanceof PropertyFile) {
            File file = ((PropertyFile)property).getFile();
            if (file != null && file.exists()) {
                return InputSource.get(file);
            }
            return null;
        }
        if (property instanceof PropertyBlob) {
            return InputSource.get(property.toString(), ((PropertyBlob)property).getBlobData());
        }
        for (int i = 0; i < property.getNoOfProperties(); ++i) {
            Property property2;
            Property property3;
            Property property4 = property.getProperty(i);
            if (property4 instanceof PropertyXRef && (property3 = ((PropertyXRef)property4).getTargetEntity()) instanceof Media) {
                property2 = (Media)property3;
                PropertyBlob propertyBlob = ((Media)property2).getBlob();
                if (propertyBlob != null) {
                    return InputSource.get(property.toString(), propertyBlob.getBlobData());
                }
                File file = ((Media)property2).getFile();
                if (file != null) {
                    return InputSource.get(file);
                }
            }
            if (!"OBJE".equals(property4.getTag()) || !((property3 = property4.getProperty("FILE")) instanceof PropertyFile) || (property2 = (PropertyFile)property3) == null || ((PropertyFile)property2).getFile() == null || !((PropertyFile)property2).getFile().exists()) continue;
            return InputSource.get(((PropertyFile)property2).getFile());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(Graphics graphics, Rectangle rectangle, Property property) {
        Image image;
        block30: {
            image = null;
            InputSource inputSource = MediaRenderer.getSource(property);
            if (inputSource == null) {
                return;
            }
            CacheEntry cacheEntry = CACHE.get(property);
            if (cacheEntry != null) {
                if (cacheEntry.source.equals(inputSource)) {
                    if (cacheEntry.size.width == 0 || cacheEntry.size.height == 0) {
                        return;
                    }
                    image = cacheEntry.image.get();
                    if (image != null && (cacheEntry.size.width >= rectangle.width && image.getWidth(null) < rectangle.width || cacheEntry.size.height >= rectangle.height && image.getHeight(null) < rectangle.height)) {
                        image = null;
                    }
                }
            } else {
                cacheEntry = new CacheEntry();
                cacheEntry.source = inputSource;
            }
            if (image == null) {
                InputStream inputStream = null;
                ImageInputStream imageInputStream = null;
                try {
                    inputStream = inputSource.open();
                    if (inputStream == null) break block30;
                    LOG.finer("Reading image from " + inputSource + " for " + rectangle.getSize());
                    imageInputStream = ImageIO.createImageInputStream(inputStream);
                    Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                    if (!iterator.hasNext()) break block30;
                    ImageReader imageReader = iterator.next();
                    try {
                        imageReader.setInput(imageInputStream, false, false);
                        cacheEntry.size.setSize(imageReader.getWidth(0), imageReader.getHeight(0));
                        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                        imageReadParam.setSourceSubsampling(Math.max(1, (int)Math.floor(cacheEntry.size.width / rectangle.width)), Math.max(1, (int)Math.floor(cacheEntry.size.height / rectangle.height)), 0, 0);
                        image = imageReader.read(0, imageReadParam);
                        cacheEntry.image = new SoftReference<Image>(image);
                    }
                    finally {
                        imageReader.dispose();
                    }
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINER, "Can't get image for " + property + "/" + inputSource, iOException);
                    cacheEntry.size.setSize(0, 0);
                }
                finally {
                    if (imageInputStream != null) {
                        try {
                            imageInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (image != null) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0, 0, image.getWidth(null), image.getHeight(null), null);
        }
    }

    private static class CacheEntry {
        InputSource source;
        Dimension size;
        SoftReference<Image> image = new SoftReference<Object>(null);

        private CacheEntry() {
        }
    }
}

