/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Gedcom;
import genj.renderer.Blueprint;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintManager {
    private static final String SUFFIX = ".html";
    private static final Registry REGISTRY = Registry.get(BlueprintManager.class);
    private static final Resources RESOURCES = Resources.get(BlueprintManager.class);
    public static final String TXT_BLUEPRINT = RESOURCES.getString("blueprint");
    private static final String[][] DEFAULTS = new String[][]{{"INDI", "default", "complete", "verbose", "colorful", "professional", "simple", "pastel", "light", "small"}, {"FAM", "default", "complete", "simple", "pastel", "light", "small"}, {"OBJE", "default", "complete", "55"}, {"NOTE", "default", "complete"}, {"SOUR", "default", "complete"}, {"SUBM", "default", "complete"}, {"REPO", "default", "complete"}};
    static final Logger LOG = Logger.getLogger("genj.renderer");
    private Map<String, List<Blueprint>> tag2blueprints = new HashMap<String, List<Blueprint>>();
    private static BlueprintManager instance;

    public static BlueprintManager getInstance() {
        if (instance == null) {
            instance = new BlueprintManager();
        }
        return instance;
    }

    private BlueprintManager() {
        for (int i = 0; i < DEFAULTS.length; ++i) {
            String[] stringArray = DEFAULTS[i];
            String string = stringArray[0];
            for (int j = 1; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                String string3 = RESOURCES.getString("blueprints." + string2, false);
                if (string3 == null) {
                    string3 = string2;
                }
                try {
                    this.addBlueprint(this.loadBlueprint(this.getClass().getResourceAsStream("blueprints/" + string + "/" + string2 + SUFFIX), string, string3, true));
                    continue;
                }
                catch (Throwable throwable) {
                    LOG.warning("can't read pre-defined blueprint " + string + "/" + string2);
                }
            }
        }
        this.loadBlueprints();
    }

    private File getBlueprintDirectory() {
        return new File(EnvironmentChecker.getProperty("user.home.genj/blueprints", "?", "Looking for blueprints"));
    }

    private File getBlueprintFile(Blueprint blueprint) throws IOException {
        if (blueprint.getName().indexOf(34) >= 0) {
            throw new IOException("Quotes are not allowed in blueprint names");
        }
        return new File(this.getBlueprintDirectory(), "/" + blueprint.getTag() + "/" + blueprint.getName() + SUFFIX).getCanonicalFile();
    }

    void saveBlueprint(Blueprint blueprint) throws IOException {
        if (!blueprint.isDirty()) {
            return;
        }
        File file = this.getBlueprintFile(blueprint);
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs() || !file2.isDirectory()) {
            throw new IOException("Cannot create folder for blueprint " + blueprint.getName());
        }
        this.readwrite(new StringReader(blueprint.getHTML()), new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        blueprint.clearDirty();
        LOG.log(Level.INFO, "saved blueprint " + file);
    }

    private void loadBlueprints() {
        File file = this.getBlueprintDirectory();
        try {
            if (!file.isDirectory() || !file.exists()) {
                return;
            }
            for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
                this.loadBlueprints(file, Gedcom.ENTITIES[i]);
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "unexpected throwable loading blueprints from " + file, throwable);
        }
    }

    private void loadBlueprints(File file, String string) throws IOException {
        if (!(file = new File(file, string)).isDirectory() || !file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            String string2 = file2.getName();
            if (!string2.endsWith(SUFFIX) || file2.isDirectory()) continue;
            string2 = string2.substring(0, string2.length() - SUFFIX.length());
            Blueprint blueprint = this.loadBlueprint(new FileInputStream(file2), string, string2, false);
            blueprint.clearDirty();
            this.addBlueprint(blueprint);
        }
    }

    private Blueprint loadBlueprint(InputStream inputStream, String string, String string2, boolean bl) throws IOException {
        StringWriter stringWriter = new StringWriter(512);
        this.readwrite(new InputStreamReader(inputStream, "UTF8"), stringWriter);
        inputStream.close();
        return new Blueprint(string, string2, stringWriter.toString(), bl);
    }

    private void readwrite(Reader reader, Writer writer) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        while ((string = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
    }

    public Blueprint getBlueprint(String string, String string2) {
        if (string2.length() == 0) {
            string2 = "Default";
        }
        List<Blueprint> list = this.getBlueprints(string);
        for (int i = 0; i < list.size(); ++i) {
            Blueprint blueprint = list.get(i);
            if (!blueprint.getName().equals(string2)) continue;
            return blueprint;
        }
        return list.get(0);
    }

    public List<Blueprint> getBlueprints(String string) {
        return Collections.unmodifiableList(this.getBlueprintsInternal(string));
    }

    private List<Blueprint> getBlueprintsInternal(String string) {
        List<Blueprint> list = this.tag2blueprints.get(string);
        if (list == null) {
            list = new ArrayList<Blueprint>();
            this.tag2blueprints.put(string, list);
        }
        return list;
    }

    public Blueprint addBlueprint(Blueprint blueprint) throws IOException {
        if (!blueprint.isReadOnly()) {
            this.getBlueprintFile(blueprint);
        }
        List<Blueprint> list = this.getBlueprintsInternal(blueprint.getTag());
        ListIterator<Blueprint> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Blueprint blueprint2 = listIterator.next();
            if (!blueprint2.getName().equalsIgnoreCase(blueprint.getName())) continue;
            if (blueprint2.isReadOnly()) {
                throw new IOException("Can't overwrite read-only blueprint");
            }
            listIterator.remove();
            break;
        }
        if (!blueprint.isReadOnly()) {
            this.saveBlueprint(blueprint);
        }
        list.add(blueprint);
        return blueprint;
    }

    public void delBlueprint(Blueprint blueprint) throws IOException {
        if (blueprint.isReadOnly()) {
            throw new IOException("Can't delete read-only Blueprint");
        }
        if (!blueprint.isReadOnly() && !this.getBlueprintFile(blueprint).delete()) {
            throw new IOException("Couldn't delete blueprint " + blueprint);
        }
        this.getBlueprintsInternal(blueprint.getTag()).remove(blueprint);
    }
}

