/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import genj.print.PrintTask;
import genj.util.Registry;
import genj.util.WordBuffer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.URISyntax;
import javax.print.attribute.standard.MediaPrintableArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintRegistry
extends Registry {
    public static PrintRegistry get(Object object) {
        Registry registry = Registry.get(object);
        return new PrintRegistry(registry);
    }

    private PrintRegistry(Registry registry) {
        super(registry, "");
    }

    public void put(PrintService printService) {
        super.put("service", printService.getName());
    }

    public PrintService get(PrintService printService) {
        String string = super.get("service", "");
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (!printServiceArray[i].getName().equals(string)) continue;
            return printServiceArray[i];
        }
        return printService;
    }

    public void put(AttributeSet attributeSet) {
        WordBuffer wordBuffer = new WordBuffer();
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            String string = this.put(attributeArray[i]);
            if (string == null) continue;
            wordBuffer.append(string);
        }
        super.put("attributes", wordBuffer.toString());
    }

    public void get(AttributeSet attributeSet) {
        StringTokenizer stringTokenizer = new StringTokenizer(super.get("attributes", ""));
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                Attribute attribute = this.get(Class.forName(string), null);
                if (attribute != null) {
                    attributeSet.add(attribute);
                    continue;
                }
                PrintTask.LOG.log(Level.INFO, "Couldn't restore print attribute " + string);
            }
            catch (Throwable throwable) {
                PrintTask.LOG.log(Level.WARNING, "Error restoring print attribute " + string, throwable);
            }
        }
    }

    public String put(Attribute attribute) {
        if (attribute instanceof EnumSyntax) {
            return this.put((EnumSyntax)((Object)attribute));
        }
        if (attribute instanceof IntegerSyntax) {
            return this.put((IntegerSyntax)((Object)attribute));
        }
        if (attribute instanceof URISyntax) {
            return this.put((URISyntax)((Object)attribute));
        }
        if (attribute instanceof MediaPrintableArea) {
            return this.put((MediaPrintableArea)attribute);
        }
        if (attribute instanceof TextSyntax) {
            return this.put((TextSyntax)((Object)attribute));
        }
        return null;
    }

    public Attribute get(Class<Attribute> clazz, Attribute attribute) {
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("only Attribute types allowed");
        }
        if (attribute != null && !clazz.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException("def/Attribute types mismatch");
        }
        if (EnumSyntax.class.isAssignableFrom(clazz)) {
            return this.getEnumSyntax(clazz, attribute);
        }
        if (IntegerSyntax.class.isAssignableFrom(clazz)) {
            return this.getIntegerSyntax(clazz, attribute);
        }
        if (URISyntax.class.isAssignableFrom(clazz)) {
            return this.getURISyntax(clazz, attribute);
        }
        if (MediaPrintableArea.class.isAssignableFrom(clazz)) {
            return this.getMediaPrintableArea(attribute);
        }
        if (TextSyntax.class.isAssignableFrom(clazz)) {
            return this.getTextSyntax(clazz, attribute);
        }
        return null;
    }

    private String put(TextSyntax textSyntax) {
        String string = textSyntax.getClass().getName();
        super.put(string, textSyntax.getValue());
        return string;
    }

    private Attribute getTextSyntax(Class<Attribute> clazz, Attribute attribute) {
        String string = super.get(clazz.getName(), (String)null);
        if (string == null) {
            return attribute;
        }
        try {
            return clazz.getConstructor(String.class, Locale.class).newInstance(string, null);
        }
        catch (Throwable throwable) {
            return attribute;
        }
    }

    private String put(URISyntax uRISyntax) {
        String string = uRISyntax.getClass().getName();
        super.put(string, "" + uRISyntax.getURI());
        return string;
    }

    private Attribute getURISyntax(Class<Attribute> clazz, Attribute attribute) {
        String string = super.get(clazz.getName(), (String)null);
        if (string == null) {
            return attribute;
        }
        try {
            return clazz.getConstructor(URI.class).newInstance(new URI(string));
        }
        catch (Throwable throwable) {
            return attribute;
        }
    }

    private String put(IntegerSyntax integerSyntax) {
        String string = integerSyntax.getClass().getName();
        super.put(string, integerSyntax.getValue());
        return string;
    }

    private Attribute getIntegerSyntax(Class<Attribute> clazz, Attribute attribute) {
        int n = super.get(clazz.getName(), -1);
        if (n < 0) {
            return attribute;
        }
        try {
            return clazz.getConstructor(Integer.TYPE).newInstance(new Integer(n));
        }
        catch (Throwable throwable) {
            return attribute;
        }
    }

    private String put(EnumSyntax enumSyntax) {
        String string = enumSyntax.getClass().getName();
        super.put(string, enumSyntax.getValue());
        return string;
    }

    private Attribute getEnumSyntax(Class<Attribute> clazz, Attribute attribute) {
        int n = super.get(clazz.getName(), -1);
        if (n < 0) {
            return attribute;
        }
        try {
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                EnumSyntax enumSyntax;
                Field field = fieldArray[i];
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getType() != clazz || (enumSyntax = (EnumSyntax)field.get(null)).getValue() != n) continue;
                return (Attribute)((Object)enumSyntax);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return attribute;
    }

    private String put(MediaPrintableArea mediaPrintableArea) {
        String string = mediaPrintableArea.getClass().getName();
        super.put(string + ".x", mediaPrintableArea.getX(25400));
        super.put(string + ".y", mediaPrintableArea.getY(25400));
        super.put(string + ".w", mediaPrintableArea.getWidth(25400));
        super.put(string + ".h", mediaPrintableArea.getHeight(25400));
        return string;
    }

    private Attribute getMediaPrintableArea(Attribute attribute) {
        String string = MediaPrintableArea.class.getName() + ".";
        float f = super.get(string + 'x', -1.0f);
        float f2 = super.get(string + 'y', -1.0f);
        float f3 = super.get(string + 'w', -1.0f);
        float f4 = super.get(string + 'h', -1.0f);
        if (f < 0.0f || f2 < 0.0f || f3 < 0.0f || f4 < 0.0f) {
            return attribute;
        }
        try {
            return new MediaPrintableArea(f, f2, f3, f4, 25400);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return attribute;
        }
    }
}

