/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import genj.option.Multiline;
import genj.option.MultipleChoiceOption;
import genj.option.Option;
import genj.option.OptionUI;
import genj.option.OptionsWidget;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.FontChooser;
import genj.util.swing.GraphicsHelper;
import genj.util.swing.TextFieldWidget;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyOption
extends Option {
    protected String property;
    protected Object instance;

    public static List<PropertyOption> introspect(Object object) {
        return PropertyOption.introspect(object, false);
    }

    public static List<PropertyOption> introspect(Object object, boolean bl) {
        return PropertyOption.introspect(object, bl ? new ArrayList() : null);
    }

    private static List<PropertyOption> introspect(Object object, List<Object> list) {
        Object object2;
        Field[] fieldArray;
        if (list != null) {
            list.add(object);
        }
        ArrayList<PropertyOption> arrayList = new ArrayList<PropertyOption>();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            fieldArray = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] propertyDescriptorArray = fieldArray.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                object2 = propertyDescriptorArray[i];
                try {
                    if (((PropertyDescriptor)object2).getReadMethod() == null || ((PropertyDescriptor)object2).getWriteMethod() == null || !Impl.isSupportedArgument(((PropertyDescriptor)object2).getPropertyType())) continue;
                    ((PropertyDescriptor)object2).getReadMethod().invoke(object, (Object[])null);
                    arrayList.add(BeanPropertyImpl.create(object, (PropertyDescriptor)object2));
                    hashSet.add(((FeatureDescriptor)object2).getName());
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        fieldArray = object.getClass().getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            int n;
            Field field = fieldArray[i];
            object2 = field.getType();
            if (hashSet.contains(field.getName()) || Modifier.isFinal(n = field.getModifiers()) || Modifier.isStatic(n)) continue;
            try {
                field.get(object);
            }
            catch (Throwable throwable) {
                continue;
            }
            if (Impl.isSupportedArgument((Class)object2)) {
                arrayList.add(FieldImpl.create(object, field));
                continue;
            }
            if (list == null) continue;
            try {
                for (PropertyOption propertyOption : PropertyOption.introspect(field.get(object), list)) {
                    String string = propertyOption.getCategory();
                    propertyOption.setCategory(field.getName());
                    arrayList.add(propertyOption);
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList;
    }

    protected PropertyOption(Object object, String string) {
        this.instance = object;
        this.property = string;
    }

    public abstract void persist(Registry var1);

    public abstract void restore(Registry var1);

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract void setName(String var1);

    public abstract void setToolTip(String var1);

    public String getProperty() {
        return this.property;
    }

    @Override
    public String getCategory() {
        Resources resources;
        String string = super.getCategory();
        if (string == null && (string = (resources = Resources.get(this.instance)).getString("options", false)) != null) {
            super.setCategory(string);
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FontMapper
    extends Mapper {
        private static final String FAMILY = "family=";
        private static final String STYLE = "style=";
        private static final String SIZE = "size=";

        private FontMapper() {
        }

        @Override
        protected Object toObject(Object object, Class<?> clazz) {
            if (clazz != Font.class || object == null || object.getClass() != String.class) {
                return super.toObject(object, clazz);
            }
            String string = (String)object;
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            String string2 = this.getAttribute(string, FAMILY);
            if (string2 == null) {
                string2 = "SansSerif";
            }
            hashMap.put(TextAttribute.FAMILY, string2);
            try {
                hashMap.put(TextAttribute.SIZE, new Float(this.getAttribute(string, SIZE)));
            }
            catch (Throwable throwable) {
                hashMap.put(TextAttribute.SIZE, new Float(11.0f));
            }
            return new Font(hashMap);
        }

        protected String getAttribute(String string, String string2) {
            char c;
            int n;
            int n2 = string.indexOf(string2);
            if (n2 < 0) {
                return null;
            }
            for (n = n2 += string2.length(); n < string.length() && (Character.isLetterOrDigit(c = string.charAt(n)) || Character.isWhitespace(c)); ++n) {
            }
            return n < n2 ? null : string.substring(n2, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Mapper {
        private Mapper() {
        }

        private static Class<?> box(Class<?> clazz) {
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
            return clazz;
        }

        protected String toString(Object object) {
            return object != null ? object.toString() : "";
        }

        protected Object toObject(Object object, Class<?> clazz) {
            clazz = Mapper.box(clazz);
            if (object == null || object.getClass() == clazz) {
                return object;
            }
            try {
                return clazz.getConstructor(object.getClass()).newInstance(object);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("can't map " + object + " to expected");
            }
        }
    }

    private static class BeanPropertyImpl
    extends Impl {
        PropertyDescriptor descriptor;

        protected static PropertyOption create(Object object, PropertyDescriptor propertyDescriptor) {
            BeanPropertyImpl beanPropertyImpl = new BeanPropertyImpl(object, propertyDescriptor);
            if (propertyDescriptor.getPropertyType() == Integer.TYPE) {
                try {
                    final Method method = object.getClass().getMethod(propertyDescriptor.getReadMethod().getName() + "s", null);
                    if (method.getReturnType().isArray()) {
                        return new MultipleChoiceOption(beanPropertyImpl){

                            public Object[] getChoicesImpl() throws Throwable {
                                return (Object[])method.invoke(this.instance, (Object[])null);
                            }
                        };
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return beanPropertyImpl;
        }

        private BeanPropertyImpl(Object object, PropertyDescriptor propertyDescriptor) {
            super(object, propertyDescriptor.getName(), propertyDescriptor.getPropertyType());
            this.multiline = propertyDescriptor.getReadMethod().getAnnotation(Multiline.class) != null;
            this.descriptor = propertyDescriptor;
        }

        protected Object getValueImpl() throws Throwable {
            return this.descriptor.getReadMethod().invoke(this.instance, (Object[])null);
        }

        protected void setValueImpl(Object object) throws Throwable {
            this.descriptor.getWriteMethod().invoke(this.instance, object);
        }
    }

    private static class FieldImpl
    extends Impl {
        protected Field field;

        protected static PropertyOption create(Object object, Field field) {
            FieldImpl fieldImpl = new FieldImpl(object, field);
            if (field.getType() == Integer.TYPE) {
                try {
                    final Field field2 = object.getClass().getField(field.getName() + "s");
                    if (field2.getType().isArray()) {
                        return new MultipleChoiceOption(fieldImpl){

                            public Object[] getChoicesImpl() throws Throwable {
                                return (Object[])field2.get(this.instance);
                            }
                        };
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return fieldImpl;
        }

        private FieldImpl(Object object, Field field) {
            super(object, field.getName(), field.getType());
            this.multiline = field.getAnnotation(Multiline.class) != null;
            this.field = field;
        }

        protected Object getValueImpl() throws Throwable {
            return this.field.get(this.instance);
        }

        protected void setValueImpl(Object object) throws Throwable {
            this.field.set(this.instance, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Impl
    extends PropertyOption {
        protected Class<?> type;
        protected boolean multiline = false;
        private String name;
        private String toolTip;
        private Mapper mapper;

        protected Impl(Object object, String string, Class<?> clazz) {
            super(object, string);
            this.type = clazz;
            this.mapper = clazz == Font.class ? new FontMapper() : new Mapper();
        }

        @Override
        public String getName() {
            if (this.name == null) {
                Resources resources = Resources.get(this.instance);
                this.name = resources.getString("option." + this.property, false);
                if (this.name == null) {
                    this.name = resources.getString(this.property, false);
                    if (this.name == null) {
                        this.name = this.property;
                    }
                }
            }
            return this.name;
        }

        @Override
        public void setName(String string) {
            this.name = string;
        }

        @Override
        public String getToolTip() {
            if (this.toolTip == null) {
                Resources resources = Resources.get(this.instance);
                this.toolTip = resources.getString("option." + this.property + ".tip", false);
                if (this.toolTip == null) {
                    this.toolTip = resources.getString(this.property + ".tip", false);
                }
            }
            return this.toolTip;
        }

        @Override
        public void setToolTip(String string) {
            this.toolTip = string;
        }

        @Override
        public void restore() {
            this.restore(Registry.get(this.instance));
        }

        @Override
        public void restore(Registry registry) {
            String string = registry.get(this.getProperty(), (String)null);
            if (string != null) {
                this.setValue(string);
            }
        }

        @Override
        public void persist() {
            this.persist(Registry.get(this.instance));
        }

        @Override
        public void persist(Registry registry) {
            Object object = this.getValue();
            if (object != null) {
                registry.put(this.getProperty(), object.toString());
            }
        }

        @Override
        public OptionUI getUI(OptionsWidget optionsWidget) {
            if (Color.class.isAssignableFrom(this.type)) {
                return new ColorUI(this);
            }
            if (Font.class.isAssignableFrom(this.type)) {
                return new FontUI(this);
            }
            if (this.type == Boolean.TYPE) {
                return new BooleanUI(this);
            }
            if (this.type == File.class) {
                return new FileUI(this);
            }
            if (this.type == String.class && this.multiline) {
                return new MultilineUI(this);
            }
            return new SimpleUI(this);
        }

        @Override
        public final Object getValue() {
            try {
                return this.getValueImpl();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        protected abstract Object getValueImpl() throws Throwable;

        @Override
        public final void setValue(Object object) {
            try {
                Object object2 = this.getValueImpl();
                if (object2 == object) {
                    return;
                }
                if (object2 != null && object != null && object2.equals(object)) {
                    return;
                }
                this.setValueImpl(this.mapper.toObject(object, this.type));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.fireChangeNotification();
        }

        protected abstract void setValueImpl(Object var1) throws Throwable;

        private static boolean isSupportedArgument(Class<?> clazz) {
            return Font.class.isAssignableFrom(clazz) || Color.class.isAssignableFrom(clazz) || File.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz);
        }
    }

    protected static abstract class DialogUI
    extends JButton
    implements ActionListener,
    OptionUI {
        protected PropertyOption option;

        public DialogUI(PropertyOption propertyOption) {
            this.option = propertyOption;
            this.setMargin(new Insets(2, 2, 2, 2));
            this.addActionListener(this);
        }

        public String getTextRepresentation() {
            return null;
        }

        public JComponent getComponentRepresentation() {
            this.setText("...");
            return this;
        }

        public void endRepresentation() {
        }

        protected abstract JComponent getEditor(Object var1);

        protected abstract Object getValue(JComponent var1);

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.option.getValue();
            JComponent jComponent = this.getEditor(object);
            int n = DialogHelper.openDialog(this.option.getName(), 3, new JScrollPane(jComponent), (Action[])Action2.okCancel(), (Object)actionEvent);
            if (n == 0) {
                this.option.setValue(this.getValue(jComponent));
                this.getComponentRepresentation();
            }
        }
    }

    protected static class MultilineUI
    extends DialogUI {
        public MultilineUI(PropertyOption propertyOption) {
            super(propertyOption);
        }

        protected JComponent getEditor(Object object) {
            JTextArea jTextArea = new JTextArea(4, 12);
            jTextArea.setLineWrap(true);
            jTextArea.setText(object != null ? object.toString() : "");
            return jTextArea;
        }

        protected Object getValue(JComponent jComponent) {
            return ((JTextArea)jComponent).getText();
        }
    }

    protected static class SimpleUI
    extends TextFieldWidget
    implements OptionUI {
        private PropertyOption option;

        public SimpleUI(PropertyOption propertyOption) {
            this.option = propertyOption;
            Object object = propertyOption.getValue();
            this.setText(object != null ? object.toString() : "");
            this.setSelectAllOnFocus(true);
            this.setColumns(12);
        }

        public String getTextRepresentation() {
            return this.getText();
        }

        public JComponent getComponentRepresentation() {
            return this;
        }

        public void endRepresentation() {
            this.option.setValue(this.getText());
        }
    }

    protected static class BooleanUI
    extends JCheckBox
    implements OptionUI {
        private PropertyOption option;

        public BooleanUI(PropertyOption propertyOption) {
            this.option = propertyOption;
            this.setOpaque(false);
            this.setHorizontalAlignment(2);
            Boolean bl = (Boolean)propertyOption.getValue();
            if (bl.booleanValue()) {
                this.setSelected(true);
            }
        }

        public String getTextRepresentation() {
            return null;
        }

        public JComponent getComponentRepresentation() {
            return this;
        }

        public void endRepresentation() {
            this.option.setValue(this.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected static class FileUI
    implements OptionUI {
        private FileChooserWidget chooser = new FileChooserWidget();
        private PropertyOption option;

        public FileUI(PropertyOption propertyOption) {
            this.option = propertyOption;
            this.chooser.setFile((File)propertyOption.getValue());
        }

        public String getTextRepresentation() {
            return this.chooser.getFile().toString();
        }

        public JComponent getComponentRepresentation() {
            return this.chooser;
        }

        public void endRepresentation() {
            this.option.setValue(this.chooser.getFile());
        }
    }

    protected static class ColorUI
    extends DialogUI {
        public ColorUI(PropertyOption propertyOption) {
            super(propertyOption);
        }

        protected JComponent getEditor(Object object) {
            JColorChooser jColorChooser = new JColorChooser();
            if (object != null) {
                jColorChooser.setColor((Color)object);
            }
            return jColorChooser;
        }

        public JComponent getComponentRepresentation() {
            JComponent jComponent = super.getComponentRepresentation();
            Object object = this.option.getValue();
            if (jComponent instanceof AbstractButton && object != null) {
                ((AbstractButton)jComponent).setText(null);
                ((AbstractButton)jComponent).setIcon(GraphicsHelper.getIcon(new Rectangle(8, 8), (Color)object));
            }
            return jComponent;
        }

        protected Object getValue(JComponent jComponent) {
            return ((JColorChooser)jComponent).getColor();
        }
    }

    protected static class FontUI
    implements OptionUI {
        private FontChooser chooser = new FontChooser();
        private PropertyOption option;

        public FontUI(PropertyOption propertyOption) {
            this.option = propertyOption;
        }

        public String getTextRepresentation() {
            Font font = (Font)this.option.getValue();
            return font == null ? "" : font.getFamily() + "," + font.getSize();
        }

        public JComponent getComponentRepresentation() {
            Font font = (Font)this.option.getValue();
            this.chooser.setSelectedFont(font);
            return this.chooser;
        }

        public void endRepresentation() {
            this.option.setValue(this.chooser.getSelectedFont());
        }
    }
}

