/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.GedcomException;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;

public class HebrewCalendar
extends Calendar {
    private static final String[] MONTHS = new String[]{"TSH", "CSH", "KSL", "TVT", "SHV", "ADR", "ADS", "NSN", "IYR", "SVN", "TMZ", "AAV", "ELL"};
    private static final String[] WEEKDAYS = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAB"};
    private static final int HALAKIM_PER_HOUR = 1080;
    private static final int HALAKIM_PER_DAY = 25920;
    private static final int HALAKIM_PER_LUNAR_CYCLE = 765433;
    private static final int HALAKIM_PER_METONIC_CYCLE = 179876755;
    private static final int SDN_OFFSET = 347997;
    private static final int NEW_MOON_OF_CREATION = 31524;
    private static final int SUNDAY = 0;
    private static final int MONDAY = 1;
    private static final int TUESDAY = 2;
    private static final int WEDNESDAY = 3;
    private static final int THURSDAY = 4;
    private static final int FRIDAY = 5;
    private static final int SATURDAY = 6;
    private static final int NOON = 19440;
    private static final int AM3_11_20 = 9924;
    private static final int AM9_32_43 = 16789;
    private static int[] monthsPerYear = new int[]{12, 12, 13, 12, 12, 13, 12, 13, 12, 12, 13, 12, 12, 13, 12, 12, 13, 12, 13};
    private static int[] yearOffset = new int[]{0, 12, 24, 37, 49, 61, 74, 86, 99, 111, 123, 136, 148, 160, 173, 185, 197, 210, 222};

    protected HebrewCalendar() {
        super("@#DHEBREW@", "hebrew", "images/Hebrew", MONTHS, WEEKDAYS);
    }

    protected PointInTime toPointInTime(int n) throws GedcomException {
        if (n <= 347997) {
            throw new GedcomException(resources.getString("hebrew.bef"));
        }
        return this.SdnToJewish(n);
    }

    protected int toJulianDay(int n, int n2, int n3) throws GedcomException {
        if (n3 < 1) {
            throw new GedcomException(resources.getString("hebrew.one"));
        }
        return this.JewishToSdn(n3, n2 + 1, n + 1);
    }

    public int getDays(int n, int n2) {
        switch (n) {
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                return 29;
            }
            case 1: {
                if (this.getDays(n2) % 10 == 5) break;
                return 29;
            }
            case 2: {
                if (this.getDays(n2) % 10 != 3) break;
                return 29;
            }
        }
        return 30;
    }

    private int getDays(int n) {
        try {
            return this.toJulianDay(1, 1, n + 1) - this.toJulianDay(1, 1, n);
        }
        catch (Throwable throwable) {
            throw new RuntimeException();
        }
    }

    private PointInTime wrap(int n, int n2, int n3) {
        return new PointInTime(n - 1, n2 - 1, n3, this);
    }

    private int getTishri1(int n, Molad molad) {
        boolean bl;
        int n2 = molad.day;
        int n3 = n2 % 7;
        boolean bl2 = n == 2 || n == 5 || n == 7 || n == 10 || n == 13 || n == 16 || n == 18;
        boolean bl3 = bl = n == 3 || n == 6 || n == 8 || n == 11 || n == 14 || n == 17 || n == 0;
        if (molad.halakim >= 19440 || !bl2 && n3 == 2 && molad.halakim >= 9924 || bl && n3 == 1 && molad.halakim >= 16789) {
            ++n2;
            if (++n3 == 7) {
                n3 = 0;
            }
        }
        if (n3 == 3 || n3 == 5 || n3 == 0) {
            ++n2;
        }
        return n2;
    }

    private void getMoladOfMetonicCycle(int n, Molad molad) {
        int n2 = 31524;
        int n3 = (n2 += n * 45971) >> 16;
        int n4 = (n3 += n * 2744) / 25920;
        n2 = (n3 -= n4 * 25920) << 16 | n2 & 0xFFFF;
        int n5 = n2 / 25920;
        molad.day = n4 << 16 | n5;
        molad.halakim = n2 -= n5 * 25920;
    }

    private void FindTishriMolad(int n, Metonic metonic, Molad molad) {
        int n2;
        int n3 = (n + 310) / 6940;
        this.getMoladOfMetonicCycle(n3, molad);
        while (molad.day < n - 6940 + 310) {
            ++n3;
            molad.halakim += 179876755;
            molad.day += molad.halakim / 25920;
            molad.halakim %= 25920;
        }
        for (n2 = 0; n2 < 18 && molad.day <= n - 74; ++n2) {
            molad.halakim += 765433 * monthsPerYear[n2];
            molad.day += molad.halakim / 25920;
            molad.halakim %= 25920;
        }
        metonic.cycle = n3;
        metonic.year = n2;
    }

    private int FindStartOfYear(int n, Metonic metonic, Molad molad) {
        metonic.cycle = (n - 1) / 19;
        metonic.year = (n - 1) % 19;
        this.getMoladOfMetonicCycle(metonic.cycle, molad);
        molad.halakim += 765433 * yearOffset[metonic.year];
        molad.day += molad.halakim / 25920;
        molad.halakim %= 25920;
        return this.getTishri1(metonic.year, molad);
    }

    private PointInTime SdnToJewish(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Molad molad = new Molad();
        Metonic metonic = new Metonic();
        if (n <= 347997) {
            return null;
        }
        int n6 = n - 347997;
        this.FindTishriMolad(n6, metonic, molad);
        int n7 = this.getTishri1(metonic.year, molad);
        if (n6 >= n7) {
            n5 = metonic.cycle * 19 + metonic.year + 1;
            if (n6 < n7 + 59) {
                int n8;
                int n9;
                if (n6 < n7 + 30) {
                    n9 = 1;
                    n8 = n6 - n7 + 1;
                } else {
                    n9 = 2;
                    n8 = n6 - n7 - 29;
                }
                return this.wrap(n8, n9, n5);
            }
            molad.halakim += 765433 * monthsPerYear[metonic.year];
            molad.day += molad.halakim / 25920;
            molad.halakim %= 25920;
            n4 = this.getTishri1((metonic.year + 1) % 19, molad);
        } else {
            n5 = metonic.cycle * 19 + metonic.year;
            if (n6 >= n7 - 177) {
                int n10;
                int n11;
                if (n6 > n7 - 30) {
                    n11 = 13;
                    n10 = n6 - n7 + 30;
                } else if (n6 > n7 - 60) {
                    n11 = 12;
                    n10 = n6 - n7 + 60;
                } else if (n6 > n7 - 89) {
                    n11 = 11;
                    n10 = n6 - n7 + 89;
                } else if (n6 > n7 - 119) {
                    n11 = 10;
                    n10 = n6 - n7 + 119;
                } else if (n6 > n7 - 148) {
                    n11 = 9;
                    n10 = n6 - n7 + 148;
                } else {
                    n11 = 8;
                    n10 = n6 - n7 + 178;
                }
                return this.wrap(n10, n11, n5);
            }
            if (monthsPerYear[(n5 - 1) % 19] == 13) {
                n3 = 7;
                n2 = n6 - n7 + 207;
                if (n2 > 0) {
                    return this.wrap(n2, n3, n5);
                }
                --n3;
                if ((n2 += 30) > 0) {
                    return this.wrap(n2, n3, n5);
                }
                --n3;
                n2 += 30;
            } else {
                n3 = 6;
                n2 = n6 - n7 + 207;
                if (n2 > 0) {
                    return this.wrap(n2, n3, n5);
                }
                --n3;
                n2 += 30;
            }
            if (n2 > 0) {
                return this.wrap(n2, n3, n5);
            }
            --n3;
            if ((n2 += 29) > 0) {
                return this.wrap(n2, n3, n5);
            }
            n4 = n7;
            this.FindTishriMolad(molad.day - 365, metonic, molad);
            n7 = this.getTishri1(metonic.year, molad);
        }
        int n12 = n4 - n7;
        n2 = n6 - n7 - 29;
        if (n12 == 355 || n12 == 385) {
            if (n2 <= 30) {
                n3 = 2;
                return this.wrap(n2, n3, n5);
            }
            n2 -= 30;
        } else {
            if (n2 <= 29) {
                n3 = 2;
                return this.wrap(n2, n3, n5);
            }
            n2 -= 29;
        }
        n3 = 3;
        return this.wrap(n2, n3, n5);
    }

    private int JewishToSdn(int n, int n2, int n3) {
        int n4;
        Molad molad = new Molad();
        Metonic metonic = new Metonic();
        if (n <= 0 || n3 <= 0 || n3 > 30) {
            return 0;
        }
        block0 : switch (n2) {
            case 1: 
            case 2: {
                int n5 = this.FindStartOfYear(n, metonic, molad);
                if (n2 == 1) {
                    n4 = n5 + n3 - 1;
                    break;
                }
                n4 = n5 + n3 + 29;
                break;
            }
            case 3: {
                int n6 = this.FindStartOfYear(n, metonic, molad);
                molad.halakim += 765433 * monthsPerYear[metonic.year];
                molad.day += molad.halakim / 25920;
                molad.halakim %= 25920;
                int n7 = this.getTishri1((metonic.year + 1) % 19, molad);
                int n8 = n7 - n6;
                if (n8 == 355 || n8 == 385) {
                    n4 = n6 + n3 + 59;
                    break;
                }
                n4 = n6 + n3 + 58;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                int n9 = this.FindStartOfYear(n + 1, metonic, molad);
                int n10 = monthsPerYear[(n - 1) % 19] == 12 ? 29 : 59;
                if (n2 == 4) {
                    n4 = n9 + n3 - n10 - 237;
                    break;
                }
                if (n2 == 5) {
                    n4 = n9 + n3 - n10 - 208;
                    break;
                }
                n4 = n9 + n3 - n10 - 178;
                break;
            }
            default: {
                int n11 = this.FindStartOfYear(n + 1, metonic, molad);
                switch (n2) {
                    case 7: {
                        n4 = n11 + n3 - 207;
                        break block0;
                    }
                    case 8: {
                        n4 = n11 + n3 - 178;
                        break block0;
                    }
                    case 9: {
                        n4 = n11 + n3 - 148;
                        break block0;
                    }
                    case 10: {
                        n4 = n11 + n3 - 119;
                        break block0;
                    }
                    case 11: {
                        n4 = n11 + n3 - 89;
                        break block0;
                    }
                    case 12: {
                        n4 = n11 + n3 - 60;
                        break block0;
                    }
                    case 13: {
                        n4 = n11 + n3 - 30;
                        break block0;
                    }
                }
                return 0;
            }
        }
        return n4 + 347997;
    }

    private class Metonic {
        int cycle;
        int year;

        private Metonic() {
        }
    }

    private class Molad {
        int day;
        int halakim;

        private Molad() {
        }
    }
}

