/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;

public class GregorianCalendar
extends Calendar {
    protected static final String[] MONTHS = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    protected static final String[] WEEKDAYS = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
    private static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    protected GregorianCalendar() {
        this("@#DGREGORIAN@", "gregorian", "images/Gregorian");
    }

    protected GregorianCalendar(String string, String string2, String string3) {
        super(string, string2, string3, MONTHS, WEEKDAYS);
    }

    public int getDays(int n, int n2) {
        int[] nArray = this.isLeap(n2) ? LEAP_MONTH_LENGTH : MONTH_LENGTH;
        return nArray[n];
    }

    protected boolean isLeap(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    protected int toJulianDay(int n, int n2, int n3) {
        if (n3 < 0) {
            ++n3;
        }
        int n4 = n + 1;
        int n5 = n2 + 1;
        int n6 = n3;
        return 1461 * (n6 + 4800 + (n5 - 14) / 12) / 4 + 367 * (n5 - 2 - 12 * ((n5 - 14) / 12)) / 12 - 3 * ((n6 + 4900 + (n5 - 14) / 12) / 100) / 4 + n4 - 32075;
    }

    protected PointInTime toPointInTime(int n) {
        int n2 = n + 68569;
        int n3 = 4 * n2 / 146097;
        int n4 = 4000 * ((n2 -= (146097 * n3 + 3) / 4) + 1) / 1461001;
        n2 = n2 - 1461 * n4 / 4 + 31;
        int n5 = 80 * n2 / 2447;
        int n6 = n2 - 2447 * n5 / 80;
        n2 = n5 / 11;
        int n7 = n5 + 2 - 12 * n2;
        int n8 = 100 * (n3 - 49) + n4 + n2;
        return new PointInTime(n6 - 1, n7 - 1, n8 <= 0 ? n8 - 1 : n8, this);
    }
}

