/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.util.HashMap;
import java.util.Map;

public abstract class Calendar {
    protected String escape;
    protected String name;
    protected ImageIcon image;
    protected String[] months;
    protected String[] monthsLowerCase;
    protected String[] weekDays;
    protected String[] localizedWeekDays;
    protected Map<String, String> localizedMonthNames = new HashMap<String, String>();
    protected Map<String, String> abbreviatedMonthNames = new HashMap<String, String>();
    protected static final Resources resources = PointInTime.resources;
    public static final String TXT_CALENDAR_SWITCH = resources.getString("cal.switch");
    public static final String TXT_CALENDAR_RESET = resources.getString("cal.reset");

    protected Calendar(String string, String string2, String string3, String[] stringArray, String[] stringArray2) {
        int n;
        this.months = stringArray;
        this.monthsLowerCase = new String[this.months.length];
        for (n = 0; n < this.months.length; ++n) {
            this.monthsLowerCase[n] = this.months[n].toLowerCase();
        }
        this.escape = string;
        this.name = resources.getString("cal." + string2);
        this.image = new ImageIcon(Gedcom.class, string3);
        this.weekDays = stringArray2;
        this.localizedWeekDays = new String[this.weekDays.length];
        for (n = 0; n < this.weekDays.length; ++n) {
            this.localizedWeekDays[n] = resources.getString("day." + this.weekDays[n]);
        }
        for (n = 0; n < this.months.length; ++n) {
            String string4;
            String string5 = this.months[n];
            String string6 = resources.getString("mon." + string5);
            int n2 = string6.indexOf(124);
            if (n2 > 0) {
                string4 = string6.substring(0, n2);
                string6 = string4 + string6.substring(n2 + 1);
            } else {
                n2 = string6.indexOf(44);
                if (n2 > 0) {
                    string4 = string6.substring(n2 + 1);
                    string6 = string6.substring(0, n2);
                } else {
                    string4 = string6.length() > 3 ? string6.substring(0, 3) : string6;
                }
            }
            this.localizedMonthNames.put(string5, string6);
            this.abbreviatedMonthNames.put(string5, string4);
        }
    }

    public String getName() {
        return this.name;
    }

    public ImageIcon getImage() {
        return this.image;
    }

    protected int parseMonth(String string) throws NumberFormatException {
        String string2 = string.toLowerCase();
        for (int i = 0; i < this.months.length; ++i) {
            if (!this.monthsLowerCase[i].equals(string2)) continue;
            return i;
        }
        throw new NumberFormatException();
    }

    public String getDay(int n) {
        if (n == Integer.MAX_VALUE) {
            return "";
        }
        return "" + (n + 1);
    }

    public String[] getMonths(boolean bl) {
        String[] stringArray = new String[this.months.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.months[i];
            if (bl) {
                string = this.localizedMonthNames.get(string).toString();
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public String getMonth(int n) {
        if (n < 0 || n >= this.months.length) {
            return "";
        }
        return this.months[n];
    }

    public String getDisplayMonth(int n, boolean bl) {
        String string = this.getMonth(n);
        if (string.length() == 0) {
            return string;
        }
        return bl ? this.abbreviatedMonthNames.get(string).toString() : this.localizedMonthNames.get(string).toString();
    }

    public String getYear(int n) {
        if (n == Integer.MAX_VALUE) {
            return "";
        }
        return "" + n;
    }

    public String getDisplayYear(int n) {
        return this.getYear(n);
    }

    public int getYear(String string) throws GedcomException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new GedcomException(resources.getString("year.invalid"));
        }
    }

    public int getMonths() {
        return this.months.length;
    }

    public abstract int getDays(int var1, int var2);

    protected String getDayOfWeek(PointInTime pointInTime, boolean bl) throws GedcomException {
        if (!pointInTime.isComplete()) {
            throw new GedcomException(resources.getString("pit.incomplete"));
        }
        String[] stringArray = bl ? this.localizedWeekDays : this.weekDays;
        int n = (pointInTime.getJulianDay() + 1) % 7;
        return stringArray[n >= 0 ? n : n + 7];
    }

    protected final int toJulianDay(PointInTime pointInTime) throws GedcomException {
        int n = pointInTime.getYear();
        int n2 = pointInTime.getMonth();
        int n3 = pointInTime.getDay();
        if (n == Integer.MAX_VALUE || n == 0) {
            throw new GedcomException(resources.getString("year.invalid"));
        }
        if (n2 == Integer.MAX_VALUE && n3 != Integer.MAX_VALUE) {
            throw new GedcomException(resources.getString("month.invalid"));
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = 0;
        } else if (n2 < 0 || n2 >= this.months.length) {
            throw new GedcomException(resources.getString("month.invalid"));
        }
        if (n3 == Integer.MAX_VALUE) {
            n3 = 0;
        } else if (n3 < 0 || n3 >= this.getDays(n2, n)) {
            throw new GedcomException(resources.getString("day.invalid"));
        }
        return this.toJulianDay(n3, n2, n);
    }

    protected abstract int toJulianDay(int var1, int var2, int var3) throws GedcomException;

    protected abstract PointInTime toPointInTime(int var1) throws GedcomException;

    public String toString() {
        return this.getName();
    }
}

