/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;

public class PropertyQuality
extends Property {
    private String value = "";
    public static final String[] QUALITIES = Gedcom.resources.getString("QUAY.vals", false).split(",");

    public PropertyQuality(String string) {
        super(string);
    }

    public PropertyQuality() {
        this("QUAY");
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setQuality(int n) {
        if (n < -1 || n > 3) {
            throw new IllegalArgumentException("invalid quality value " + n);
        }
        String string = this.getValue();
        this.value = n < 0 ? "" : String.valueOf(n);
        super.propagatePropertyChanged(this, string);
    }

    public int getQuality() {
        try {
            int n = Integer.parseInt(this.value);
            if (n >= 0 && n <= 3) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }
}

