/*
 * Decompiled with CFR 0.152.
 */
package genj.entity;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Property;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.BlueprintRenderer;
import genj.renderer.ChooseBlueprintAction;
import genj.renderer.Options;
import genj.util.Registry;
import genj.util.Resources;
import genj.view.ContextProvider;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import spin.Spin;

public class EntityView
extends View
implements ContextProvider {
    static final Resources resources = Resources.get(EntityView.class);
    private static final Blueprint BLUEPRINT_SELECT = new Blueprint(resources.getString("html.select"));
    private static final Registry REGISTRY = Registry.get(EntityView.class);
    private BlueprintRenderer renderer = null;
    Context context = new Context();
    private Map<String, Blueprint> type2blueprint = new HashMap<String, Blueprint>();
    private boolean isAntialiasing = true;
    private transient GedcomListener callback = new GedcomListenerAdapter(){

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (EntityView.this.context.getEntity() == entity) {
                EntityView.this.setContext(new Context(EntityView.this.context.getGedcom()), true);
            }
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            if (EntityView.this.context.getEntity() == property.getEntity()) {
                EntityView.this.repaint();
            }
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
            this.gedcomPropertyChanged(gedcom, property);
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
            this.gedcomPropertyChanged(gedcom, property);
        }
    };

    public EntityView() {
        BlueprintManager blueprintManager = BlueprintManager.getInstance();
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            String string = Gedcom.ENTITIES[i];
            this.type2blueprint.put(string, blueprintManager.getBlueprint(string, REGISTRY.get("blueprint." + string, "")));
        }
        this.isAntialiasing = REGISTRY.get("antial", false);
    }

    public ViewContext getContext() {
        ViewContext viewContext = new ViewContext(this.context);
        if (this.context.getEntity() != null) {
            viewContext.addAction(new ChooseBlueprintAction(this.context.getEntity(), this.getBlueprint(this.context.getEntity().getTag())){

                protected void commit(Entity entity, Blueprint blueprint) {
                    EntityView.this.type2blueprint.put(blueprint.getTag(), blueprint);
                    EntityView.this.setContext(EntityView.this.context, false);
                    REGISTRY.put("blueprint." + blueprint.getTag(), blueprint.getName());
                }
            });
        }
        return viewContext;
    }

    public void setContext(Context context, boolean bl) {
        if (this.context.getGedcom() != null) {
            this.context.getGedcom().removeGedcomListener((GedcomListener)Spin.over((Object)this.callback));
        }
        this.renderer = null;
        this.context = context;
        if (this.context.getGedcom() != null) {
            this.context.getGedcom().addGedcomListener((GedcomListener)Spin.over((Object)this.callback));
            Entity entity = this.context.getEntity();
            Blueprint blueprint = entity == null ? BLUEPRINT_SELECT : this.getBlueprint(entity.getTag());
            this.renderer = new BlueprintRenderer(blueprint);
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(256, 160);
    }

    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.setFont(Options.getInstance().getDefaultFont());
        if (this.context == null || this.renderer == null) {
            return;
        }
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isAntialiasing ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.renderer.render(graphics, this.context.getEntity(), new Rectangle(0, 0, rectangle.width, rectangle.height));
    }

    private Blueprint getBlueprint(String string) {
        Blueprint blueprint = this.type2blueprint.get(string);
        if (blueprint == null) {
            blueprint = BlueprintManager.getInstance().getBlueprint(string, "");
            this.type2blueprint.put(string, blueprint);
        }
        return blueprint;
    }

    public void setAntialiasing(boolean bl) {
        this.isAntialiasing = bl;
        this.repaint();
    }

    public boolean isAntialiasing() {
        return this.isAntialiasing;
    }
}

