/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.actions.RunExternal;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.io.InputSource;
import genj.util.Origin;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.ThumbnailWidget;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilePermission;
import java.util.List;
import javax.swing.JCheckBox;

public class FileBean
extends PropertyBean {
    private JCheckBox updateMeta = new JCheckBox(RESOURCES.getString("file.update"), true);
    private FileChooserWidget chooser = new FileChooserWidget();
    private ThumbnailWidget preview = new ThumbnailWidget(){

        @Override
        protected void handleDrop(List<File> list) {
            if (list.size() == 1) {
                File file = list.get(0);
                FileBean.this.chooser.setFile(file);
                this.setSource(InputSource.get(file));
            }
        }
    };
    private transient ActionListener doPreview = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyBean.REGISTRY.put("bean.file.dir", FileBean.this.chooser.getDirectory());
            File file = FileBean.this.getRoot().getGedcom().getOrigin().getFile(FileBean.this.chooser.getFile().toString());
            if (file == null) {
                FileBean.this.preview.setSource(null);
                return;
            }
            FileBean.this.preview.setSource(InputSource.get(file));
            String string = FileBean.this.getProperty().getGedcom().getOrigin().calcRelativeLocation(file.getAbsolutePath());
            if (string != null) {
                FileBean.this.chooser.setFile(string);
            }
        }
    };

    public FileBean() {
        this.setLayout(new BorderLayout());
        this.chooser.setAccessory(this.updateMeta);
        this.chooser.addChangeListener(this.changeSupport);
        this.chooser.addActionListener(this.doPreview);
        this.add((Component)this.chooser, "North");
        this.add((Component)this.preview, "Center");
        this.defaultFocus = this.chooser;
    }

    public void setPropertyImpl(Property property) {
        Object object;
        String string;
        Origin origin = this.getRoot().getGedcom().getOrigin();
        String string2 = string = origin.getFile() != null ? origin.getFile().getParent() : null;
        if (string != null) {
            try {
                object = System.getSecurityManager();
                if (object != null) {
                    ((SecurityManager)object).checkPermission(new FilePermission(string, "read"));
                }
                this.chooser.setDirectory(REGISTRY.get("bean.file.dir", string));
                this.chooser.setVisible(true);
                this.defaultFocus = this.chooser;
            }
            catch (SecurityException securityException) {
                this.chooser.setVisible(false);
                this.defaultFocus = null;
            }
        }
        this.preview.setSource(null);
        if (property instanceof PropertyFile) {
            object = (PropertyFile)property;
            this.chooser.setTemplate(false);
            this.chooser.setFile(((PropertyFile)object).getValue());
            if (property.getValue().length() > 0) {
                this.preview.setSource(InputSource.get(property.getGedcom().getOrigin().getFile(((PropertyFile)object).getValue())));
            }
        }
        if (property instanceof PropertyBlob) {
            object = (PropertyBlob)property;
            this.chooser.setFile(((PropertyBlob)object).getValue());
            this.chooser.setTemplate(true);
            this.preview.setSource(InputSource.get(((Property)object).getPropertyName(), ((PropertyBlob)property).getBlobData()));
        }
    }

    protected void commitImpl(Property property) {
        File file;
        String string = this.chooser.getFile().toString();
        if (property instanceof PropertyFile) {
            ((PropertyFile)property).setValue(string, this.updateMeta.isSelected());
        }
        if (property instanceof PropertyBlob) {
            ((PropertyBlob)property).load(string, this.updateMeta.isSelected());
        }
        this.preview.setSource((file = this.getProperty().getGedcom().getOrigin().getFile(string)) != null ? InputSource.get(file) : null);
    }

    public ViewContext getContext() {
        PropertyFile propertyFile;
        ViewContext viewContext = super.getContext();
        if (viewContext != null && (propertyFile = (PropertyFile)this.getProperty()) != null) {
            viewContext.addAction(new RunExternal(propertyFile.getFile()));
        }
        return viewContext;
    }
}

