/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.common.SelectEntityWidget;
import genj.edit.Images;
import genj.edit.actions.GedcomDialog;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Note;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class EditNote
extends Action2 {
    private static final Resources RESOURCES = Resources.get(EditNote.class);
    public static final ImageIcon EDIT_NOTE = Grammar.V551.getMeta(new TagPath("NOTE")).getImage();
    public static final ImageIcon NEW_NOTE = EDIT_NOTE.getOverLayed(Images.imgNew);
    public static final ImageIcon NO_NOTE = EDIT_NOTE.getTransparent(128);
    private Property property;

    public EditNote(Property property) {
        this(property, false);
    }

    public EditNote(Property property, boolean bl) {
        this.property = property;
        boolean bl2 = this.hasNote(property);
        this.setImage(bl2 ? EDIT_NOTE : (bl ? NO_NOTE : NEW_NOTE));
        this.setText(RESOURCES.getString(bl2 ? "edit" : "add", Gedcom.getName("NOTE")));
        this.setTip(this.getText());
    }

    private boolean hasNote(Property property) {
        for (Property property2 : property.getProperties("NOTE")) {
            if (property2 instanceof PropertyNote && property2.isValid() && ((PropertyNote)property2).getTargetEntity().getValue().length() > 0) {
                return true;
            }
            if (property2.getValue().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final Property property = this.property.getProperty("NOTE", true);
        JPanel jPanel = new JPanel(new NestedBlockLayout("<col><entity/><text gy=\"1\"/></col>"));
        final SelectEntityWidget selectEntityWidget = new SelectEntityWidget(this.property.getGedcom(), "NOTE", property != null && !(property instanceof PropertyNote) ? Gedcom.getName("NOTE") : RESOURCES.getString("add", Gedcom.getName("NOTE")));
        jPanel.add(selectEntityWidget);
        final JTextPane jTextPane = new JTextPane();
        jTextPane.setPreferredSize(new Dimension(128, 128));
        jPanel.add(new JScrollPane(jTextPane));
        jPanel.putClientProperty("CLIENT_PROPERTY_JCOMPONENT_RECEIVING_FOCUS", jTextPane);
        selectEntityWidget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Note note = (Note)selectEntityWidget.getSelection();
                if (note != null) {
                    jTextPane.setText(note.getDisplayValue());
                } else if (!(property instanceof PropertyNote)) {
                    jTextPane.setText(property.getValue());
                } else {
                    jTextPane.setText("");
                }
            }
        });
        if (property instanceof PropertyNote) {
            selectEntityWidget.setSelection(((PropertyNote)property).getTargetEntity());
        } else if (property != null) {
            jTextPane.setText(property.getValue());
        }
        if (0 != new GedcomDialog(this.property.getGedcom(), this.property.toString() + " - " + this.getTip(), 3, jPanel, Action2.okCancel(), actionEvent).show()) {
            return;
        }
        this.property.getGedcom().doMuteUnitOfWork(new UnitOfWork(){

            public void perform(Gedcom gedcom) throws GedcomException {
                Note note = (Note)selectEntityWidget.getSelection();
                if (note == null && !(property instanceof PropertyNote) && Options.getInstance().isUseInline) {
                    if (property != null) {
                        property.setValue(jTextPane.getText());
                    } else {
                        EditNote.this.property.addProperty("NOTE", jTextPane.getText());
                    }
                    return;
                }
                String string = jTextPane.getText().trim();
                if (string.length() == 0) {
                    if (note != null) {
                        gedcom.deleteEntity(note);
                        note = null;
                    }
                } else {
                    if (note == null) {
                        note = (Note)EditNote.this.property.getGedcom().createEntity("NOTE");
                    }
                    note.setValue(string);
                }
                if (property != null && property.isValid()) {
                    Note note2 = null;
                    if (property instanceof PropertyNote) {
                        note2 = (Note)((PropertyNote)property).getTargetEntity();
                    }
                    EditNote.this.property.delProperty(property);
                    if (note2 != null && note2 != note && !note2.isConnected()) {
                        gedcom.deleteEntity(note2);
                    }
                }
                if (note != null) {
                    EditNote.this.property.addNote(note);
                }
            }
        });
    }
}

