/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.edit.BeanPanel;
import genj.edit.EditView;
import genj.edit.Editor;
import genj.edit.actions.EditNote;
import genj.edit.actions.EditSource;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.util.Registry;
import genj.view.ContextProvider;
import genj.view.SelectionSink;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.FocusManager;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

class BasicEditor
extends Editor
implements SelectionSink,
ContextProvider {
    static final Registry REGISTRY = Registry.get(BasicEditor.class);
    private Gedcom gedcom = null;
    private Entity currentEntity = null;
    private EditView view;
    private BeanPanel beanPanel;
    private boolean isIgnoreSetContext = false;

    public BasicEditor(Gedcom gedcom, EditView editView) {
        this.gedcom = gedcom;
        this.view = editView;
        this.beanPanel = new BeanPanel();
        this.beanPanel.addChangeListener(this.changes);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.beanPanel));
    }

    public void fireSelection(Context context, boolean bl) {
        if (bl || context.getEntities().size() == 1 && context.getEntity() == this.currentEntity) {
            SelectionSink.Dispatcher.fireSelection(this, context, bl);
        }
    }

    public ViewContext getContext() {
        PropertyBean propertyBean = this.getFocus();
        if (propertyBean != null && propertyBean.getContext() != null) {
            return propertyBean.getContext();
        }
        if (this.currentEntity != null) {
            return new ViewContext(this.currentEntity);
        }
        return new ViewContext(this.gedcom);
    }

    public void setContext(Context context) {
        if (this.isIgnoreSetContext) {
            return;
        }
        this.actions.clear();
        if (context.getGedcom() == null) {
            this.setEntity(null, null);
            return;
        }
        if (this.changes.hasChanged() || this.currentEntity != context.getEntity()) {
            this.setEntity(context.getEntity(), context.getProperty());
        }
        if (this.currentEntity != null && this.currentEntity.getMetaProperty().allows("NOTE")) {
            this.actions.add(new EditNote(this.currentEntity));
        }
        if (this.currentEntity != null && this.currentEntity.getMetaProperty().allows("SOUR")) {
            this.actions.add(new EditSource(this.currentEntity));
        }
        this.actions.addAll(this.beanPanel.getActions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws GedcomException {
        try {
            this.isIgnoreSetContext = true;
            this.beanPanel.commit();
        }
        finally {
            this.isIgnoreSetContext = false;
        }
        PropertyBean propertyBean = this.getFocus();
        Property property = propertyBean != null ? propertyBean.getProperty() : null;
    }

    public void setEntity(Entity entity, Property property) {
        this.currentEntity = entity;
        if (property == null) {
            PropertyBean propertyBean = this.getFocus();
            if (propertyBean != null && propertyBean.getProperty() != null && propertyBean.getProperty().getEntity() == this.currentEntity) {
                property = propertyBean.getProperty();
            }
            if (property == null) {
                property = this.currentEntity;
            }
        }
        this.beanPanel.setRoot(this.currentEntity);
        this.changes.setChanged(false);
    }

    private PropertyBean getFocus() {
        Component component;
        for (component = FocusManager.getCurrentManager().getFocusOwner(); component != null && !(component instanceof PropertyBean); component = component.getParent()) {
        }
        if (component == null) {
            return null;
        }
        return SwingUtilities.isDescendingFrom(component, this) ? (PropertyBean)component : null;
    }
}

