/*
 * Decompiled with CFR 0.152.
 */
package genj.crypto;

import genj.crypto.Enigma;
import genj.util.Base64;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

class EnigmaImpl
extends Enigma {
    private static final Logger LOG = Logger.getLogger("genj.crypto");
    private SecretKey key;
    private Cipher cipher;
    private static final String SALT_PADDING = "GENEALOGYJ";
    private static final String ALGORITHM = "DES";

    EnigmaImpl() {
    }

    protected Enigma init(String string) {
        try {
            byte[] byArray = (string + SALT_PADDING).getBytes("UTF-8");
            DESKeySpec dESKeySpec = new DESKeySpec(byArray);
            this.cipher = Cipher.getInstance(ALGORITHM);
            this.key = SecretKeyFactory.getInstance(ALGORITHM).generateSecret(dESKeySpec);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "Couldn't initialize Enigma", throwable);
            return null;
        }
        return this;
    }

    protected String encryptImpl(String string) throws IOException {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            this.cipher.init(1, this.key);
            byte[] byArray2 = this.cipher.doFinal(byArray);
            String string2 = Base64.encode(byArray2).toString();
            return string2;
        }
        catch (Throwable throwable) {
            throw new IOException("Encrypt failed : " + throwable + '/' + throwable.getMessage());
        }
    }

    protected String decryptImpl(String string) throws IOException {
        try {
            byte[] byArray = Base64.decode(string);
            this.cipher.init(2, this.key);
            byte[] byArray2 = this.cipher.doFinal(byArray);
            String string2 = new String(byArray2, "UTF-8");
            return string2;
        }
        catch (Throwable throwable) {
            throw new IOException("Decrypt failed : " + throwable.getMessage());
        }
    }
}

