/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.common.PropertyTableModel;
import genj.common.PropertyTableModelListener;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyNumericValue;
import genj.gedcom.PropertySex;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import spin.Spin;

public abstract class AbstractPropertyTableModel
implements PropertyTableModel,
GedcomListener {
    protected static final int LEFT = 2;
    protected static final int CENTER = 0;
    protected static final int RIGHT = 4;
    private List<PropertyTableModelListener> listeners = new CopyOnWriteArrayList<PropertyTableModelListener>();
    private Gedcom gedcom = null;
    private GedcomListener callback;

    protected AbstractPropertyTableModel(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    public final Gedcom getGedcom() {
        return this.gedcom;
    }

    public void addListener(PropertyTableModelListener propertyTableModelListener) {
        this.listeners.add(propertyTableModelListener);
        if (this.listeners.size() == 1) {
            this.gedcom.addGedcomListener((GedcomListener)Spin.over((Object)this));
        }
    }

    public void removeListener(PropertyTableModelListener propertyTableModelListener) {
        this.listeners.remove(propertyTableModelListener);
        if (this.listeners.isEmpty()) {
            this.gedcom.removeGedcomListener((GedcomListener)Spin.over((Object)this));
        }
    }

    public String getColName(int n) {
        return this.getColPath(n).getName();
    }

    protected void fireRowsChanged(int n, int n2, int n3) {
        for (PropertyTableModelListener propertyTableModelListener : this.listeners) {
            propertyTableModelListener.handleRowsChanged(this, n, n2, n3);
        }
    }

    protected void fireRowsAdded(int n, int n2) {
        for (PropertyTableModelListener propertyTableModelListener : this.listeners) {
            propertyTableModelListener.handleRowsAdded(this, n, n2);
        }
    }

    protected void fireRowsDeleted(int n, int n2) {
        for (PropertyTableModelListener propertyTableModelListener : this.listeners) {
            propertyTableModelListener.handleRowsDeleted(this, n, n2);
        }
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
    }

    public String getCellValue(Property property, int n, int n2) {
        return AbstractPropertyTableModel.getDefaultCellValue(property, n, n2);
    }

    static String getDefaultCellValue(Property property, int n, int n2) {
        if (property == null) {
            return "";
        }
        if (property instanceof Entity) {
            return ((Entity)property).getId();
        }
        if (property instanceof PropertySex) {
            return Character.toString(((PropertySex)property).getDisplayValue().charAt(0));
        }
        return property.getDisplayValue();
    }

    public int getCellAlignment(Property property, int n, int n2) {
        return AbstractPropertyTableModel.getDefaultCellAlignment(property, n, n2);
    }

    static int getDefaultCellAlignment(Property property, int n, int n2) {
        if (property instanceof Entity) {
            return 4;
        }
        if (property instanceof PropertyDate) {
            return 4;
        }
        if (property instanceof PropertyNumericValue) {
            return 4;
        }
        if (property instanceof PropertySex) {
            return 0;
        }
        return 2;
    }

    public int compare(Property property, Property property2, int n) {
        return AbstractPropertyTableModel.defaultCompare(property, property2, n);
    }

    static int defaultCompare(Property property, Property property2, int n) {
        return property.compareTo(property2);
    }
}

