/*
 * Decompiled with CFR 0.152.
 */
package genj.chart;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;

public class XYSeries {
    private LinkedList points = new LinkedList();
    private String name;

    public XYSeries(String string) {
        this.name = string;
    }

    public int getSize() {
        return this.points.size();
    }

    private Point2D.Float getPointByIndex(int n) {
        return (Point2D.Float)this.points.get(n);
    }

    private Point2D.Float getPointForX(float f) {
        for (int i = 0; i < this.points.size(); ++i) {
            Point2D.Float float_ = (Point2D.Float)this.points.get(i);
            if (float_.getX() == (double)f) {
                return float_;
            }
            if (!(float_.getX() > (double)f)) continue;
            float_ = new Point2D.Float(f, 0.0f);
            this.points.add(i, float_);
            return float_;
        }
        Point2D.Float float_ = new Point2D.Float(f, 0.0f);
        this.points.add(float_);
        return float_;
    }

    public void set(float f, float f2) {
        Point2D.Float float_ = this.getPointForX(f);
        float_.y = f2;
    }

    public void inc(float f) {
        Point2D.Float float_ = this.getPointForX(f);
        float_.y += 1.0f;
    }

    public static XYSeries[] toArray(Collection collection) {
        return collection.toArray(new XYSeries[collection.size()]);
    }

    static XYDataset toXYDataset(XYSeries[] xYSeriesArray) {
        return new XYDatasetImpl(xYSeriesArray);
    }

    private static class XYDatasetImpl
    extends AbstractXYDataset {
        private XYSeries[] series;

        private XYDatasetImpl(XYSeries[] xYSeriesArray) {
            this.series = xYSeriesArray;
        }

        public int getSeriesCount() {
            return this.series.length;
        }

        public String getSeriesName(int n) {
            return this.series[n].name;
        }

        public int getItemCount(int n) {
            return this.series[n].getSize();
        }

        public Number getX(int n, int n2) {
            Point2D.Float float_ = this.series[n].getPointByIndex(n2);
            return new Float(float_.x);
        }

        public Number getY(int n, int n2) {
            Point2D.Float float_ = this.series[n].getPointByIndex(n2);
            return new Float(float_.y);
        }

        public Comparable getSeriesKey(int n) {
            return this.series[n].name;
        }
    }
}

