/*
 * Decompiled with CFR 0.152.
 */
package genj.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.TableXYDataset;

public class IndexedSeries {
    private String name;
    private float[] values;
    private int start;

    public IndexedSeries(String string, IndexedSeries indexedSeries) {
        this(string, indexedSeries.start, indexedSeries.values.length);
    }

    public IndexedSeries(String string, int n) {
        this(string, 0, n);
    }

    public IndexedSeries(String string, int n, int n2) {
        this.name = string;
        this.start = n;
        this.values = new float[n2];
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public float get(int n) {
        return this.values[n -= this.start];
    }

    public void set(int n, float f) {
        if ((n -= this.start) < 0 || n >= this.values.length) {
            return;
        }
        this.values[n] = f;
    }

    public void inc(int n) {
        if ((n -= this.start) < 0 || n >= this.values.length) {
            return;
        }
        int n2 = n;
        this.values[n2] = this.values[n2] + 1.0f;
    }

    public void dec(int n) {
        if ((n -= this.start) < 0 || n >= this.values.length) {
            return;
        }
        int n2 = n;
        this.values[n2] = this.values[n2] - 1.0f;
    }

    public static IndexedSeries[] toArray(Collection collection) {
        return collection.toArray(new IndexedSeries[collection.size()]);
    }

    static PieDataset asPieDataset(IndexedSeries indexedSeries, String[] stringArray) {
        return new PieDatasetImpl(indexedSeries, stringArray);
    }

    static CategoryDataset asCategoryDataset(IndexedSeries[] indexedSeriesArray, String[] stringArray) {
        return new CategoryDatasetImpl(indexedSeriesArray, stringArray);
    }

    static TableXYDataset asTableXYDataset(IndexedSeries[] indexedSeriesArray) {
        return new TableXYDatasetImpl(indexedSeriesArray);
    }

    private static class CategoryDatasetImpl
    extends AbstractDataset
    implements CategoryDataset {
        private IndexedSeries[] series;
        private String[] categories;

        private CategoryDatasetImpl(IndexedSeries[] indexedSeriesArray, String[] stringArray) {
            this.series = indexedSeriesArray;
            this.categories = stringArray;
            for (int i = 0; i < indexedSeriesArray.length; ++i) {
                if (indexedSeriesArray[i].values.length == stringArray.length) continue;
                throw new IllegalArgumentException("series doesn't match categories");
            }
        }

        public Comparable getRowKey(int n) {
            return this.series[n].name;
        }

        public int getRowIndex(Comparable comparable) {
            for (int i = 0; i < this.series.length; ++i) {
                if (!this.series[i].name.equals(comparable)) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        public List getRowKeys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.series.length; ++i) {
                arrayList.add(this.series[i].name);
            }
            return arrayList;
        }

        public Comparable getColumnKey(int n) {
            return this.categories[n];
        }

        public int getColumnIndex(Comparable comparable) {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!this.categories[i].equals(comparable)) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        public List getColumnKeys() {
            return Arrays.asList(this.categories);
        }

        public Number getValue(Comparable comparable, Comparable comparable2) {
            return this.getValue(this.getRowIndex(comparable), this.getColumnIndex(comparable2));
        }

        public Number getValue(int n, int n2) {
            return new Float(this.series[n].get(n2));
        }

        public int getRowCount() {
            return this.series.length;
        }

        public int getColumnCount() {
            return this.categories.length;
        }
    }

    private static class TableXYDatasetImpl
    extends AbstractXYDataset
    implements TableXYDataset {
        private IndexedSeries[] series;
        private int start;
        private int length;

        public TableXYDatasetImpl(IndexedSeries[] indexedSeriesArray) {
            this.series = indexedSeriesArray;
            if (indexedSeriesArray.length > 0) {
                this.start = indexedSeriesArray[0].start;
                this.length = indexedSeriesArray[0].values.length;
                for (int i = 1; i < indexedSeriesArray.length; ++i) {
                    if (indexedSeriesArray[i].start == this.start && indexedSeriesArray[i].values.length == this.length) continue;
                    throw new IllegalArgumentException("series can't be combined into table dataset");
                }
            }
        }

        public int getItemCount() {
            return this.length;
        }

        public int getSeriesCount() {
            return this.series.length;
        }

        public String getSeriesName(int n) {
            return this.series[n].name;
        }

        public int getItemCount(int n) {
            return this.length;
        }

        public Number getX(int n, int n2) {
            return new Integer(this.start + n2);
        }

        public Number getY(int n, int n2) {
            return new Float(this.series[n].get(this.start + n2));
        }

        public Comparable getSeriesKey(int n) {
            return this.series[n].name;
        }
    }

    private static class PieDatasetImpl
    extends AbstractDataset
    implements PieDataset {
        private IndexedSeries series;
        private String[] categories;

        private PieDatasetImpl(IndexedSeries indexedSeries, String[] stringArray) {
            this.series = indexedSeries;
            this.categories = stringArray;
        }

        public Comparable getKey(int n) {
            return this.categories[n];
        }

        public int getIndex(Comparable comparable) {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!this.categories[i].equals(comparable)) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        public List getKeys() {
            return Arrays.asList(this.categories);
        }

        public Number getValue(Comparable comparable) {
            return this.getValue(this.getIndex(comparable));
        }

        public int getItemCount() {
            return this.categories.length;
        }

        public Number getValue(int n) {
            return new Float(this.series.get(n));
        }
    }
}

