/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.Workbench;
import genj.app.WorkbenchListener;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Property;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.Trackable;
import genj.util.swing.Action2;
import genj.util.swing.HeapStatusWidget;
import genj.util.swing.ProgressWidget;
import genj.view.ActionProvider;
import genj.view.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import spin.Spin;

class StatusBar
extends JPanel
implements GedcomMetaListener,
WorkbenchListener,
ActionProvider {
    private static final Resources RES = Resources.get(StatusBar.class);
    private static final Registry REGISTRY = Registry.get(StatusBar.class);
    private int commits;
    private JLabel[] label = new JLabel[Gedcom.ENTITIES.length];
    private JLabel changes = new JLabel("", 4);
    private HeapStatusWidget heap = new HeapStatusWidget();

    StatusBar(Workbench workbench) {
        super(new BorderLayout());
        JPanel jPanel = new JPanel();
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            this.label[i] = new JLabel("0", Gedcom.getEntityImage(Gedcom.ENTITIES[i]), 2);
            jPanel.add(this.label[i]);
        }
        this.add((Component)jPanel, "West");
        this.add((Component)this.changes, "Center");
        this.add((Component)this.heap, "East");
        this.setVisible(REGISTRY.get("visible", true));
        workbench.addWorkbenchListener(this);
    }

    public void processStarted(Workbench workbench, Trackable trackable) {
        this.remove(2);
        this.add((Component)new ProgressWidget(trackable), "East");
        this.revalidate();
        this.repaint();
        this.setVisible(true);
    }

    public void processStopped(Workbench workbench, Trackable trackable) {
        this.remove(2);
        this.add((Component)this.heap, "East");
        this.revalidate();
        this.repaint();
        this.setVisible(REGISTRY.get("visible", true));
    }

    private void update(Gedcom gedcom) {
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            String string = Gedcom.ENTITIES[i];
            int n = gedcom.getEntities(string).size();
            int n2 = gedcom.getPropertyCount(string);
            if (n2 == 0) {
                this.label[i].setText(Integer.toString(n));
                this.label[i].setToolTipText(Gedcom.getName(string, true));
                continue;
            }
            this.label[i].setText(n + "/" + n2);
            this.label[i].setToolTipText(Gedcom.getName(string, true) + " (" + RES.getString("cc.tip.record_inline") + ")");
        }
        this.changes.setText(this.commits > 0 ? RES.getString("stat.commits", new Integer(this.commits)) : "");
    }

    public void gedcomWriteLockReleased(Gedcom gedcom) {
        ++this.commits;
        this.update(gedcom);
    }

    public void gedcomHeaderChanged(Gedcom gedcom) {
    }

    public void gedcomBeforeUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomAfterUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomWriteLockAcquired(Gedcom gedcom) {
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
    }

    public void commitRequested(Workbench workbench) {
    }

    public void gedcomClosed(Workbench workbench, Gedcom gedcom) {
        gedcom.removeGedcomListener((GedcomListener)Spin.over((Object)this));
        this.commits = 0;
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            this.label[i].setText("-");
        }
        this.changes.setText("");
    }

    public void gedcomOpened(Workbench workbench, Gedcom gedcom) {
        gedcom.addGedcomListener((GedcomListener)Spin.over((Object)this));
        this.update(gedcom);
    }

    public void selectionChanged(Workbench workbench, Context context, boolean bl) {
    }

    public void viewClosed(Workbench workbench, View view) {
    }

    public void viewOpened(Workbench workbench, View view) {
    }

    public void workbenchClosing(Workbench workbench) {
    }

    public void createActions(Context context, ActionProvider.Purpose purpose, Action2.Group group) {
        if (purpose == ActionProvider.Purpose.MENU) {
            ActionProvider.ViewActionGroup viewActionGroup = new ActionProvider.ViewActionGroup();
            viewActionGroup.add(new Visible());
            group.add(viewActionGroup);
        }
    }

    private class Visible
    extends Action2 {
        protected Visible() {
            this.setText(RES, "statusbar");
            this.setSelected(REGISTRY.get("visible", true));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = !REGISTRY.get("visible", true);
            REGISTRY.put("visible", bl);
            StatusBar.this.setVisible(bl);
        }
    }
}

