/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.App;
import genj.lnf.LnF;
import genj.option.Option;
import genj.option.OptionProvider;
import genj.option.PropertyOption;
import genj.util.EnvironmentChecker;
import genj.util.Resources;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
extends OptionProvider {
    private static final Logger LOG = Logger.getLogger("genj.app");
    private static final String SWING_RESOURCES_KEY_PREFIX = "swing.";
    private static final Options instance = new Options();
    private Resources resources;
    private int maxLogSizeKB = 128;
    private int lookAndFeel = -1;
    private int language = -1;
    private static String[] languages;
    private static final String[] codes;

    private static String[] findCodes() {
        File file;
        Object object;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.add("en");
        File[] fileArray = new File(EnvironmentChecker.getProperty("genj.language.dir", "language", "Dev-time language directory switch")).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                object = fileArray[i].getName();
                LOG.fine("Found language directory " + fileArray[i].getAbsolutePath());
                treeSet.add(object);
            }
        }
        if ((object = (file = new File("lib").getAbsoluteFile()).listFiles()) != null) {
            LOG.fine("Looking for language archives in " + file.getAbsolutePath());
            for (File file2 : object) {
                String string = file2.getName();
                if (!string.startsWith("genj_") || !string.endsWith(".jar")) continue;
                LOG.fine("Found language archive " + file2.getAbsolutePath());
                treeSet.add(string.substring(5, string.length() - 4));
            }
        } else {
            LOG.fine("No language archives in " + file.getAbsolutePath());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public static Options getInstance() {
        return instance;
    }

    public int getLookAndFeel() {
        if (this.lookAndFeel < 0) {
            this.setLookAndFeel(0);
        }
        return this.lookAndFeel;
    }

    public void setLookAndFeel(int n) {
        LnF[] lnFArray = LnF.getLnFs();
        if (n < 0 || n > lnFArray.length - 1) {
            n = 0;
        }
        lnFArray[n].apply(null);
        this.lookAndFeel = n;
    }

    public LnF[] getLookAndFeels() {
        return LnF.getLnFs();
    }

    public void setLanguage(int n) {
        Object object;
        if (n >= 0 && n < codes.length && ((String)(object = codes[n])).length() > 0) {
            App.LOG.info("Switching language to " + (String)object);
            Object object2 = Locale.getDefault().getCountry();
            int n2 = ((String)object).indexOf(95);
            if (n2 > 0) {
                object2 = ((String)object).substring(n2 + 1);
                object = ((String)object).substring(0, n2);
            }
            try {
                Locale.setDefault(new Locale((String)object, (String)object2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.language = n;
        object = Resources.get(this);
        for (String string : ((Resources)object).getKeys()) {
            if (string.indexOf(SWING_RESOURCES_KEY_PREFIX) != 0) continue;
            UIManager.put(string.substring(SWING_RESOURCES_KEY_PREFIX.length()), ((Resources)object).getString(string));
        }
    }

    public int getLanguage() {
        return this.language;
    }

    public String[] getLanguages() {
        if (languages == null) {
            Resources resources = this.getResources();
            String[] stringArray = new String[codes.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = resources.getString("option.language." + codes[i], false);
                stringArray[i] = string != null ? string : codes[i];
            }
            languages = stringArray;
        }
        return languages;
    }

    public int getMaxLogSizeKB() {
        return this.maxLogSizeKB;
    }

    public void setMaxLogSizeKB(int n) {
        this.maxLogSizeKB = Math.max(128, n);
    }

    public String getHttpProxy() {
        String string = System.getProperty("http.proxyHost");
        String string2 = System.getProperty("http.proxyPort");
        if (string == null) {
            return "";
        }
        return string2 != null && string2.length() > 0 ? string + ":" + string2 : string;
    }

    public void setHttpProxy(String string) {
        String string2;
        int n = string.indexOf(":");
        String string3 = n >= 0 ? string.substring(n + 1) : "";
        String string4 = string2 = n >= 0 ? string.substring(0, n) : string;
        if (string2.length() == 0) {
            string3 = "";
        }
        System.setProperty("http.proxyHost", string2);
        System.setProperty("http.proxyPort", string3);
    }

    private Resources getResources() {
        if (this.resources == null) {
            this.resources = Resources.get(this);
        }
        return this.resources;
    }

    @Override
    public List<? extends Option> getOptions() {
        ArrayList<PropertyOption> arrayList = new ArrayList<PropertyOption>(PropertyOption.introspect(instance));
        return arrayList;
    }

    static {
        codes = Options.findCodes();
    }
}

