/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableColumn;

public class ColumnSetup {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$table$ColumnSetup == null ? (class$org$apache$fop$layoutmgr$table$ColumnSetup = ColumnSetup.class$("org.apache.fop.layoutmgr.table.ColumnSetup")) : class$org$apache$fop$layoutmgr$table$ColumnSetup));
    private Table table;
    private List columns = new ArrayList();
    private int maxColIndexReferenced = 0;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$ColumnSetup;

    public ColumnSetup(Table table) {
        this.table = table;
        this.prepareExplicitColumns();
        if (this.getColumnCount() == 0) {
            this.createColumnsFromFirstRow();
        }
    }

    private void prepareExplicitColumns() {
        List rawCols = this.table.getColumns();
        if (rawCols != null) {
            int colnum = 1;
            ListIterator iter = rawCols.listIterator();
            while (iter.hasNext()) {
                TableColumn col = (TableColumn)iter.next();
                if (col != null) {
                    colnum = col.getColumnNumber();
                }
                for (int i = 0; i < col.getNumberColumnsRepeated(); ++i) {
                    while (colnum > this.columns.size()) {
                        this.columns.add(null);
                    }
                    this.columns.set(colnum - 1, col);
                    ++colnum;
                }
            }
            int pos = 1;
            ListIterator ppIter = this.columns.listIterator();
            while (ppIter.hasNext()) {
                TableColumn col = (TableColumn)ppIter.next();
                if (col == null) {
                    log.error((Object)("Found a gap in the table-columns at position " + pos));
                }
                ++pos;
            }
        }
    }

    public TableColumn getColumn(int index) {
        int size = this.columns.size();
        if (index > size) {
            if (index > this.maxColIndexReferenced) {
                this.maxColIndexReferenced = index;
                if (size != 1 || !this.getColumn(1).isDefaultColumn()) {
                    log.warn((Object)FONode.decorateWithContextInfo("There are fewer table-columns than are needed. Column " + index + " was accessed although only " + size + " columns have been defined. " + "The last defined column will be reused.", this.table));
                    if (!this.table.isAutoLayout()) {
                        log.warn((Object)"Please note that according XSL-FO 1.0 (7.26.9) says that the 'column-width' property must be specified for every column, unless the automatic table layout is used.");
                    }
                }
            }
            return (TableColumn)this.columns.get(size - 1);
        }
        return (TableColumn)this.columns.get(index - 1);
    }

    public String toString() {
        return this.columns.toString();
    }

    public int getColumnCount() {
        if (this.maxColIndexReferenced > this.columns.size()) {
            return this.maxColIndexReferenced;
        }
        return this.columns.size();
    }

    public Iterator iterator() {
        return this.columns.iterator();
    }

    private void createColumnsFromFirstRow() {
        if (this.columns.size() == 0) {
            this.columns.add(this.table.getDefaultColumn());
        }
    }

    public int getXOffset(int col, PercentBaseContext context) {
        int xoffset = 0;
        for (int i = 1; i < col; ++i) {
            if (this.getColumn(i) == null) continue;
            xoffset += this.getColumn(i).getColumnWidth().getValue(context);
        }
        return xoffset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

