/*
 * Decompiled with CFR 0.152.
 */
package gj.layout.tree;

import gj.layout.AbstractLayout;
import gj.layout.Layout;
import gj.layout.LayoutException;
import gj.layout.tree.Algorithm;
import gj.layout.tree.ArcOptions;
import gj.layout.tree.Branch;
import gj.layout.tree.NodeOptions;
import gj.layout.tree.Orientation;
import gj.layout.tree.Tree;
import gj.model.Arc;
import gj.model.Graph;
import gj.model.Node;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TreeLayout
extends AbstractLayout
implements Layout {
    private int latPadding = 20;
    private int lonPadding = 20;
    private double lonAlignment = 0.5;
    private double latAlignment = -1.0;
    private boolean isIgnoreUnreachables = false;
    private NodeOptions nodeOptions = null;
    private ArcOptions arcOptions = new DefaultArcOptions();
    boolean isBalanceChildren = true;
    private boolean isBendArcs = true;
    private double orientation = 0.0;
    Node declaredRoot = null;
    Graph appliedTo = null;
    List debugShapes = new ArrayList();
    private boolean isComplement = false;

    public int getLatPadding() {
        return this.latPadding;
    }

    public void setLatPadding(int set) {
        this.latPadding = set;
    }

    public int getLonPadding() {
        return this.lonPadding;
    }

    public void setLonPadding(int set) {
        this.lonPadding = set;
    }

    public double getLonAlignment() {
        return this.lonAlignment;
    }

    public void setLonAlignment(double set) {
        this.lonAlignment = set;
    }

    public double getLatAlignment() {
        return this.latAlignment;
    }

    public void setLatAlignment(double set) {
        this.latAlignment = set;
    }

    public boolean isIgnoreUnreachables() {
        return this.isIgnoreUnreachables;
    }

    public void setIgnoreUnreachables(boolean set) {
        this.isIgnoreUnreachables = set;
    }

    public boolean getBalanceChildren() {
        return this.isBalanceChildren;
    }

    public void setBalanceChildren(boolean set) {
        this.isBalanceChildren = set;
    }

    public boolean isBendArcs() {
        return this.isBendArcs;
    }

    public void setBendArcs(boolean set) {
        this.isBendArcs = set;
    }

    public void setRoot(Node node) {
        this.declaredRoot = node;
    }

    public Node getRoot() {
        return this.declaredRoot;
    }

    public void setNodeOptions(NodeOptions no) {
        this.nodeOptions = no;
    }

    public NodeOptions getNodeOptions() {
        return this.nodeOptions != null ? this.nodeOptions : new DefaultNodeOptions();
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(double theta) {
        this.orientation = theta;
    }

    public void setArcOptions(ArcOptions ao) {
        this.arcOptions = ao;
    }

    public Rectangle2D layout(Node root, int estimatedSize) throws LayoutException {
        Orientation orientn = new Orientation(this.orientation);
        NodeOptions nopt = this.getNodeOptions();
        Algorithm algorithm = new Algorithm(orientn, nopt, this.arcOptions, this.latAlignment, this.isBalanceChildren, this.isBendArcs);
        Tree tree = new Tree(root, nopt, orientn, estimatedSize);
        return algorithm.layout(tree, null);
    }

    public void layout(Graph graph) throws LayoutException {
        this.appliedTo = graph;
        this.debugShapes.clear();
        if (graph.getNodes().isEmpty()) {
            return;
        }
        Orientation orientn = new Orientation(this.orientation);
        NodeOptions nopt = this.getNodeOptions();
        Algorithm nlayout = new Algorithm(orientn, nopt, this.arcOptions, this.latAlignment, this.isBalanceChildren, this.isBendArcs);
        HashSet unvisited = new HashSet(graph.getNodes());
        Node root = this.getRoot();
        if (root == null || !graph.getNodes().contains(root)) {
            root = (Node)unvisited.iterator().next();
        }
        Rectangle bounds = null;
        while (true) {
            Tree tree = new Tree(graph, root, nopt, orientn);
            unvisited.removeAll(tree.getNodes());
            Rectangle r = nlayout.layout(tree, this.isDebug() ? this.debugShapes : null);
            if (bounds == null) {
                bounds = r;
            } else {
                bounds.add((Rectangle2D)r);
            }
            if (this.isIgnoreUnreachables || unvisited.isEmpty()) break;
            root = (Node)unvisited.iterator().next();
        }
        graph.getBounds().setRect(bounds);
    }

    private class DefaultArcOptions
    implements ArcOptions {
        private DefaultArcOptions() {
        }

        public Point2D getPort(Arc arc, Node node, Orientation o) {
            if (arc instanceof ArcOptions) {
                return ((ArcOptions)((Object)arc)).getPort(arc, node, o);
            }
            return node.getPosition();
        }
    }

    private class DefaultNodeOptions
    implements NodeOptions {
        private int[] pad;

        private DefaultNodeOptions() {
            this.pad = new int[]{TreeLayout.this.latPadding / 2, TreeLayout.this.lonPadding / 2, TreeLayout.this.lonPadding / 2, TreeLayout.this.latPadding / 2};
        }

        public int[] getPadding(Node node, Orientation o) {
            if (node instanceof NodeOptions) {
                return ((NodeOptions)((Object)node)).getPadding(node, o);
            }
            return this.pad;
        }

        public int getLongitude(Node node, Branch[] children, Orientation o) {
            if (node instanceof NodeOptions) {
                return ((NodeOptions)((Object)node)).getLongitude(node, children, o);
            }
            return Branch.getLongitude(children, TreeLayout.this.lonAlignment, o);
        }
    }
}

