/*
 * Decompiled with CFR 0.152.
 */
package com.nm.resedit;

import com.nm.resedit.ResourceArchive;
import com.nm.resedit.ResourceDir;
import com.nm.resedit.ResourceDirView;
import com.nm.resedit.ResourceFile;
import com.nm.resedit.ResourceFileView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ResourceArchiveView
extends JSplitPane {
    private ResourceArchive archive;
    private ResourceDirView dirView;
    private ResourceFileView fileView;
    private JTextField tChange;
    private JButton bChange;
    private JPanel pLeft;

    public ResourceArchiveView() {
        Listener listener = new Listener();
        this.dirView = new ResourceDirView();
        this.dirView.addTreeSelectionListener(listener);
        this.pLeft = new JPanel(new BorderLayout());
        this.pLeft.add("Center", new JScrollPane(this.dirView));
        this.fileView = new ResourceFileView();
        this.fileView.addListSelectionListener(listener);
        this.tChange = new JTextField();
        this.tChange.setEditable(false);
        this.tChange.addActionListener(listener);
        this.bChange = new JButton("Change");
        this.bChange.setMargin(new Insets(0, 0, 0, 0));
        this.bChange.setFont(this.fileView.getFont());
        this.bChange.setEnabled(false);
        this.bChange.addActionListener(listener);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", this.tChange);
        jPanel.add("East", this.bChange);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("Center", new JScrollPane(this.fileView, 22, 32));
        jPanel2.add("South", jPanel);
        this.setLeftComponent(this.pLeft);
        this.setRightComponent(jPanel2);
        this.setDividerLocation(64);
    }

    public void addExtension(Component component) {
        this.pLeft.add("South", component);
    }

    public void setArchive(ResourceArchive resourceArchive) {
        this.archive = resourceArchive;
        this.dirView.setResourceArchive(resourceArchive);
        if (resourceArchive != null) {
            this.setDividerLocation(this.dirView.getPreferredSize().width);
        }
    }

    public void fireTranslationHappened() {
        this.firePropertyChange("translation", "1", "2");
    }

    private class Listener
    implements TreeSelectionListener,
    ListSelectionListener,
    ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceFile resourceFile = ResourceArchiveView.this.fileView.getResourceFile();
            int n = ResourceArchiveView.this.fileView.getSelectedIndex();
            if (n >= 0) {
                resourceFile.setLineTranslation(n, ResourceArchiveView.this.tChange.getText());
            }
            ResourceArchiveView.this.fileView.incSelection();
            ResourceArchiveView.this.fireTranslationHappened();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (ResourceArchiveView.this.dirView.getSelectionCount() == 1) {
                ResourceDir resourceDir = (ResourceDir)ResourceArchiveView.this.dirView.getLastSelectedPathComponent();
                ResourceArchiveView.this.fileView.setResourceFile(resourceDir.getResourceFile());
            } else {
                ResourceArchiveView.this.fileView.setResourceFile(null);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            String string = null;
            boolean bl = false;
            if (ResourceArchiveView.this.fileView.getSelectedIndex() >= 0) {
                int n;
                ResourceFile resourceFile = ResourceArchiveView.this.fileView.getResourceFile();
                bl = resourceFile.getLineState(n = ResourceArchiveView.this.fileView.getSelectedIndex()) != -1;
                string = resourceFile.getLineTranslation(n);
            }
            ResourceArchiveView.this.tChange.setText(string);
            ResourceArchiveView.this.tChange.setEditable(bl);
            ResourceArchiveView.this.tChange.setCaretPosition(0);
            ResourceArchiveView.this.bChange.setEnabled(bl);
        }
    }
}

