/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.util.List;

public class BasicStyle
implements Style {
    private boolean renderingFill = true;
    private boolean renderingLine = true;
    private boolean renderingLinePattern = false;
    private boolean renderingFillPattern = false;
    private Color fillColor = new Color(0, 0, 0, 255);
    private Color lineColor = new Color(0, 0, 0, 255);
    private BasicStroke lineStroke;
    private Stroke fillStroke = new BasicStroke(1.0f);
    private boolean enabled = true;
    private String linePattern = "3";

    public BasicStyle(Color color) {
        this.setFillColor(color);
        this.setLineColor(Layer.defaultLineColor(color));
        this.setLineWidth(1);
    }

    public BasicStyle() {
        this(Color.black);
    }

    public boolean isRenderingFillPattern() {
        return this.renderingFillPattern;
    }

    public BasicStyle setRenderingFillPattern(boolean bl) {
        this.renderingFillPattern = bl;
        return this;
    }

    public String getLinePattern() {
        return this.linePattern;
    }

    public BasicStyle setLinePattern(String string) {
        this.linePattern = string;
        this.lineStroke = this.createLineStroke(this.lineStroke.getLineWidth());
        return this;
    }

    public void initialize(Layer layer) {
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void paint(Feature feature, Graphics2D graphics2D, Viewport viewport) throws NoninvertibleTransformException {
        StyleUtil.paint(feature.getGeometry(), graphics2D, viewport, this.renderingFill, this.fillStroke, this.fillColor, this.renderingLine, this.lineStroke, this.lineColor);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public boolean isRenderingFill() {
        return this.renderingFill;
    }

    public boolean isRenderingLine() {
        return this.renderingLine;
    }

    public boolean isRenderingLinePattern() {
        return this.renderingLinePattern;
    }

    public void setRenderingFill(boolean bl) {
        this.renderingFill = bl;
    }

    public void setRenderingLine(boolean bl) {
        this.renderingLine = bl;
    }

    public BasicStyle setRenderingLinePattern(boolean bl) {
        this.renderingLinePattern = bl;
        this.lineStroke = this.createLineStroke(this.lineStroke.getLineWidth());
        return this;
    }

    public void setFillColor(Color color) {
        this.setFillColor(color, this.getAlpha());
    }

    private BasicStyle setFillColor(Color color, int n) {
        this.fillColor = GUIUtil.alphaColor(color, n);
        return this;
    }

    public void setLineColor(Color color) {
        this.lineColor = GUIUtil.alphaColor(color, this.getAlpha());
    }

    public void setLineWidth(int n) {
        this.lineStroke = this.createLineStroke(n);
    }

    private BasicStroke createLineStroke(float f) {
        return this.renderingLinePattern && this.linePattern.trim().length() != 0 && f > 0.0f ? new BasicStroke(f, 0, 2, 1.0f, BasicStyle.toArray(this.linePattern, f), 0.0f) : new BasicStroke(f, 0, 2);
    }

    public static float[] toArray(String string, float f) {
        List list = StringUtil.fromCommaDelimitedString(string);
        float[] fArray = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            fArray[i] = Float.parseFloat(string2) * f;
            if (!(fArray[i] <= 0.0f)) continue;
            throw new IllegalArgumentException("Negative dash length");
        }
        return fArray;
    }

    public int getAlpha() {
        return this.fillColor.getAlpha();
    }

    public Color getFillColor() {
        return GUIUtil.alphaColor(this.fillColor, 255);
    }

    public Color getLineColor() {
        return GUIUtil.alphaColor(this.lineColor, 255);
    }

    public int getLineWidth() {
        return (int)this.lineStroke.getLineWidth();
    }

    public void setAlpha(int n) {
        this.setFillColor(this.fillColor, n);
        this.lineColor = GUIUtil.alphaColor(this.lineColor, n);
    }

    public BasicStroke getLineStroke() {
        return this.lineStroke;
    }
}

