/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineStringEndpointStyle;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class ArrowLineStringEndpointStyle
extends LineStringEndpointStyle {
    private static final double SMALL_ANGLE = 10.0;
    private static final double MEDIUM_ANGLE = 30.0;
    private static final double MEDIUM_LENGTH = 10.0;
    private static final double LARGE_LENGTH = 15.0;
    private boolean filled;
    private double finAngle;
    protected double finLength;

    public ArrowLineStringEndpointStyle(String string, boolean bl, String string2, double d, double d2, boolean bl2) {
        super(string, null, bl);
        this.finAngle = d;
        this.finLength = d2;
        this.filled = bl2;
    }

    protected void paint(Point2D point2D, Point2D point2D2, Viewport viewport, Graphics2D graphics2D) throws NoninvertibleTransformException {
        if (point2D.equals(point2D2)) {
            return;
        }
        graphics2D.setColor(this.lineColorWithAlpha);
        graphics2D.setStroke(this.stroke);
        GeneralPath generalPath = this.arrowhead(point2D, point2D2, this.finLength, this.finAngle);
        if (this.filled) {
            generalPath.closePath();
            graphics2D.fill(generalPath);
        }
        graphics2D.draw(generalPath);
    }

    private GeneralPath arrowhead(Point2D point2D, Point2D point2D2, double d, double d2) {
        GeneralPath generalPath = new GeneralPath();
        Point2D point2D3 = this.fin(point2D, point2D2, d, d2);
        Point2D point2D4 = this.fin(point2D, point2D2, d, -d2);
        generalPath.moveTo((float)point2D3.getX(), (float)point2D3.getY());
        generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
        return generalPath;
    }

    private Point2D fin(Point2D point2D, Point2D point2D2, double d, double d2) {
        double d3 = point2D.distance(point2D2);
        Point2D point2D3 = point2D;
        Point2D point2D4 = GUIUtil.add(GUIUtil.multiply(GUIUtil.subtract(point2D2, point2D), d / d3), point2D3);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d2 * Math.PI / 180.0, point2D3.getX(), point2D3.getY());
        return affineTransform.transform(point2D4, null);
    }

    public static class NarrowSolidEnd
    extends ArrowLineStringEndpointStyle {
        public NarrowSolidEnd() {
            super("End-Arrow-Solid-Narrow", false, "ArrowEndSolidNarrow.gif", 10.0, 15.0, true);
        }
    }

    public static class NarrowSolidStart
    extends ArrowLineStringEndpointStyle {
        public NarrowSolidStart() {
            super("Start-Arrow-Solid-Narrow", true, "ArrowStartSolidNarrow.gif", 10.0, 15.0, true);
        }
    }

    public static class SolidEnd
    extends ArrowLineStringEndpointStyle {
        public SolidEnd() {
            super("End-Arrow-Solid", false, "ArrowEndSolid.gif", 30.0, 10.0, true);
        }
    }

    public static class SolidStart
    extends ArrowLineStringEndpointStyle {
        public SolidStart() {
            super("Start-Arrow-Solid", true, "ArrowStartSolid.gif", 30.0, 10.0, true);
        }
    }

    public static class OpenEnd
    extends ArrowLineStringEndpointStyle {
        public OpenEnd() {
            super("End-Arrow-Open", false, "ArrowEndOpen.gif", 30.0, 10.0, false);
        }
    }

    public static class OpenStart
    extends ArrowLineStringEndpointStyle {
        public OpenStart() {
            super("Start-Arrow-Open", true, "ArrowStartOpen.gif", 30.0, 10.0, false);
        }
    }

    public static class FeathersEnd
    extends Feathers {
        public FeathersEnd() {
            super("End-Feathers", true, "FeathersEnd.gif");
        }
    }

    public static class FeathersStart
    extends Feathers {
        public FeathersStart() {
            super("Start-Feathers", true, "FeathersStart.gif");
        }
    }

    public static abstract class Feathers
    extends ArrowLineStringEndpointStyle {
        private static final int SPACING = 5;
        private static final int FEATHERS = 2;

        public Feathers(String string, boolean bl, String string2) {
            super(string, bl, string2, 30.0, 10.0, false);
        }

        protected void paint(Point2D point2D, Point2D point2D2, Viewport viewport, Graphics2D graphics2D) throws NoninvertibleTransformException {
            for (int i = 0; i < 2; ++i) {
                Point2D point2D3 = GUIUtil.multiply(GUIUtil.subtract(point2D2, point2D), 1.0 / point2D2.distance(point2D));
                Point2D point2D4 = GUIUtil.add(point2D, GUIUtil.multiply(point2D3, this.finLength + (double)(i * 5)));
                super.paint(point2D4, point2D, viewport, graphics2D);
            }
        }

        public void initialize(Layer layer) {
            super.initialize(layer);
            this.stroke = new BasicStroke(1.0f, 1, 1);
        }
    }
}

