/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.Java2DConverter;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Viewport
implements Java2DConverter.PointConverter {
    private static final int INITIAL_VIEW_ORIGIN_X = 0;
    private static final int INITIAL_VIEW_ORIGIN_Y = 0;
    private ArrayList listeners = new ArrayList();
    private Java2DConverter java2DConverter;
    private LayerViewPanel panel;
    private Point2D viewOriginAsPerceivedByModel = new Point2D.Double(0.0, 0.0);
    private double scale = 1.0;
    private AffineTransform modelToViewTransform;

    public Viewport(LayerViewPanel layerViewPanel) {
        this.panel = layerViewPanel;
        this.java2DConverter = new Java2DConverter(this);
        layerViewPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Viewport.this.fireZoomChanged(Viewport.this.getEnvelopeInModelCoordinates());
            }
        });
    }

    public LayerViewPanel getPanel() {
        return this.panel;
    }

    public void addListener(ViewportListener viewportListener) {
        this.listeners.add(viewportListener);
    }

    public void removeListener(ViewportListener viewportListener) {
        this.listeners.remove(viewportListener);
    }

    public Java2DConverter getJava2DConverter() {
        return this.java2DConverter;
    }

    public void update() throws NoninvertibleTransformException {
        this.modelToViewTransform = Viewport.modelToViewTransform(this.scale, this.viewOriginAsPerceivedByModel, this.panel.getSize().height);
        this.panel.repaint();
    }

    public static AffineTransform modelToViewTransform(double d, Point2D point2D, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(0.0, d2);
        affineTransform.scale(1.0, -1.0);
        affineTransform.scale(d, d);
        affineTransform.translate(-point2D.getX(), -point2D.getY());
        return affineTransform;
    }

    public double getScale() {
        return this.scale;
    }

    public void initialize(double d, Point2D point2D) {
        this.setScale(d);
        this.viewOriginAsPerceivedByModel = point2D;
    }

    public Point2D getOriginInModelCoordinates() {
        return this.viewOriginAsPerceivedByModel;
    }

    public void zoom(Point2D point2D, double d, double d2) throws NoninvertibleTransformException {
        double d3 = Math.min((double)this.panel.getSize().width / d, (double)this.panel.getSize().height / d2);
        double d4 = (double)this.panel.getSize().width / d3;
        double d5 = (double)this.panel.getSize().height / d3;
        this.zoom(this.toModelEnvelope(point2D.getX() - 0.5 * d4, point2D.getX() + 0.5 * d4, point2D.getY() - 0.5 * d5, point2D.getY() + 0.5 * d5));
    }

    public Point2D toModelPoint(Point2D point2D) throws NoninvertibleTransformException {
        return this.getModelToViewTransform().inverseTransform(this.toPoint2DDouble(point2D), null);
    }

    private Point2D.Double toPoint2DDouble(Point2D point2D) {
        if (point2D instanceof Point2D.Double) {
            return (Point2D.Double)point2D;
        }
        return new Point2D.Double(point2D.getX(), point2D.getY());
    }

    public Coordinate toModelCoordinate(Point2D point2D) throws NoninvertibleTransformException {
        return CoordUtil.toCoordinate(this.toModelPoint(point2D));
    }

    public Point2D toViewPoint(Point2D point2D) throws NoninvertibleTransformException {
        return this.getModelToViewTransform().transform(this.toPoint2DDouble(point2D), null);
    }

    public Point2D toViewPoint(Coordinate coordinate) throws NoninvertibleTransformException {
        return this.toViewPoint(new Point2D.Double(coordinate.x, coordinate.y));
    }

    public Envelope toModelEnvelope(double d, double d2, double d3, double d4) throws NoninvertibleTransformException {
        Coordinate coordinate = this.toModelCoordinate(new Point2D.Double(d, d3));
        Coordinate coordinate2 = this.toModelCoordinate(new Point2D.Double(d2, d4));
        return new Envelope(coordinate, coordinate2);
    }

    public AffineTransform getModelToViewTransform() throws NoninvertibleTransformException {
        if (this.modelToViewTransform == null) {
            this.update();
        }
        return this.modelToViewTransform;
    }

    public Envelope getEnvelopeInModelCoordinates() {
        double d = (double)this.panel.getWidth() / this.scale;
        double d2 = (double)this.panel.getHeight() / this.scale;
        return new Envelope(this.viewOriginAsPerceivedByModel.getX(), this.viewOriginAsPerceivedByModel.getX() + d, this.viewOriginAsPerceivedByModel.getY(), this.viewOriginAsPerceivedByModel.getY() + d2);
    }

    public void zoom(Envelope envelope) throws NoninvertibleTransformException {
        if (envelope.isNull()) {
            return;
        }
        this.setScale(Math.min((double)this.panel.getWidth() / envelope.getWidth(), (double)this.panel.getHeight() / envelope.getHeight()));
        double d = ((double)this.panel.getWidth() / this.scale - envelope.getWidth()) / 2.0;
        double d2 = ((double)this.panel.getHeight() / this.scale - envelope.getHeight()) / 2.0;
        this.viewOriginAsPerceivedByModel = new Point2D.Double(envelope.getMinX() - d, envelope.getMinY() - d2);
        this.update();
        this.fireZoomChanged(envelope);
    }

    private void setScale(double d) {
        this.scale = d;
    }

    private void fireZoomChanged(Envelope envelope) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ViewportListener viewportListener = (ViewportListener)iterator.next();
            viewportListener.zoomChanged(envelope);
        }
    }

    public void zoomToFullExtent() throws NoninvertibleTransformException {
        this.zoom(this.fullExtent());
    }

    public Envelope fullExtent() {
        return EnvelopeUtil.bufferByFraction(this.panel.getLayerManager().getEnvelopeOfAllLayers(), 0.03);
    }

    public void zoomToViewPoint(Point2D point2D, double d) throws NoninvertibleTransformException {
        double d2 = (double)this.panel.getWidth() / d;
        double d3 = (double)this.panel.getHeight() / d;
        this.zoom(point2D, d2, d3);
    }

    public Collection toViewPoints(Collection collection) throws NoninvertibleTransformException {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Coordinate coordinate = (Coordinate)iterator.next();
            arrayList.add(this.toViewPoint(coordinate));
        }
        return arrayList;
    }

    public Rectangle2D toViewRectangle(Envelope envelope) throws NoninvertibleTransformException {
        Point2D point2D = this.toViewPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        Point2D point2D2 = this.toViewPoint(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
        return new Rectangle2D.Double(Math.min(point2D.getX(), point2D2.getX()), Math.min(point2D.getY(), point2D2.getY()), Math.abs(point2D.getX() - point2D2.getX()), Math.abs(point2D.getY() - point2D2.getY()));
    }
}

